/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model.datalocation.raster;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.riwajump.data.model.datalocation.AbstractDataLocation;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.DataLocationType;
import de.riwagis.riwajump.data.model.datalocation.EpsgCrsParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.FileParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.StringParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.raster.RasterDataLocationSupport;
import de.riwagis.util.exception.SystemException;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="DLOCgeotiff")
public class GeoTiffDataLocation
extends AbstractDataLocation {
    private static final Logger LOG = LoggerFactory.getLogger(GeoTiffDataLocation.class);
    public static final String PARAM_LOCATION = "GeoTiff-File";
    public static final String PARAM_LOCATION_RELATIVE = "GeoTiff-File-Relative";
    public static final String PARAM_CRS = "CRS";
    private static final ParameterDescriptor[] PARAMS = new ParameterDescriptor[]{new FileParameterDescriptor("GeoTiff-File", I18N.get("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.geotiff-file-param"), I18N.get("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.geotiff-file-param-desc"), true, new String[]{"tif", "tiff"}), new StringParameterDescriptor("GeoTiff-File-Relative", I18N.get("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.geotiff-filerel-param"), I18N.get("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.geotiff-filerel-param-desc"), true), new EpsgCrsParameterDescriptor("CRS", I18N.get("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.crs-param"), I18N.get("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.crs-param-desc"), false)};

    @Override
    public ParameterDescriptor[] getParameterDescription() {
        return Arrays.copyOf(PARAMS, PARAMS.length);
    }

    @Override
    public Object getDataLocationObject() throws Exception {
        CRSDefinition crsdef;
        File dataLocationFile = this.determineDataLocationFile(PARAM_LOCATION, PARAM_LOCATION_RELATIVE);
        if (dataLocationFile == null || !dataLocationFile.exists()) {
            throw new SystemException(I18N.getMessage("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.does-not-exist", this.getParameterValue(PARAM_LOCATION)));
        }
        Hints hint = new Hints();
        hint.put((Object)Hints.CRS_AUTHORITY_FACTORY, (Object)CRSDefFactory.getCRSAuthorityFactory());
        hint.put((Object)Hints.CRS_FACTORY, (Object)CRSDefFactory.getCRSFactory());
        String strCrs = this.getParameterValue(PARAM_CRS);
        if (StringUtils.isNotBlank((CharSequence)strCrs) && (crsdef = (CRSDefinition)PARAMS[2].parseParameterString(strCrs)).getCRS() != null) {
            hint.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)crsdef.getCRS());
        }
        GeoTiffFormat imageFormat = new GeoTiffFormat();
        AbstractGridCoverage2DReader gcread = imageFormat.getReader((Object)dataLocationFile, hint);
        return gcread;
    }

    @Override
    public String testConnection() {
        try {
            String strPCheck = this.onlyOneOfTwoParametersCheck(PARAM_LOCATION, PARAM_LOCATION_RELATIVE);
            if (strPCheck != null) {
                return strPCheck;
            }
            File dataLocationFile = this.determineDataLocationFile(PARAM_LOCATION, PARAM_LOCATION_RELATIVE);
            if (dataLocationFile == null || !dataLocationFile.exists()) {
                return I18N.getMessage("de.riwagis.riwajump.datalocation.raster.GeoTiffDataLocation.does-not-exist", this.getParameterValue(PARAM_LOCATION));
            }
            AbstractGridCoverage2DReader gcread = (AbstractGridCoverage2DReader)this.getDataLocationObject();
            RasterDataLocationSupport.testGridCoverageReader((GridCoverage2DReader)gcread);
            gcread.dispose();
        }
        catch (Throwable t) {
            LOG.info(String.format("Connection test - error in loading raster: %s", t.getMessage()), t);
            return "Error in loading raster: " + t.getMessage();
        }
        return null;
    }

    @Override
    public DataLocationType getDataLocationType() {
        return DataLocationType.GEOTIFF;
    }

    @Override
    public DataLocation.DataType getDataType() {
        return DataLocation.DataType.RASTER;
    }
}

