/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model.datalocation;

import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.ParameterType;
import java.nio.charset.Charset;

public class CharsetParameterDescriptor
implements ParameterDescriptor {
    private String pName = null;
    private boolean bolRequired = false;
    private String strName = null;
    private String strDescription = null;

    public CharsetParameterDescriptor(String pName, String strName, String strDesc, boolean bolRequired) {
        this.pName = pName;
        this.bolRequired = bolRequired;
        this.strDescription = strDesc;
        this.strName = strName;
    }

    @Override
    public String getParameterName() {
        return this.pName;
    }

    @Override
    public String getName() {
        return this.strName;
    }

    @Override
    public Object parseParameterString(String strParam) throws IllegalArgumentException {
        return Charset.forName(strParam);
    }

    @Override
    public String formatParameterObject(Object pObject) throws IllegalArgumentException {
        return ((Charset)pObject).name();
    }

    @Override
    public boolean required() {
        return this.bolRequired;
    }

    @Override
    public ParameterType getType() {
        return ParameterType.CHARSET;
    }

    @Override
    public String getDescription() {
        return this.strDescription;
    }
}

