/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model.datalocation;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.Parameter;
import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.ParameterType;
import de.riwagis.riwajump.data.model.datalocation.Preference;
import de.riwagis.util.exception.SystemException;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractDataLocation
implements DataLocation {
    private static final Map<ParameterType, Preference> mapPref = new EnumMap<ParameterType, Preference>(ParameterType.class);
    private String name = null;
    @XStreamAlias(value="DLOCparams")
    private List<Parameter> params = new ArrayList<Parameter>();
    private transient File rootDir = null;

    public static void addPreference(Preference pref) {
        mapPref.put(pref.getType(), pref);
    }

    private static Preference getPreference(ParameterType type) {
        return mapPref.get((Object)type);
    }

    protected AbstractDataLocation() {
        ParameterDescriptor[] arrPDesc;
        for (ParameterDescriptor pdesc : arrPDesc = this.getParameterDescription()) {
            Preference pref = AbstractDataLocation.getPreference(pdesc.getType());
            if (pref == null) continue;
            String strPref = ObjectUtils.toString((Object)pref.getPreference());
            this.setParameter(pdesc.getParameterName(), strPref);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String _name) {
        this.name = _name;
    }

    @Override
    public void setParameters(List<Parameter> _params) {
        this.params = new ArrayList<Parameter>(_params);
    }

    public ParameterDescriptor getParameterDescriptor4Name(String strName) {
        for (ParameterDescriptor pd : this.getParameterDescription()) {
            if (!pd.getParameterName().equals(strName)) continue;
            return pd;
        }
        return null;
    }

    @Override
    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.params);
    }

    @Override
    public String getParameterValue(String name) {
        for (Parameter p : this.params) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    @Override
    public Parameter getParameter(String name) {
        for (Parameter p : this.params) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Parameter getOneOfTwoParamters(String strParam1, String strParam2) throws SystemException {
        if (this.onlyOneOfTwoParametersCheck(strParam1, strParam2) != null) {
            throw new SystemException(this.onlyOneOfTwoParametersCheck(strParam1, strParam2));
        }
        String strP1 = this.getParameterValue(strParam1);
        if (strP1 == null || strP1.trim().length() == 0) {
            return this.getParameter(strParam2);
        }
        return this.getParameter(strParam1);
    }

    public final File determineDataLocationFile(String cfgNameAbsolutePath, String cfgNameRelativePath) throws SystemException {
        Parameter pFile = this.getOneOfTwoParamters(cfgNameAbsolutePath, cfgNameRelativePath);
        File dataLocationFile = pFile.getName().equals(cfgNameRelativePath) ? this.getFileFromRootDir(pFile.getValue()) : new File(pFile.getValue());
        return dataLocationFile;
    }

    protected final String onlyOneOfTwoParametersCheck(String strParam1, String strParam2) {
        if (this.getParameterDescriptor4Name(strParam1) == null) {
            return strParam1 + " - invaild parameter name";
        }
        if (this.getParameterDescriptor4Name(strParam2) == null) {
            return strParam2 + " - invaild parameter name";
        }
        String strP1 = this.getParameterValue(strParam1);
        String strP2 = this.getParameterValue(strParam2);
        if (!(strP1 != null && strP1.trim().length() != 0 || strP2 != null && strP2.trim().length() != 0)) {
            return I18N.getMessage("de.riwagis.riwajump.datalocation.raster.only-one-of-two", this.getParameterDescriptor4Name(strParam1).getName(), this.getParameterDescriptor4Name(strParam2).getName());
        }
        if (strP1 == null || strP1.trim().length() == 0) {
            return null;
        }
        if (strP2 == null || strP2.trim().length() == 0) {
            return null;
        }
        return I18N.getMessage("de.riwagis.riwajump.datalocation.raster.only-one-of-two", this.getParameterDescriptor4Name(strParam1).getName(), this.getParameterDescriptor4Name(strParam2).getName());
    }

    @Override
    public final void setParameter(String name, String strValue) throws IllegalArgumentException {
        ParameterDescriptor[] paramDesc = this.getParameterDescription();
        int idx = -1;
        for (int i = 0; i < paramDesc.length; ++i) {
            if (!paramDesc[i].getParameterName().equals(name)) continue;
            idx = i;
        }
        if (idx == -1) {
            throw new IllegalArgumentException(String.format("AbstractDataLocation, invalid parameter attributes. Name: %s Value: %s", name, strValue));
        }
        Preference pref = AbstractDataLocation.getPreference(paramDesc[idx].getType());
        if (pref != null) {
            pref.updatePreference(strValue);
        }
        ArrayList<Parameter> newParams = new ArrayList<Parameter>();
        for (Parameter p : this.params) {
            if (p.getName().equals(name)) continue;
            newParams.add(p);
        }
        newParams.add(new Parameter(name, strValue));
        this.setParameters(newParams);
    }

    @Override
    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    public File getFileFromRootDir(String strRelativePath) throws SystemException {
        if (this.rootDir == null) {
            throw new SystemException("Root dir is null - cannot locate relative path '" + strRelativePath + "'");
        }
        return new File(this.rootDir, strRelativePath);
    }
}

