/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.data.FeatureSource;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformationService.class);
    private final Map<Pair<String, String>, Transformer> transfomerForCRS = new HashMap<Pair<String, String>, Transformer>();

    public Transformer getTransformer(FeaturestoreMetadata fmd, DMDCollection dmdcol) throws NoninvertibleTransformException, FactoryException {
        CRSDefinition targetCRS;
        CRSDefinition sourceCRS;
        if (TransformationService.storeHasOverWrite(fmd)) {
            sourceCRS = CRSDefFactory.getCRSDefinition((String)fmd.getCRSFrom());
            targetCRS = CRSDefFactory.getCRSDefinition((String)fmd.getCRSTo());
        } else {
            sourceCRS = this.getCRSFromDataSource(fmd, dmdcol);
            targetCRS = this.getCRSFromProject(dmdcol);
        }
        String sourceCode = this.getCodeFromCRS(sourceCRS.getCRS());
        String targetCode = this.getCodeFromCRS(targetCRS.getCRS());
        return this.getTransformerFromCache(sourceCode, targetCode);
    }

    public boolean hasTransformation(FeaturestoreMetadata fmd, DMDCollection dmdcol) {
        if (TransformationService.storeHasOverWrite(fmd)) {
            return TransformationService.storeWantsTransformation(fmd);
        }
        CRSDefinition sourceCRS = this.getCRSFromDataSource(fmd, dmdcol);
        CRSDefinition targetCRS = this.getCRSFromProject(dmdcol);
        return this.requiresTransformation(sourceCRS, targetCRS);
    }

    private static boolean storeHasOverWrite(FeaturestoreMetadata fmd) {
        String crsFrom = fmd.getCRSFrom();
        String crsTo = fmd.getCRSTo();
        return !StringUtils.isBlank((CharSequence)crsFrom) && !StringUtils.isBlank((CharSequence)crsTo) && !StringUtils.isBlank((CharSequence)CRSDefFactory.getCRSDefinition((String)crsFrom).getCode()) && !StringUtils.isBlank((CharSequence)CRSDefFactory.getCRSDefinition((String)crsTo).getCode());
    }

    private static boolean storeWantsTransformation(FeaturestoreMetadata fmd) {
        String crsTo;
        String crsFrom = fmd.getCRSFrom();
        return !StringUtils.equals((CharSequence)crsFrom, (CharSequence)(crsTo = fmd.getCRSTo()));
    }

    private boolean requiresTransformation(CRSDefinition sourceCRS, CRSDefinition targetCRS) {
        return sourceCRS != null && targetCRS != null && sourceCRS.getCRS() != null && targetCRS.getCRS() != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS.getCRS(), (Object)targetCRS.getCRS());
    }

    public CRSDefinition getCRSFromProject(DMDCollection dmdcol) {
        Task task = dmdcol.getTask();
        if (task == null) {
            log.debug("DMD Collection does not belong to a task");
            return null;
        }
        return task.getCRSDefinition();
    }

    public CRSDefinition getCRSFromDataSource(FeaturestoreMetadata fmd, DMDCollection dmdcol) {
        try {
            FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = fmd.getFeatureSource(dmdcol);
            if (featureSource == null) {
                log.debug("DataStore {} does not provide feature source", (Object)fmd.getDatastoreName());
                return this.getCRSFromProject(dmdcol);
            }
            CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
            if (sourceCRS == null) {
                log.debug("DataStore {} does not provide CRS used for features", (Object)fmd.getDatastoreName());
                return this.getCRSFromProject(dmdcol);
            }
            String crsCode = this.getCodeFromCRS(sourceCRS);
            if (crsCode == null) {
                log.debug("Could not decode CRS identifier for DataStore {}", (Object)fmd.getDatastoreName());
                return this.getCRSFromProject(dmdcol);
            }
            if (!CRSDefFactory.containsCRSDefinition((String)crsCode)) {
                log.debug("Missing CRS Definition for CRS '{}' of DataStore {}", (Object)crsCode, (Object)fmd.getDatastoreName());
                return this.getCRSFromProject(dmdcol);
            }
            return CRSDefFactory.getCRSDefinition((String)crsCode);
        }
        catch (IOException | RuntimeException e) {
            log.error("Could not determine datasource CRS", (Throwable)e);
            return this.getCRSFromProject(dmdcol);
        }
    }

    private String getCodeFromCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        Set identifiers = crs.getIdentifiers();
        if (identifiers.isEmpty()) {
            return CRS.toSRS((CoordinateReferenceSystem)crs, (boolean)true);
        }
        return ((ReferenceIdentifier)identifiers.iterator().next()).getCode();
    }

    private Transformer getTransformerFromCache(String sourceCode, String targetCode) throws FactoryException, NoninvertibleTransformException {
        Pair key = Pair.of((Object)sourceCode, (Object)targetCode);
        Transformer transformer = this.transfomerForCRS.get(key);
        if (transformer == null) {
            transformer = new Transformer(sourceCode, targetCode);
            this.transfomerForCRS.put((Pair<String, String>)key, transformer);
        }
        return transformer;
    }
}

