/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

public class FeaturestoreMetadataIO {
    private static final XStream xstream = FeaturestoreMetadataIO.createSecuredXStream();

    private FeaturestoreMetadataIO() {
    }

    public static String toXML(FeaturestoreMetadata mData) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            xstream.marshal((Object)mData, (HierarchicalStreamWriter)new CompactWriter((Writer)stringWriter));
            String string = stringWriter.toString();
            return string;
        }
    }

    public static FeaturestoreMetadata fromXML(String strXML) {
        return (FeaturestoreMetadata)xstream.fromXML(strXML);
    }

    public static void toFile(FeaturestoreMetadata mData, String strFileName) throws IOException {
        File file = new File((String)strFileName);
        if (file.isDirectory()) {
            strFileName = (String)strFileName + File.separator + mData.getName() + ".fmd";
        }
        try (PrintWriter out = new PrintWriter((String)strFileName);){
            xstream.marshal((Object)mData, (HierarchicalStreamWriter)new CompactWriter((Writer)out));
        }
    }

    public static FeaturestoreMetadata fromFile(String strFileName) throws IOException {
        try (FileReader in = new FileReader(strFileName);){
            FeaturestoreMetadata featurestoreMetadata = (FeaturestoreMetadata)xstream.fromXML((Reader)in);
            return featurestoreMetadata;
        }
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypeHierarchy(Geometry.class);
        xstream.allowTypes(new Class[]{String.class, Class.class, FeaturestoreMetadata.class});
        xstream.processAnnotations(FeaturestoreMetadata.class);
        return xstream;
    }
}

