/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.EditableStore;
import de.riwagis.geotools.feature.FidFeature;
import de.riwagis.geotools.feature.util.OptimizedSimplifyingFilterVisitor;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.util.bsh.BshCalculator;
import de.riwagis.util.exception.SystemException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.view.DefaultView;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="fmd")
public class FeaturestoreMetadata
implements Cloneable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(FeaturestoreMetadata.class);
    @XStreamAlias(value="name")
    private String strName = "";
    @XStreamAlias(value="dsname")
    private String strDatastoreName = "";
    @XStreamAlias(value="dtname")
    private String strDatatypeName = "";
    @XStreamAlias(value="atts")
    private String[] arrAttributes = null;
    @XStreamAlias(value="editInOtherDatatype")
    private boolean bolEditInOtherDatatype = false;
    @XStreamAlias(value="key_att")
    private String strKeyAtt = null;
    @XStreamAlias(value="key_att_view")
    private String strKeyAttView = null;
    @XStreamAlias(value="key_att_edit")
    private String strKeyAttEdit = null;
    @XStreamAlias(value="dtname_edit")
    private String strDatatypeNameEdit = "";
    @XStreamAlias(value="atts_edit")
    private String[] arrAttributesEdit = null;
    @XStreamAlias(value="filter")
    private String strFilterText = "";
    @XStreamAlias(value="crsFrom")
    private String strCRSFrom = null;
    @XStreamAlias(value="crsTo")
    private String strCRSTo = null;
    @XStreamAlias(value="insertAllowed")
    private boolean insertAllowed = true;
    @XStreamAlias(value="deleteAllowed")
    private boolean deleteAllowed = true;
    @XStreamAlias(value="restrictGeomType")
    private boolean bolRestrictGeomType = false;
    @XStreamAlias(value="geomTypes")
    private Class<?>[] arrGeomTypes = null;
    @XStreamAlias(value="oriTrans")
    private String strOriTrans = null;
    @XStreamAlias(value="oriAtt")
    private String strOriAtt = null;
    @XStreamAlias(value="useText")
    private boolean bolUseText = false;
    @XStreamAlias(value="textAtt")
    private String strTextAtt = null;
    @XStreamAlias(value="textOriAtt")
    private String strTextOriAtt = null;
    @XStreamAlias(value="textHeightAtt")
    private String strTextHeightAtt = null;
    @XStreamAlias(value="textDXAtt")
    private String strTextDXAtt = null;
    @XStreamAlias(value="textDYAtt")
    private String strTextDYAtt = null;
    @XStreamAlias(value="textTransInOri")
    private boolean textTransInOri = false;
    private boolean allowGraphicDrafts = false;
    @XStreamAlias(value="order_att")
    private String strOrderAtt = null;
    private transient BshCalculator oriCalc = null;
    private static final FilterFactory2 ffac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private static final Lock lockFilter = new ReentrantLock();
    private transient Filter cachedOptimizedFilter = null;
    public static final ThreadLocal<Format> DF_NOWDATE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));

    public FeaturestoreMetadata() {
    }

    public FeaturestoreMetadata(String _strName) {
        this.strName = _strName;
    }

    public void setName(String _strName) {
        this.strName = _strName;
    }

    public String getName() {
        return this.strName;
    }

    public String getDatastoreName() {
        return this.strDatastoreName;
    }

    public void setDatastoreName(String _strDatastoreName) {
        this.strDatastoreName = _strDatastoreName;
    }

    public String getDatatypeName() {
        return this.strDatatypeName;
    }

    public void setDatatypeName(String _strDatatypeName) {
        this.strDatatypeName = _strDatatypeName;
    }

    public void setAttributes(String[] _arrAttributes) {
        this.arrAttributes = _arrAttributes;
        if (this.getKeyAtt() != null) {
            for (String arrAttribute : this.arrAttributes) {
                if (!arrAttribute.equals(this.getKeyAtt())) continue;
                return;
            }
            this.setKeyAtt(null);
        }
    }

    public String[] getAttributes() {
        return this.arrAttributes;
    }

    public void setEditInOtherDatatype(boolean _bolEditInOtherDatatype) {
        this.bolEditInOtherDatatype = _bolEditInOtherDatatype;
    }

    public boolean getEditInOtherDatatype() {
        return this.bolEditInOtherDatatype;
    }

    public void setKeyAtt(String _strKeyAtt) {
        this.strKeyAtt = _strKeyAtt;
    }

    public String getKeyAtt() {
        return this.strKeyAtt;
    }

    public String getKeyAttView() {
        return this.strKeyAttView;
    }

    public void setKeyAttView(String strKeyAttView) {
        this.strKeyAttView = strKeyAttView;
    }

    private String getKey4Feature(SimpleFeature f) {
        if (this.getKeyAtt() != null) {
            Object obj = f.getAttribute(this.getKeyAtt());
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
        return f.getID();
    }

    public void setKeyAttEdit(String _strKeyAttEdit) {
        this.strKeyAttEdit = _strKeyAttEdit;
    }

    public String getKeyAttEdit() {
        return this.strKeyAttEdit;
    }

    public String getDatatypeNameEdit() {
        if (!this.bolEditInOtherDatatype) {
            return this.strDatatypeName;
        }
        return this.strDatatypeNameEdit;
    }

    public void setDatatypeNameEdit(String _strDatatypeNameEdit) {
        this.strDatatypeNameEdit = _strDatatypeNameEdit;
    }

    public void setAttributesEdit(String[] _arrAttributesEdit) {
        this.arrAttributesEdit = _arrAttributesEdit;
        if (this.getKeyAttEdit() != null) {
            for (String attEdit : this.arrAttributesEdit) {
                if (!attEdit.equals(this.getKeyAttEdit())) continue;
                return;
            }
            this.setKeyAttEdit(null);
        }
    }

    public String[] getAttributesEdit() {
        if (!this.bolEditInOtherDatatype) {
            return this.arrAttributes;
        }
        return this.arrAttributesEdit;
    }

    public void setFilterText(String _strFilterText) {
        this.strFilterText = _strFilterText;
        this.cachedOptimizedFilter = null;
    }

    public String getFilterText() {
        return this.strFilterText;
    }

    public String getCRSFrom() {
        return this.strCRSFrom;
    }

    public void setCRSFrom(String strCRSFrom) {
        this.strCRSFrom = strCRSFrom;
    }

    public String getCRSTo() {
        return this.strCRSTo;
    }

    public void setCRSTo(String strCRSTo) {
        this.strCRSTo = strCRSTo;
    }

    public String getOrderAtt() {
        return this.strOrderAtt;
    }

    public void setOrderAtt(String strOrderAtt) {
        this.strOrderAtt = strOrderAtt;
    }

    public void takeProperties(FeaturestoreMetadata copyFrom) {
        this.setAttributes(copyFrom.getAttributes());
        this.setDatastoreName(copyFrom.getDatastoreName());
        this.setDatatypeName(copyFrom.getDatatypeName());
        this.setKeyAtt(copyFrom.getKeyAtt());
        this.setKeyAttView(copyFrom.getKeyAttView());
        this.setKeyAttEdit(copyFrom.getKeyAttEdit());
        this.setEditInOtherDatatype(copyFrom.getEditInOtherDatatype());
        this.setAttributesEdit(copyFrom.getAttributesEdit());
        this.setDatatypeNameEdit(copyFrom.getDatatypeNameEdit());
        this.setFilterText(copyFrom.getFilterText());
        this.setCRSFrom(copyFrom.getCRSFrom());
        this.setCRSTo(copyFrom.getCRSTo());
        this.setUseText(copyFrom.getUseText());
        this.setTextAtt(copyFrom.getTextAtt());
        this.setTextOriAtt(copyFrom.getTextOriAtt());
        this.setTextHeightAtt(copyFrom.getTextHeightAtt());
        this.setTextDXAtt(copyFrom.getTextDXAtt());
        this.setTextDYAtt(copyFrom.getTextDYAtt());
        this.setRestrictGeomType(copyFrom.getRestrictGeomType());
        this.setGeomTypes(copyFrom.getGeomTypes());
        this.setOriAtt(copyFrom.getOriAtt());
        this.setOriTrans(copyFrom.getOriTrans());
        this.setInsertAllowed(copyFrom.isInsertAllowed());
        this.setDeleteAllowed(copyFrom.isDeleteAllowed());
    }

    public FeaturestoreMetadata clone() {
        return (FeaturestoreMetadata)super.clone();
    }

    public Filter getFilter(Filter andFilter) throws Exception {
        if (andFilter == null || andFilter == Filter.INCLUDE) {
            return this.getFilter();
        }
        Filter defaultFilter = this.getFilter();
        if (defaultFilter == null || defaultFilter == Filter.INCLUDE) {
            return andFilter;
        }
        return ffac.and(this.getFilter(), andFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.strFilterText)) {
            return Filter.INCLUDE;
        }
        String strRealFilterText = this.strFilterText;
        boolean dynamicQuery = strRealFilterText.contains("%now%");
        if (this.strFilterText.trim().startsWith("<")) {
            if (dynamicQuery) {
                Date t = new Date();
                strRealFilterText = strRealFilterText.replaceAll("\\%now\\%", DF_NOWDATE.get().format(t));
            }
            lockFilter.lock();
            try {
                Filter filter;
                try (StringReader read = new StringReader(strRealFilterText);){
                    Parser parser = new Parser((Configuration)new OGCConfiguration());
                    filter = (Filter)parser.parse((Reader)read);
                }
                return filter;
            }
            finally {
                lockFilter.unlock();
            }
        }
        if (dynamicQuery) {
            Date t = new Date();
            strRealFilterText = strRealFilterText.replaceAll("\\%now\\%", DF_NOWDATE.get().format(t) + "Z");
            return ECQL.toFilter((String)strRealFilterText);
        }
        lockFilter.lock();
        try {
            if (this.cachedOptimizedFilter == null) {
                Filter rawFilter = ECQL.toFilter((String)strRealFilterText);
                this.cachedOptimizedFilter = OptimizedSimplifyingFilterVisitor.simplify((Filter)rawFilter);
            }
            Filter filter = this.cachedOptimizedFilter;
            return filter;
        }
        finally {
            lockFilter.unlock();
        }
    }

    public Query getQuery(Filter andFilter) throws Exception {
        return this.getQuery(andFilter, Integer.MAX_VALUE);
    }

    public Query getQuery(Filter andFilter, int limit) throws Exception {
        Filter filter = this.getFilter(andFilter);
        return this.getQuery(filter, this.getDatatypeName(), this.getAttributes(), limit);
    }

    public Query getQueryEdit(Filter filter) {
        return this.getQuery(filter, this.getDatatypeNameEdit(), this.getAttributesEdit(), Integer.MAX_VALUE);
    }

    private Query getQuery(Filter filter, String dataTypeName, String[] attributes, int limit) {
        Query query = new Query();
        query.setTypeName(dataTypeName);
        query.setFilter(filter);
        String[] arrAtt = attributes;
        if (arrAtt == null) {
            arrAtt = new String[]{};
        }
        if (arrAtt.length == 1 && arrAtt[0].equals("*")) {
            query.setProperties(Query.ALL_PROPERTIES);
            return query;
        }
        query.setPropertyNames(arrAtt);
        query.setMaxFeatures(limit);
        return query;
    }

    public Envelope getBounds(DMDCollection dmdCol) throws Exception {
        return this.getFeatureSource(dmdCol).getBounds(this.getQuery(null));
    }

    public int getCount(DMDCollection dmdCol) throws Exception {
        return this.getCount(dmdCol, null);
    }

    public int getCount(DMDCollection dmdCol, Filter filter) throws Exception {
        int lastCount = this.getFeatureSource(dmdCol).getCount(this.getQuery(filter));
        if (lastCount == -1) {
            lastCount = this.getFeatureSource(dmdCol).getCount(Query.ALL);
        }
        return lastCount;
    }

    public DataStore getDataStore(DMDCollection dmdCol) throws IOException {
        if (dmdCol == null) {
            throw new IOException("invalid datastore collection (null)");
        }
        DatastoreMetadata dmd = dmdCol.getByName(this.strDatastoreName);
        if (dmd == null) {
            throw new IOException(String.format(I18N.get("common.datastore-not-found"), this.strDatastoreName));
        }
        return dmd.getDataStore();
    }

    public void resetDataStore(DMDCollection dmdCol) {
        DatastoreMetadata dmd = dmdCol.getByName(this.strDatastoreName);
        if (dmd != null) {
            dmd.reset();
        }
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DMDCollection dmdCol, Filter andFilter) throws Exception {
        return this.getFeatureReader(dmdCol, andFilter, Integer.MAX_VALUE);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DMDCollection dmdCol, Filter andFilter, int limit) throws Exception {
        DataStore store = this.getDataStore(dmdCol);
        Query query = this.getQuery(andFilter, limit);
        if (this.getKeyAtt() == null) {
            return store.getFeatureReader(query, Transaction.AUTO_COMMIT);
        }
        return new FidFeatureReader(this, (FeatureReader<SimpleFeatureType, SimpleFeature>)store.getFeatureReader(query, Transaction.AUTO_COMMIT));
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DMDCollection dmdCol, Filter andFilter, String[] attributes) throws Exception {
        return this.getFeatureReader(dmdCol, andFilter, attributes, 0);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DMDCollection dmdCol, Filter andFilter, String[] attributes, int limit) throws Exception {
        DataStore store = this.getDataStore(dmdCol);
        Query query = this.getQuery(andFilter, this.getDatatypeName(), attributes, limit);
        if (this.getKeyAtt() == null) {
            return store.getFeatureReader(query, Transaction.AUTO_COMMIT);
        }
        return new FidFeatureReader(this, (FeatureReader<SimpleFeatureType, SimpleFeature>)store.getFeatureReader(query, Transaction.AUTO_COMMIT));
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReaderEdit(DMDCollection dmdCol, Filter filter) throws Exception {
        DataStore store = this.getDataStore(dmdCol);
        Query query = this.getQueryEdit(filter);
        return store.getFeatureReader(query, Transaction.AUTO_COMMIT);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(DMDCollection dmdCol) throws IOException {
        DataStore store = this.getDataStore(dmdCol);
        return store.getFeatureSource(this.getDatatypeName());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(DMDCollection dmdCol, Filter andFilter) throws Exception {
        return this.getFeatureWriter(dmdCol, andFilter, Transaction.AUTO_COMMIT);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(DMDCollection dmdCol, Filter andFilter, Transaction transaction) throws Exception {
        Filter filter;
        DataStore store = this.getDataStore(dmdCol);
        if (this.bolEditInOtherDatatype) {
            if (andFilter == null) {
                andFilter = Filter.INCLUDE;
            }
            filter = andFilter;
        } else {
            filter = this.getFilter(andFilter);
        }
        return store.getFeatureWriter(this.getDatatypeNameEdit(), filter, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(DMDCollection dmdCol) throws Exception {
        return this.getFeatureWriterAppend(dmdCol, Transaction.AUTO_COMMIT);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(DMDCollection dmdCol, Transaction transaction) throws Exception {
        DataStore store = this.getDataStore(dmdCol);
        return store.getFeatureWriterAppend(this.getDatatypeNameEdit(), transaction);
    }

    public SimpleFeatureType getSchema(DMDCollection dmdCol) throws IOException {
        DataStore store = this.getDataStore(dmdCol);
        return store.getSchema(this.strDatatypeName);
    }

    public SimpleFeatureType getSchemaEdit(DMDCollection dmdCol) throws IOException {
        DataStore store = this.getDataStore(dmdCol);
        return store.getSchema(this.getDatatypeNameEdit());
    }

    public SimpleFeatureType getQuerySchema(DMDCollection dmdCol) throws Exception {
        DataStore store = this.getDataStore(dmdCol);
        Query query = this.getQuery(null);
        DefaultView view = new DefaultView(store.getFeatureSource(query.getTypeName()), query);
        return view.getSchema();
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(DataStore store, Filter andFilter) throws Exception {
        Query query = this.getQuery(andFilter);
        if (this.getKeyAtt() == null) {
            return store.getFeatureReader(query, Transaction.AUTO_COMMIT);
        }
        return new FidFeatureReader(this, (FeatureReader<SimpleFeatureType, SimpleFeature>)store.getFeatureReader(query, Transaction.AUTO_COMMIT));
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReaderEdit(DataStore store, Filter filter) throws IOException {
        Query query = this.getQueryEdit(filter);
        return store.getFeatureReader(query, Transaction.AUTO_COMMIT);
    }

    public boolean isWriteable(DMDCollection dmdCol) throws IOException {
        DataStore store = this.getDataStore(dmdCol);
        return this.isWriteableThroughDataStoreFlag(store).orElseGet(() -> this.isWriteableThroughWriter(store));
    }

    private Boolean isWriteableThroughWriter(DataStore store) {
        try {
            store.getFeatureWriter(this.getDatatypeNameEdit(), (Filter)Filter.EXCLUDE, Transaction.AUTO_COMMIT).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private Optional<Boolean> isWriteableThroughDataStoreFlag(DataStore store) {
        if (!(store instanceof EditableStore)) {
            LOG.debug("Unable to check writability of datastore via isEditable: {}", (Object)store.getClass().getCanonicalName());
            return Optional.empty();
        }
        return Optional.of(((EditableStore)store).isEditable());
    }

    public boolean isInsertAllowed() {
        return this.insertAllowed;
    }

    public void setInsertAllowed(boolean insertAllowed) {
        this.insertAllowed = insertAllowed;
    }

    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this.deleteAllowed = deleteAllowed;
    }

    public void setRestrictGeomType(boolean _bolRestrictGeomType) {
        this.bolRestrictGeomType = _bolRestrictGeomType;
    }

    public boolean getRestrictGeomType() {
        return this.bolRestrictGeomType;
    }

    public void setGeomTypes(Class<?>[] _arrGeomTypes) {
        this.arrGeomTypes = _arrGeomTypes;
    }

    public boolean isGeometryAllowed(Class<?> clsGeom) {
        if (!this.bolRestrictGeomType) {
            return true;
        }
        for (Class<?> geomType : this.arrGeomTypes) {
            if (!geomType.equals(clsGeom)) continue;
            return true;
        }
        return false;
    }

    public Class<?>[] getGeomTypes() {
        return this.arrGeomTypes;
    }

    public void setOriAtt(String _strOriAtt) {
        this.strOriAtt = _strOriAtt;
    }

    public String getOriAtt() {
        return this.strOriAtt;
    }

    public void setOriTrans(String _strOriTrans) {
        this.strOriTrans = _strOriTrans;
        this.oriCalc = null;
    }

    public String getOriTrans() {
        return this.strOriTrans;
    }

    public BshCalculator getOriTransCalc() throws Exception {
        try {
            if (this.oriCalc == null) {
                this.oriCalc = BshCalculator.getInstance((String)this.strOriTrans);
            }
            return this.oriCalc;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public void setUseText(boolean _bolUseText) {
        this.bolUseText = _bolUseText;
    }

    public boolean getUseText() {
        return this.bolUseText;
    }

    public void setTextAtt(String _strTextAtt) {
        this.strTextAtt = _strTextAtt;
    }

    public String getTextAtt() {
        return this.strTextAtt;
    }

    public void setTextOriAtt(String _strTextOriAtt) {
        this.strTextOriAtt = _strTextOriAtt;
    }

    public String getTextOriAtt() {
        return this.strTextOriAtt;
    }

    public void setTextHeightAtt(String _strTextHeightAtt) {
        this.strTextHeightAtt = _strTextHeightAtt;
    }

    public String getTextHeightAtt() {
        return this.strTextHeightAtt;
    }

    public void setTextDXAtt(String _strTextDXAtt) {
        this.strTextDXAtt = _strTextDXAtt;
    }

    public String getTextDXAtt() {
        return this.strTextDXAtt;
    }

    public void setTextDYAtt(String _strTextDYAtt) {
        this.strTextDYAtt = _strTextDYAtt;
    }

    public String getTextDYAtt() {
        return this.strTextDYAtt;
    }

    public boolean isTextTransInOri() {
        return this.textTransInOri;
    }

    public void setTextTransInOri(boolean textTransInOri) {
        this.textTransInOri = textTransInOri;
    }

    public String testConnection(DMDCollection dmdCol) {
        try {
            if (dmdCol == null) {
                throw new Exception("invalid datastore collection (null)");
            }
            DatastoreMetadata dmd = dmdCol.getByName(this.strDatastoreName);
            if (dmd == null) {
                throw new Exception("invalid datastore name");
            }
            Query query = this.getQuery((Filter)Filter.EXCLUDE);
            if (this.strFilterText != null && this.strFilterText.length() != 0) {
                query.setFilter((Filter)Filter.EXCLUDE);
            }
            DataStore store = dmd.getDataStore();
            FeatureReader fread = store.getFeatureReader(query, Transaction.AUTO_COMMIT);
            Set freadNames = ((SimpleFeatureType)fread.getFeatureType()).getAttributeDescriptors().stream().map(AttributeDescriptor::getLocalName).collect(Collectors.toSet());
            Optional<String> attNotFound = Arrays.stream(this.getAttributes()).filter(att -> !freadNames.contains(att)).findAny();
            if (attNotFound.isPresent()) {
                return I18N.getMessage("data.model.FeaturestoreMetadata.attribute-not-found", attNotFound.get());
            }
            fread.close();
            if (store.getSchema(this.strDatatypeName) == null) {
                throw new Exception("FeatureType is null");
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static FeaturestoreMetadata createFromType(DatastoreMetadata dataStoreMD, String dataTypeName) throws IOException {
        FeaturestoreMetadata fmd = new FeaturestoreMetadata();
        fmd.setDatastoreName(dataStoreMD.getName());
        fmd.setDatatypeName(dataTypeName);
        SimpleFeatureType schema = dataStoreMD.getDataStore().getSchema(dataTypeName);
        String[] arrAtts = new String[schema.getAttributeCount()];
        for (int j = 0; j < arrAtts.length; ++j) {
            arrAtts[j] = schema.getDescriptor(j).getLocalName();
        }
        fmd.setAttributes(arrAtts);
        return fmd;
    }

    public boolean isAllowGraphicDrafts() {
        return this.allowGraphicDrafts;
    }

    public void setAllowGraphicDrafts(boolean allowGraphicDrafts) {
        this.allowGraphicDrafts = allowGraphicDrafts;
    }

    public String getWriteableType() {
        if (this.getEditInOtherDatatype()) {
            return this.getDatatypeNameEdit();
        }
        return this.getDatatypeName();
    }

    public SimpleFeatureType getWriteableSchema(DMDCollection dmdCol) throws IOException {
        if (this.getEditInOtherDatatype()) {
            return this.getSchemaEdit(dmdCol);
        }
        return this.getSchema(dmdCol);
    }

    private static class FidFeatureReader
    implements FeatureReader<SimpleFeatureType, SimpleFeature> {
        private final FeaturestoreMetadata fmd;
        private final FeatureReader<SimpleFeatureType, SimpleFeature> fread;

        FidFeatureReader(FeaturestoreMetadata _fmd, FeatureReader<SimpleFeatureType, SimpleFeature> _fread) {
            this.fmd = _fmd;
            this.fread = _fread;
        }

        public SimpleFeatureType getFeatureType() {
            return (SimpleFeatureType)this.fread.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            return this.fread.hasNext();
        }

        public SimpleFeature next() throws IOException {
            SimpleFeature f = (SimpleFeature)this.fread.next();
            return new FidFeature(f, this.fmd.getKey4Feature(f));
        }

        public void close() throws IOException {
            this.fread.close();
        }
    }
}

