/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreMetadataIO {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreMetadataIO.class);
    private static final XStream xstream = DatastoreMetadataIO.createSecuredXStream();

    private DatastoreMetadataIO() {
    }

    public static String toXML(DatastoreMetadata mData) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            xstream.marshal((Object)mData, (HierarchicalStreamWriter)new CompactWriter((Writer)stringWriter));
            String string = stringWriter.toString();
            return string;
        }
    }

    public static DatastoreMetadata fromXML(String strXML) {
        return (DatastoreMetadata)xstream.fromXML(strXML);
    }

    public static void toFile(DatastoreMetadata mData, String strFileName) throws IOException {
        File file = new File(strFileName);
        File dmdFile = file.isDirectory() ? new File(file, mData.getName() + ".dmd") : file;
        try (PrintWriter out = new PrintWriter(dmdFile);){
            xstream.marshal((Object)mData, (HierarchicalStreamWriter)new CompactWriter((Writer)out));
        }
    }

    public static void toDir(DMDCollection dmdCol, String strDirName, boolean removeExisting) throws IOException {
        File file = new File(strDirName);
        if (!file.isDirectory()) {
            file = new File(file.getPath());
        }
        if (removeExisting) {
            String[] arrFilenames;
            for (String arrFilename : arrFilenames = file.list()) {
                File dmdFile;
                boolean success;
                if (!arrFilename.toLowerCase().endsWith(".dmd") || (success = (dmdFile = new File(file.getAbsoluteFile(), arrFilename)).delete())) continue;
                LOG.warn(String.format("Unable to delete '%s'", dmdFile));
            }
        }
        Iterator<DatastoreMetadata> i = dmdCol.iterator();
        while (i.hasNext()) {
            DatastoreMetadataIO.toFile(i.next(), file.getAbsolutePath());
        }
    }

    public static DatastoreMetadata fromFile(File strFileName) throws IOException {
        try (FileReader in = new FileReader(strFileName);){
            DatastoreMetadata datastoreMetadata = (DatastoreMetadata)xstream.fromXML((Reader)in);
            return datastoreMetadata;
        }
    }

    public static DMDCollection fromDir(String strDir) {
        File file = new File(strDir);
        if (!file.exists()) {
            return new DMDCollection();
        }
        if (!file.isDirectory()) {
            file = new File(file.getPath());
        }
        String[] arrFilenames = file.list();
        ArrayList<DatastoreMetadata> lstMData = new ArrayList<DatastoreMetadata>();
        for (String arrFilename : arrFilenames) {
            if (!arrFilename.toLowerCase().endsWith(".dmd")) continue;
            File dmdFile = new File(file.getAbsoluteFile(), arrFilename);
            try {
                lstMData.add(DatastoreMetadataIO.fromFile(dmdFile));
            }
            catch (Exception e) {
                LOG.error(String.format("Error loading DMDCollection-entry '%s': %s", dmdFile, e.getMessage()));
            }
        }
        return new DMDCollection(null, lstMData);
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypes(new Class[]{String.class, DatastoreMetadata.class});
        xstream.processAnnotations(DatastoreMetadata.class);
        return xstream;
    }
}

