/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.io.SessionCacheDirectory;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStore;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStoreFactory;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.RelativePaths;
import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStoreFactory;
import de.riwagis.riwajump.data.model.DSCreationExceptionTimestamp;
import de.riwagis.util.data.RiwaDataStoreFinder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FeatureListener;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="dmd")
public class DatastoreMetadata
implements Cloneable,
Comparable<DatastoreMetadata>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreMetadata.class);
    @XStreamAlias(value="name")
    private String strName = null;
    @XStreamAlias(value="datname")
    private String strDataName = null;
    private Map<String, Object> params = null;
    private transient DataStoreFactorySpi factory = null;
    private transient DataStore dataStore = null;
    private transient DSCreationExceptionTimestamp dsCreationEx = null;
    private transient Lock dsLock = new ReentrantLock();
    private transient boolean bolKeepDataStore = false;
    private transient Task task = null;
    public static final Comparator<DatastoreMetadata> COMPARE_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private transient Map<String, Collection<FeatureListener>> featureListenerMap;
    private static final transient Map<String, DataStoreFactorySpi> mapFactories = new LinkedHashMap<String, DataStoreFactorySpi>();

    public static List<DataStoreFactorySpi> getFactories() {
        return new ArrayList<DataStoreFactorySpi>(mapFactories.values());
    }

    public static DataStoreFactorySpi getFactoryByName(String strDisplayName) {
        return mapFactories.get(strDisplayName);
    }

    public DatastoreMetadata(String _strName, DataStore _dataStore) {
        this.setName(_strName);
        this.strDataName = _dataStore instanceof RedlineDataStore ? "redline" : "by software";
        this.dsLock.lock();
        this.params = new HashMap<String, Object>();
        try {
            this.dataStore = _dataStore;
        }
        finally {
            this.dsLock.unlock();
        }
        this.bolKeepDataStore = true;
    }

    public DatastoreMetadata(String _strName) {
        this.setName(_strName);
        this.setDataName("RiwaDataTable");
    }

    public DatastoreMetadata(String _strName, String _strDataName) {
        this.setName(_strName);
        this.setDataName(_strDataName);
    }

    public DatastoreMetadata(String _strName, String _strDataName, Map<String, Object> _params) {
        this.setName(_strName);
        this.reset(_strDataName, _params);
    }

    private Object readResolve() {
        this.dsLock = new ReentrantLock();
        return this;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public String getName() {
        return this.strName;
    }

    public String toString() {
        return this.strName + " (" + this.strDataName + ")";
    }

    public final void setName(String _strName) {
        this.strName = _strName;
    }

    public String getDataName() {
        return this.strDataName;
    }

    public final void setDataName(String _strDataName) {
        if (this.bolKeepDataStore) {
            return;
        }
        this.strDataName = _strDataName;
        this.factory = mapFactories.get(this.strDataName);
        this.recreateParameters();
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public Map<String, Object> getClonedParameters() {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        for (String key : this.params.keySet()) {
            newParams.put(key, this.params.get(key));
        }
        return newParams;
    }

    public void setParameters(Map<String, Object> _params) {
        if (this.bolKeepDataStore) {
            return;
        }
        this.params = _params;
        this.resetDatastore();
    }

    public boolean isKeepDataStore() {
        return this.bolKeepDataStore;
    }

    public void setKeepDataStore(boolean bolKeepDataStore) {
        this.bolKeepDataStore = bolKeepDataStore;
    }

    public void reset() {
        this.resetDsCreationException();
        if (!this.bolKeepDataStore) {
            this.resetDatastore();
        }
    }

    public final void reset(String _strDataName, Map<String, Object> _params) {
        this.resetDsCreationException();
        this.strDataName = _strDataName;
        this.factory = mapFactories.get(this.strDataName);
        this.params = _params;
        if (!this.bolKeepDataStore) {
            this.resetDatastore();
        }
    }

    private void resetDatastore() {
        this.dsLock.lock();
        try {
            if (this.dataStore != null) {
                this.dataStore.dispose();
            }
        }
        finally {
            this.dataStore = null;
            this.dsLock.unlock();
        }
        this.factory = null;
        this.resetDsCreationException();
        LOG.info(String.format("datastore '%s' reset", this.strName));
    }

    private void resetDsCreationException() {
        this.dsCreationEx = null;
    }

    public DataStoreFactorySpi getFactory() {
        if (this.strDataName.equals("redline")) {
            return new RedlineDataStoreFactory();
        }
        if (this.bolKeepDataStore) {
            return null;
        }
        if (this.factory == null) {
            this.factory = mapFactories.get(this.strDataName);
        }
        if (this.factory == null) {
            LOG.error(String.format("DatastoreFactory not found for: %s", this.strDataName));
            this.strDataName = mapFactories.keySet().iterator().next();
            this.factory = mapFactories.get(this.strDataName);
        }
        return this.factory;
    }

    public void recreateParameters() {
        if (this.bolKeepDataStore) {
            return;
        }
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        } else {
            this.params.clear();
        }
        for (DataAccessFactory.Param arrParam1 : this.getFactory().getParametersInfo()) {
            this.params.put(arrParam1.key, arrParam1.sample);
        }
        this.resetDatastore();
    }

    public DatastoreMetadata cloneDMD() {
        try {
            return (DatastoreMetadata)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never reach here", e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DatastoreMetadata mData = (DatastoreMetadata)super.clone();
        mData.dataStore = null;
        mData.dsCreationEx = null;
        mData.reset(mData.getDataName(), this.getClonedParameters());
        if (this.bolKeepDataStore) {
            LOG.warn("Deep clone is not suppored when keep datastore is true. Datastore object has not been cloned.");
        }
        return mData;
    }

    @Override
    public final int compareTo(DatastoreMetadata obj) {
        return COMPARE_BY_NAME.compare(this, obj);
    }

    public void takeProperties(DatastoreMetadata copyFrom) {
        this.setName(copyFrom.getName());
        this.reset(copyFrom.getDataName(), copyFrom.getClonedParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testConnection() {
        try {
            DataStore store = this.getDataStore();
            Object[] arrTypes = store.getTypeNames();
            LOG.trace(String.format("types: %s", StringUtils.join((Object[])arrTypes, (String)"; ")));
            String string = null;
            return string;
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
    }

    public void adjustDataStoreParams() {
        this.updateAbsolutePath();
        if (this.getParameters().containsKey(RiwaSrvDataStoreFactory.TILED.key)) {
            try {
                if (Boolean.TRUE.equals(RiwaSrvDataStoreFactory.TILED.lookUp(this.params))) {
                    String cacheDirectoryPath = SessionCacheDirectory.get();
                    this.getParameters().put(RiwaSrvDataStoreFactory.TILE_CACHE_DIRECTORY_PATH.key, cacheDirectoryPath);
                }
            }
            catch (IOException ex) {
                LOG.error("error adjusting datastore params", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore getDataStore() throws IOException {
        this.dsLock.lock();
        try {
            if (this.dataStore == null && !this.bolKeepDataStore) {
                if (this.dsCreationEx != null) {
                    long remainingWaitTime = DSCreationExceptionTimestamp.calcRemainingWaitTime(this.dsCreationEx);
                    if (remainingWaitTime > 0L) {
                        throw new IOException(String.format("not yet allowed to recreate DataStore '%s', because of previous exception '%s'. Remaining wait time: %.1f s", this.strName, this.dsCreationEx.getExceptionMessage(), (double)remainingWaitTime / 1000.0));
                    }
                    this.dsCreationEx = null;
                }
                try {
                    this.adjustDataStoreParams();
                    DataStoreFactorySpi fact = this.getFactory();
                    if (fact == null) {
                        throw new IOException(String.format("DatastoreFactory for '%s' not found", this.strName));
                    }
                    DataStore tmpDataStore = fact.createDataStore(this.params);
                    if (this.featureListenerMap != null && !this.featureListenerMap.isEmpty()) {
                        for (Map.Entry<String, Collection<FeatureListener>> entrySet : this.featureListenerMap.entrySet()) {
                            String typeName = entrySet.getKey();
                            Collection<FeatureListener> listeners = entrySet.getValue();
                            SimpleFeatureSource featureSource = tmpDataStore.getFeatureSource(typeName);
                            for (FeatureListener listener : listeners) {
                                featureSource.addFeatureListener(listener);
                            }
                        }
                    }
                    this.dataStore = tmpDataStore;
                }
                catch (Throwable e) {
                    this.dsCreationEx = new DSCreationExceptionTimestamp(e);
                    throw new IOException(String.format("unable to create DataStore '%s': %s", this.strName, e.getMessage()), e);
                }
                LOG.debug(String.format("datastore '%s' created", this.strName));
            }
            DataStore dataStore = this.dataStore;
            return dataStore;
        }
        finally {
            this.dsLock.unlock();
        }
    }

    public void dispose() {
        this.resetDatastore();
    }

    protected void finalize() throws Throwable {
        this.resetDatastore();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureListener(String typeName, FeatureListener listener) {
        this.dsLock.lock();
        try {
            Collection<Object> listners4TypeName;
            if (this.featureListenerMap == null) {
                this.featureListenerMap = new HashMap<String, Collection<FeatureListener>>();
                listners4TypeName = new ArrayList();
                this.featureListenerMap.put(typeName, listners4TypeName);
            } else if (this.featureListenerMap.containsKey(typeName)) {
                listners4TypeName = this.featureListenerMap.get(typeName);
            } else {
                listners4TypeName = new ArrayList();
                this.featureListenerMap.put(typeName, listners4TypeName);
            }
            if (listners4TypeName.contains(listener)) {
                return;
            }
            try {
                SimpleFeatureSource featureSource = this.getDataStore().getFeatureSource(typeName);
                featureSource.addFeatureListener(listener);
                listners4TypeName.add(listener);
            }
            catch (IOException ex) {
                LOG.error(String.format("could not register feature listener in datastore '%s' for schema '%s'", this.strName, typeName), (Throwable)ex);
            }
        }
        finally {
            this.dsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatureListener(String typeName, FeatureListener listener) {
        this.dsLock.lock();
        try {
            Collection<FeatureListener> listners4TypeName;
            if (this.featureListenerMap != null && this.featureListenerMap.containsKey(typeName) && (listners4TypeName = this.featureListenerMap.get(typeName)).contains(listener)) {
                try {
                    SimpleFeatureSource featureSource = this.getDataStore().getFeatureSource(typeName);
                    featureSource.removeFeatureListener(listener);
                    listners4TypeName.remove(listener);
                }
                catch (IOException ex) {
                    LOG.error(String.format("could not register feature listener in datastore '%s' for schema '%s'", this.strName, typeName), (Throwable)ex);
                }
            }
        }
        finally {
            this.dsLock.unlock();
        }
    }

    public void updateAbsolutePath() {
        DataAccessFactory.Param extractFileParam = this.extractFileParam(this.getFactory());
        if (extractFileParam != null) {
            RelativePaths.constructAbsolutePath(this.getTask(), this.params, this.params.get(extractFileParam.key)).ifPresent(obj -> {
                this.params.put(extractFileParam.key, obj);
                this.reset();
            });
        }
    }

    private DataAccessFactory.Param extractFileParam(DataStoreFactorySpi fac) {
        return RiwaDataStoreFinder.getLocalURIParameterForStore(fac.getClass());
    }

    static {
        RiwaDataStoreFinder.getAvailableDataStores().forEach(fac -> {
            DataStoreFactorySpi oldValue = mapFactories.put(fac.getDisplayName(), (DataStoreFactorySpi)fac);
            Assert.isTrue((oldValue == null ? 1 : 0) != 0, (String)("There is already a DataStoreFactory with the name " + fac.getDescription()));
        });
    }
}

