/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

public class DMDCollectionIO {
    private static final XStream xstream = DMDCollectionIO.createSecuredXStream();

    private DMDCollectionIO() {
    }

    public static String toXML(DMDCollection dmdCol) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            xstream.marshal((Object)dmdCol, (HierarchicalStreamWriter)new CompactWriter((Writer)stringWriter));
            String string = stringWriter.toString();
            return string;
        }
    }

    public static DMDCollection fromXML(String strXML) {
        return (DMDCollection)xstream.fromXML(strXML);
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypes(new Class[]{String.class, DMDCollection.class, DatastoreMetadata.class});
        xstream.processAnnotations(DMDCollection.class);
        return xstream;
    }
}

