/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@XStreamAlias(value="dmdcol")
public class DMDCollection
implements Serializable,
Iterable<DatastoreMetadata> {
    @XStreamAlias(value="dmdlist")
    private List<DatastoreMetadata> storeLst;
    private transient Task task = null;

    public DMDCollection(Task task, List<DatastoreMetadata> _lstDatastoreMD) {
        this.storeLst = _lstDatastoreMD;
        this.sortList();
        this.setTask(task);
    }

    public DMDCollection() {
        this(null);
    }

    public DMDCollection(Task task) {
        this(task, new ArrayList<DatastoreMetadata>());
    }

    public Task getTask() {
        return this.task;
    }

    public final void setTask(Task task) {
        this.task = task;
        for (DatastoreMetadata dmd : this.storeLst) {
            dmd.setTask(task);
        }
    }

    public List<DatastoreMetadata> getInternalList() {
        return this.storeLst;
    }

    @Override
    public Iterator<DatastoreMetadata> iterator() {
        return this.storeLst.iterator();
    }

    public List<DatastoreMetadata> getCloneList() {
        ArrayList<DatastoreMetadata> lstClone = new ArrayList<DatastoreMetadata>();
        for (DatastoreMetadata currEntry : this.storeLst) {
            lstClone.add(currEntry.cloneDMD());
        }
        return lstClone;
    }

    public DatastoreMetadata getByName(String strName) {
        for (DatastoreMetadata currEntry : this.storeLst) {
            if (!currEntry.getName().equals(strName)) continue;
            return currEntry;
        }
        return null;
    }

    private final void sortList() {
        Object[] arrDM = this.storeLst.toArray(new DatastoreMetadata[this.storeLst.size()]);
        Arrays.sort(arrDM);
        this.storeLst.clear();
        this.storeLst.addAll(Arrays.asList(arrDM));
    }

    public int addDatastore(DatastoreMetadata dataMeta) {
        dataMeta.setTask(this.task);
        int counter = 0;
        for (DatastoreMetadata currEntry : this.storeLst) {
            if (currEntry.compareTo(dataMeta) > 0) {
                this.storeLst.add(counter, dataMeta);
                return counter;
            }
            ++counter;
        }
        this.storeLst.add(dataMeta);
        return counter;
    }

    public void replaceDatastore(DatastoreMetadata oldMeta, DatastoreMetadata newMeta) {
        if (this.storeLst.contains(oldMeta)) {
            this.removeDatastore(oldMeta);
            this.addDatastore(newMeta);
            if (!oldMeta.getName().equals(newMeta.getName())) {
                for (Layerable layerable : WorkbenchContext.getTask().getLayerManager().getRootCatLocal().getAllLayerables()) {
                    if (!(layerable instanceof Layer)) continue;
                    Layer layer = (Layer)layerable;
                    if (!oldMeta.getName().equals(layer.getFMD().getDatastoreName())) continue;
                    layer.getFMD().setDatastoreName(newMeta.getName());
                }
            }
        }
    }

    public int removeDatastore(DatastoreMetadata dataMeta) {
        int index = -1;
        if (this.storeLst.contains(dataMeta)) {
            index = this.storeLst.indexOf(dataMeta);
            this.storeLst.remove(dataMeta);
        }
        return index;
    }

    public void disposeDatastores() {
        for (DatastoreMetadata lstMData : this.storeLst) {
            lstMData.dispose();
        }
    }

    public String findUniqueStoreName(String name) {
        for (DatastoreMetadata dmd : this) {
            if (!dmd.getName().equals(name)) continue;
            String[] arrName = ((String)name).split("\\_");
            if (arrName.length == 1) {
                name = (String)name + "_1";
            } else {
                try {
                    int num = Integer.parseInt(arrName[arrName.length - 1]);
                    name = ((String)name).substring(0, ((String)name).length() - arrName[arrName.length - 1].length()) + ++num;
                }
                catch (Exception e) {
                    name = (String)name + "_1";
                }
            }
            return this.findUniqueStoreName((String)name);
        }
        return name;
    }
}

