/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui.datalocation;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import javax.swing.table.AbstractTableModel;

public class DataLocationTableModel
extends AbstractTableModel {
    private DataLocation mData = null;
    private static final String[] arrColnames = new String[2];

    public DataLocationTableModel(DataLocation _mData) {
        this.mData = _mData;
    }

    public void setDataLocation(DataLocation _mData) {
        this.mData = _mData;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.mData.getParameterDescription().length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.mData.getParameterDescription()[row].getName();
        }
        ParameterDescriptor param = this.mData.getParameterDescription()[row];
        String obj = this.mData.getParameterValue(param.getParameterName());
        if (obj == null) {
            return "";
        }
        return obj;
    }

    @Override
    public String getColumnName(int column) {
        return arrColnames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column != 1) {
            return;
        }
        ParameterDescriptor pd = this.mData.getParameterDescription()[row];
        String strValue = pd.formatParameterObject(value);
        this.mData.setParameter(pd.getParameterName(), strValue);
        this.fireTableDataChanged();
    }

    public boolean isRequired(int row) {
        return this.mData.getParameterDescription()[row].required();
    }

    public String getDescription(int row) {
        return this.mData.getParameterDescription()[row].getDescription();
    }

    static {
        DataLocationTableModel.arrColnames[0] = I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.property-name");
        DataLocationTableModel.arrColnames[1] = I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.property-value");
    }
}

