/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui.datalocation;

import de.riwagis.riwajump.data.gui.datalocation.CellEditorFinder;
import de.riwagis.riwajump.data.gui.datalocation.DataLocationTableModel;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class DataLocationTable
extends JTable {
    private DataLocation mData = null;
    DefaultTableCellRenderer colRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected || hasFocus) {
                return comp;
            }
            if (((DataLocationTableModel)table.getModel()).isRequired(row)) {
                comp.setBackground(Color.YELLOW);
            } else {
                comp.setBackground(Color.WHITE);
            }
            return comp;
        }
    };

    public DataLocationTable(DataLocation _mData) {
        this.mData = _mData;
        this.setModel(new DataLocationTableModel(this.mData));
        TableColumn col1 = this.getColumn(this.getColumnName(0));
        col1.setCellRenderer(this.colRenderer);
        TableColumn col2 = this.getColumn(this.getColumnName(1));
        col2.setCellRenderer(this.colRenderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int intRow = DataLocationTable.this.getSelectedRow();
                DataLocationTable.this.setRowSelectionInterval(intRow, intRow);
                DataLocationTable.this.setColumnSelectionInterval(1, 1);
                if (e.getClickCount() > 1) {
                    DataLocationTable.this.editCellAt(intRow, 1);
                }
            }
        });
    }

    public void setDataLocation(DataLocation _mData) {
        this.mData = _mData;
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        ((DataLocationTableModel)this.getModel()).setDataLocation(this.mData);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return super.getCellEditor(row, column);
        }
        ParameterDescriptor pd = this.mData.getParameterDescription()[row];
        return CellEditorFinder.findEditor(pd);
    }
}

