/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui.datalocation;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.gui.datalocation.DataLocationTable;
import de.riwagis.riwajump.data.gui.datalocation.DataLocationTableModel;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.DataLocationType;
import de.riwagis.util.gui.ExceptionDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLocationPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(DataLocationPanel.class);
    private boolean blockEvents = false;
    private DataLocation mData;
    private final DataLocation.DataType dataType;
    private JButton butTestConn;
    private JComboBox<DataLocationType> cboType;
    private JLabel lblDesc;
    private JLabel lblDescText;
    private JLabel lblName;
    private JLabel lblProperties;
    private JLabel lblType;
    private JScrollPane scrPaneProperties;
    private JTable tblProperties;
    private JTextField txtName;

    public DataLocationPanel(DataLocation _mData, DataLocation.DataType dataType) {
        this.mData = _mData;
        this.dataType = dataType;
        this.initComponents();
        this.i18n();
        this.init();
    }

    public void showPanelWithName(boolean bolShowWithName) {
        this.lblName.setVisible(bolShowWithName);
        this.txtName.setVisible(bolShowWithName);
    }

    private void i18n() {
        this.lblName.setText(I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.name"));
        this.lblProperties.setText(I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.properties"));
        this.lblType.setText(I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.data-type"));
        this.lblDesc.setText(I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.description"));
        this.lblDescText.setText("  ");
        this.butTestConn.setText(I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.test-connection"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.blockEvents = true;
        try {
            this.cboType.removeAllItems();
            for (DataLocationType dlt : DataLocationType.values()) {
                if (!dlt.getDataType().equals((Object)this.dataType)) continue;
                this.cboType.addItem(dlt);
            }
        }
        finally {
            this.blockEvents = false;
        }
        this.setDataLocation(this.mData);
    }

    public void setDataLocation(DataLocation _mData) {
        this.mData = _mData;
        this.blockEvents = true;
        try {
            this.stopEditing();
            this.txtName.setText(this.mData.getName());
            this.cboType.setSelectedItem((Object)this.mData.getDataLocationType());
            ((DataLocationTable)this.tblProperties).setDataLocation(this.mData);
            this.updateDescription();
        }
        finally {
            this.blockEvents = false;
        }
    }

    public DataLocation getDataLocation() {
        return this.mData;
    }

    public void stopEditing() {
        if (this.tblProperties.getCellEditor() != null) {
            this.tblProperties.getCellEditor().stopCellEditing();
        }
    }

    private void updateDescription() {
        int row = this.tblProperties.getSelectedRow();
        if (row > -1) {
            this.lblDescText.setText("<html>" + ((DataLocationTableModel)this.tblProperties.getModel()).getDescription(row) + "</html>");
        } else {
            this.lblDescText.setText("  ");
        }
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.cboType = new JComboBox();
        this.lblProperties = new JLabel();
        this.scrPaneProperties = new JScrollPane();
        this.tblProperties = new DataLocationTable(this.mData);
        this.lblDesc = new JLabel();
        this.lblDescText = new JLabel();
        this.butTestConn = new JButton();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblType.setText("Datentyp:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.lblType, gridBagConstraints);
        this.cboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataLocationPanel.this.cboType_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add(this.cboType, gridBagConstraints);
        this.lblProperties.setText("Eigenschaften:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.lblProperties, gridBagConstraints);
        this.tblProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataLocationPanel.this.tblProperties_onMouseClicked(evt);
            }
        });
        this.tblProperties.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DataLocationPanel.this.tblProperties_onKeyReleased(evt);
            }
        });
        this.scrPaneProperties.setViewportView(this.tblProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.scrPaneProperties, gridBagConstraints);
        this.lblDesc.setText("Parameterbeschreibung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 9, 6, 9);
        this.add((Component)this.lblDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.add((Component)this.lblDescText, gridBagConstraints);
        this.butTestConn.setText("Verbindung testen");
        this.butTestConn.setMinimumSize(new Dimension(140, 23));
        this.butTestConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataLocationPanel.this.butTestConn_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butTestConn, gridBagConstraints);
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.lblName, gridBagConstraints);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DataLocationPanel.this.txtName_onKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                DataLocationPanel.this.txtName_onKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.txtName, gridBagConstraints);
    }

    private void butTestConn_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.stopEditing();
        String strError = this.mData.testConnection();
        if (strError == null) {
            JOptionPane.showMessageDialog(this, I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.test-succeeded"));
        } else {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
        }
    }

    private void tblProperties_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateDescription();
    }

    private void tblProperties_onMouseClicked(MouseEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateDescription();
    }

    private void txtName_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.mData.setName(this.txtName.getText());
    }

    private void cboType_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.stopEditing();
        if (this.cboType.getSelectedItem().equals((Object)this.mData.getDataLocationType())) {
            return;
        }
        try {
            int option = JOptionPane.showConfirmDialog(this, I18N.get("de.riwagis.riwajump.datalocation.gui.DataLocationPanel.change-datatype"), I18N.get("common.message"), 0);
            if (option == 0) {
                String strOldName = this.mData.getName();
                File oldRootDir = this.mData.getRootDir();
                DataLocationType dt = (DataLocationType)((Object)this.cboType.getSelectedItem());
                this.mData = dt.newInstance();
                this.mData.setName(strOldName);
                this.mData.setRootDir(oldRootDir);
                this.setDataLocation(this.mData);
            } else {
                this.cboType.setSelectedItem((Object)this.mData.getDataLocationType());
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)null);
            LOG.error("Error creating instance of DataLocation object.", (Throwable)e);
        }
    }

    private void txtName_onKeyTyped(KeyEvent evt) {
    }
}

