/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui.datalocation;

import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.riwajump.data.model.datalocation.FileParameterDescriptor;
import de.riwagis.riwajump.data.model.datalocation.ParameterDescriptor;
import de.riwagis.util.gui.components.TextFieldFileChooser;
import java.awt.Component;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class CellEditorFinder {
    private static final CRSDefinition[] arrCrsDef = CRSDefFactory.getCRSDefinitionList().toArray(new CRSDefinition[0]);

    public static TableCellEditor findEditor(ParameterDescriptor pd) {
        switch (pd.getType()) {
            case FILE: {
                return new FileTableCellEditor(pd);
            }
            case CRS: {
                return new CrsTableCellEditor(pd);
            }
            case NUMBER: {
                return new NumberTableCellEditor(pd);
            }
            case CHARSET: {
                return new DefaultCellEditor(new JTextField());
            }
        }
        return new DefaultCellEditor(new JTextField());
    }

    private CellEditorFinder() {
    }

    static {
        Arrays.sort(arrCrsDef);
    }

    private static class FileTableCellEditor
    extends DefaultCellEditor {
        private final TextFieldFileChooser tfChooser = new TextFieldFileChooser();

        private FileTableCellEditor(ParameterDescriptor pd) {
            super(new JTextField());
            FileParameterDescriptor fpd;
            this.tfChooser.onlyDirectories(false);
            if (pd instanceof FileParameterDescriptor && (fpd = (FileParameterDescriptor)pd).getFileTypes() != null) {
                this.tfChooser.setFileTypes(fpd.getFileTypes());
            }
            this.tfChooser.setMode(0);
            this.tfChooser.displayChoose(false);
            this.setClickCountToStart(1);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.tfChooser.getAbsolutePath() == null) {
                return null;
            }
            return new File(this.tfChooser.getAbsolutePath());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tfChooser.setAbsolutePath(value.toString());
            return this.tfChooser;
        }
    }

    private static class CrsTableCellEditor
    extends DefaultCellEditor {
        private final JComboBox<Object> cmbCrsDef = new JComboBox();
        private ParameterDescriptor pd = null;

        private CrsTableCellEditor(ParameterDescriptor pd) {
            super(new JTextField());
            this.pd = pd;
            this.cmbCrsDef.addItem("");
            for (CRSDefinition crsDef : arrCrsDef) {
                this.cmbCrsDef.addItem(crsDef);
            }
            this.setClickCountToStart(1);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.cmbCrsDef.getSelectedIndex() == 0) {
                return null;
            }
            return this.cmbCrsDef.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof String) {
                value = this.pd.parseParameterString((String)value);
            }
            if (value == null) {
                this.cmbCrsDef.setSelectedIndex(0);
            } else {
                this.cmbCrsDef.setSelectedItem(value);
            }
            return this.cmbCrsDef;
        }
    }

    private static class NumberTableCellEditor
    extends DefaultCellEditor {
        private NumberTableCellEditor(ParameterDescriptor pd) {
            super(new JFormattedTextField(NumberFormat.getIntegerInstance()));
            this.setClickCountToStart(1);
        }

        @Override
        public Object getCellEditorValue() {
            Object objValue = super.getCellEditorValue();
            if (objValue == null) {
                return 0;
            }
            if (objValue instanceof Number) {
                return ((Number)objValue).intValue();
            }
            try {
                return NumberFormat.getIntegerInstance().parse(objValue.toString()).intValue();
            }
            catch (ParseException ex) {
                return 0;
            }
        }
    }
}

