/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.GraphicDrafts;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.label.LabelFeatureAtts;
import de.riwagis.riwajump.data.gui.AttributeListDialog;
import de.riwagis.riwajump.data.gui.DatatypeListDialog;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.data.model.TransformationService;
import de.riwagis.util.ThrowingRunnable;
import de.riwagis.util.bsh.BshValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.view.DefaultView;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturestorePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(FeaturestorePanel.class);
    public static final String PRIMARY_KEY = "_PrimaryKey";
    private boolean blockEvents = false;
    private FeaturestoreMetadata fmd = null;
    private DMDCollection dmdCol = null;
    private DatatypeListDialog dlgDatatype = null;
    private AttributeListDialog dlgAttribute = null;
    private final List<ActionListener> lstActionListeners = new ArrayList<ActionListener>();
    private final List<JComboBox<String>> lstCmbAttEdit = new ArrayList<JComboBox<String>>();
    private final List<JComboBox<String>> lstCmbAtt = new ArrayList<JComboBox<String>>();
    private int layerType = 0;
    private final TransformationService transformer = new TransformationService();
    private JButton butAttributes;
    private JButton butAttributesEdit;
    private JButton butDatatype;
    private JButton butDatatypeEdit;
    private JCheckBox cboDeleteAllowed;
    private JCheckBox cboEditInOtherTable;
    private JCheckBox cboGeomType;
    private JCheckBox cboGraphicDrafts;
    private JCheckBox cboInsertAllowed;
    private JCheckBox cboManualTransformation;
    private JCheckBox cboTransInOri;
    private JCheckBox cboUseText;
    private JComboBox<CRSDefinition> cmbCRSFrom;
    private JComboBox<CRSDefinition> cmbCRSTo;
    private JComboBox<DatastoreMetadata> cmbDatastore;
    private JComboBox<String> cmbKeyAtt;
    private JComboBox<String> cmbKeyAttEdit;
    private JComboBox<String> cmbKeyAttView;
    private JComboBox<String> cmbOri;
    private JComboBox<String> cmbTextContent;
    private JComboBox<String> cmbTextDX;
    private JComboBox<String> cmbTextDY;
    private JComboBox<String> cmbTextOri;
    private Box.Filler filler2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JLabel lblAttribute;
    private JLabel lblAttributeEdit;
    private JLabel lblCRSFrom;
    private JLabel lblCRSTo;
    private JLabel lblCalcOri;
    private JLabel lblDatastore;
    private JLabel lblDatatype;
    private JLabel lblDatatypeEdit;
    private JLabel lblEquals;
    private JLabel lblFilter;
    private JLabel lblKeyAtt;
    private JLabel lblKeyAttView;
    private JLabel lblLinkEdit;
    private JLabel lblLinkKeyAttEdit;
    private JLabel lblOri;
    private JLabel lblTextContent;
    private JLabel lblTextDX;
    private JLabel lblTextDY;
    private JLabel lblTextOri;
    private JList<String> lstGeomType;
    private JPanel pnlData;
    private JPanel pnlDigiCommon;
    private JPanel pnlDigiText;
    private JPanel pnlExtra;
    private JTabbedPane tabDetail;
    private JTextArea txtAttribute;
    private JTextArea txtAttributeEdit;
    private JTextField txtCalcOri;
    private JTextField txtDatatype;
    private JTextField txtDatatypeEdit;
    private JTextArea txtFilter;

    public FeaturestorePanel() {
        this.fmd = new FeaturestoreMetadata();
        this.initComponents();
        this.fillLists();
        this.i18n();
    }

    public FeaturestorePanel(FeaturestoreMetadata _fmd) {
        this.fmd = _fmd;
        this.initComponents();
        this.fillLists();
        this.i18n();
    }

    public void addActionListener(ActionListener listener) {
        this.lstActionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.lstActionListeners.remove(listener);
    }

    private void fireInputChange() {
        ActionEvent e = new ActionEvent(this, 0, "INPUT_CHANGE");
        for (ActionListener listener : this.lstActionListeners) {
            listener.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLists() {
        boolean boltmp = this.blockEvents;
        try {
            this.blockEvents = true;
            ArrayList lstCRS = new ArrayList(CRSDefFactory.getCRSDefinitionList());
            Collections.sort(lstCRS);
            for (CRSDefinition crsDef : lstCRS) {
                this.cmbCRSFrom.addItem(crsDef);
                this.cmbCRSTo.addItem(crsDef);
            }
            this.lstCmbAttEdit.add(this.cmbOri);
            this.lstCmbAttEdit.add(this.cmbTextContent);
            this.lstCmbAttEdit.add(this.cmbTextOri);
            this.lstCmbAttEdit.add(this.cmbTextDX);
            this.lstCmbAttEdit.add(this.cmbTextDY);
            this.cmbKeyAttEdit.addItem(PRIMARY_KEY);
            this.lstCmbAtt.add(this.cmbKeyAtt);
            this.lstCmbAtt.add(this.cmbKeyAttView);
        }
        finally {
            this.blockEvents = boltmp;
        }
    }

    private void setEditEnabledState(boolean bolEnabled) {
        this.cmbKeyAttEdit.setEnabled(bolEnabled);
        this.txtAttributeEdit.setEnabled(bolEnabled);
        this.txtDatatypeEdit.setEnabled(bolEnabled);
        this.butDatatypeEdit.setEnabled(bolEnabled);
        this.butAttributesEdit.setEnabled(bolEnabled);
        this.lblAttributeEdit.setEnabled(bolEnabled);
        this.lblDatatypeEdit.setEnabled(bolEnabled);
        this.lblLinkEdit.setEnabled(bolEnabled);
    }

    private void setLabelEnabledState(boolean bolEnabled) {
        this.cmbTextContent.setEnabled(bolEnabled);
        this.cmbTextOri.setEnabled(bolEnabled);
        this.cmbTextDX.setEnabled(bolEnabled);
        this.cmbTextDY.setEnabled(bolEnabled);
    }

    public void setFMD(FeaturestoreMetadata _fmd) {
        this.runWithoutEvents(() -> {
            this.fmd = _fmd;
            this.cmbDatastore.getModel().setSelectedItem(this.fmd.getDatastoreName());
            this.txtDatatype.setText(this.fmd.getDatatypeName());
            StringBuffer sbAtt = new StringBuffer();
            if (this.fmd.getAttributes() != null) {
                for (String attribute : this.fmd.getAttributes()) {
                    if (sbAtt.length() == 0) {
                        sbAtt.append(attribute);
                        continue;
                    }
                    sbAtt.append(", ").append(attribute);
                }
                this.txtAttribute.setText(sbAtt.toString());
            } else {
                this.txtAttribute.setText("");
            }
            this.cboEditInOtherTable.setSelected(this.fmd.getEditInOtherDatatype());
            this.setEditEnabledState(this.fmd.getEditInOtherDatatype());
            this.txtDatatypeEdit.setText(this.fmd.getDatatypeNameEdit());
            sbAtt = new StringBuffer();
            if (this.fmd.getAttributesEdit() != null) {
                for (String attributesEdit : this.fmd.getAttributesEdit()) {
                    if (sbAtt.length() == 0) {
                        sbAtt.append(attributesEdit);
                        continue;
                    }
                    sbAtt.append(", ").append(attributesEdit);
                }
                this.txtAttributeEdit.setText(sbAtt.toString());
            } else {
                this.txtAttributeEdit.setText("");
            }
            this.txtFilter.setText(this.fmd.getFilterText());
            this.updateTransformationUIFromFMD();
            this.addAttributes(this.fmd.getAttributes(), this.fmd.getAttributes(), this.lstCmbAtt);
            this.addAttributes(this.fmd.getAttributesEdit(), this.fmd.getAttributes(), this.lstCmbAttEdit);
            this.lblLinkKeyAttEdit.setText(ObjectUtils.toString((Object)this.cmbKeyAtt.getSelectedItem()));
            this.cboInsertAllowed.setSelected(this.fmd.isInsertAllowed());
            this.cboDeleteAllowed.setSelected(this.fmd.isDeleteAllowed());
            this.cboUseText.setSelected(this.fmd.getUseText());
            this.setLabelEnabledState(this.fmd.getUseText());
            this.cboTransInOri.setSelected(this.fmd.isTextTransInOri());
            this.txtCalcOri.setText(this.fmd.getOriTrans());
            this.cboGeomType.setSelected(this.fmd.getRestrictGeomType());
            this.lstGeomType.setEnabled(this.fmd.getRestrictGeomType() && this.cboGeomType.isEnabled());
            Class<?>[] arrClasses = this.fmd.getGeomTypes();
            this.lstGeomType.clearSelection();
            if (arrClasses != null) {
                int[] arrSel = new int[arrClasses.length];
                for (int i = 0; i < arrClasses.length; ++i) {
                    if (arrClasses[i].equals(Point.class)) {
                        arrSel[i] = 0;
                        continue;
                    }
                    if (arrClasses[i].equals(LineString.class)) {
                        arrSel[i] = 1;
                        continue;
                    }
                    if (arrClasses[i].equals(Polygon.class)) {
                        arrSel[i] = 2;
                        continue;
                    }
                    if (arrClasses[i].equals(MultiPoint.class)) {
                        arrSel[i] = 3;
                        continue;
                    }
                    if (arrClasses[i].equals(MultiLineString.class)) {
                        arrSel[i] = 4;
                        continue;
                    }
                    if (arrClasses[i].equals(MultiPolygon.class)) {
                        arrSel[i] = 5;
                        continue;
                    }
                    if (!arrClasses[i].equals(GeometryCollection.class)) continue;
                    arrSel[i] = 6;
                }
                this.lstGeomType.setSelectedIndices(arrSel);
            }
        });
        this.selectInCombo(this.cmbKeyAtt, this.fmd.getKeyAtt());
        this.selectInCombo(this.cmbKeyAttView, this.fmd.getKeyAttView());
        this.selectInCombo(this.cmbKeyAttEdit, this.fmd.getKeyAttEdit());
        this.selectInCombo(this.cmbTextContent, this.fmd.getTextAtt());
        this.selectInCombo(this.cmbTextOri, this.fmd.getTextOriAtt());
        this.selectInCombo(this.cmbTextDX, this.fmd.getTextDXAtt());
        this.selectInCombo(this.cmbTextDY, this.fmd.getTextDYAtt());
        this.selectInCombo(this.cmbOri, this.fmd.getOriAtt());
        this.updateDraftState();
        this.cboGraphicDrafts.setSelected(this.fmd.isAllowGraphicDrafts());
    }

    public void setEnabledStateForTransformationUI(boolean globalEnabled) {
        this.runWithoutEvents(() -> {
            this.cboManualTransformation.setEnabled(globalEnabled);
            boolean manualTransform = this.cboManualTransformation.isSelected();
            boolean enabled = manualTransform && globalEnabled;
            this.lblCRSFrom.setEnabled(enabled);
            this.cmbCRSFrom.setEnabled(enabled);
            this.lblCRSTo.setEnabled(enabled);
            this.cmbCRSTo.setEnabled(enabled);
        });
    }

    private void updateTransformationUIFromFMD() {
        this.runWithoutEvents(() -> {
            boolean crsFromNotBlank = StringUtils.isNotBlank((CharSequence)this.fmd.getCRSFrom());
            boolean crsToNotBlank = StringUtils.isNotBlank((CharSequence)this.fmd.getCRSTo());
            boolean overwrite = crsFromNotBlank && crsToNotBlank;
            this.cboManualTransformation.setSelected(overwrite);
            if (overwrite) {
                this.cmbCRSFrom.setSelectedItem(CRSDefFactory.getCRSDefinition((String)this.fmd.getCRSFrom()));
                this.cmbCRSTo.setSelectedItem(CRSDefFactory.getCRSDefinition((String)this.fmd.getCRSTo()));
            } else {
                this.cmbCRSFrom.setSelectedItem(this.transformer.getCRSFromDataSource(this.fmd, this.dmdCol));
                this.cmbCRSTo.setSelectedItem(this.transformer.getCRSFromProject(this.dmdCol));
            }
        });
    }

    private void updateFMDFromTransformationUI() {
        if (this.cboManualTransformation.isSelected()) {
            this.fmd.setCRSFrom(CRSDefFactory.getKey((CRSDefinition)((CRSDefinition)this.cmbCRSFrom.getSelectedItem())));
            this.fmd.setCRSTo(CRSDefFactory.getKey((CRSDefinition)((CRSDefinition)this.cmbCRSTo.getSelectedItem())));
        } else {
            this.fmd.setCRSFrom(null);
            this.fmd.setCRSTo(null);
        }
    }

    public void setLayerType(int layerType) {
        this.layerType = layerType;
        this.enableLabelControls(true);
        this.enableOrientationControls(true);
        this.disableControls4LabelLayer(false);
        if (layerType == 2 || layerType == 3) {
            this.enableLabelControls(false);
            this.enableOrientationControls(false);
        }
        if (layerType == 4) {
            this.disableControls4LabelLayer(true);
        }
        this.cboGraphicDrafts.setVisible(layerType == 0);
    }

    public void enableOrientationControls(boolean enable) {
        this.lblOri.setVisible(enable);
        this.cmbOri.setVisible(enable);
        this.lblCalcOri.setVisible(enable);
        this.txtCalcOri.setVisible(enable);
    }

    public void enableLabelControls(boolean enable) {
        this.tabDetail.setEnabledAt(2, enable);
        if (!enable) {
            this.tabDetail.setSelectedIndex(0);
        }
    }

    private void disableControls4LabelLayer(boolean disable) {
        this.lblDatastore.setEnabled(!disable);
        this.cmbDatastore.setEnabled(!disable);
        this.setEnabledStateForTransformationUI(!disable);
        this.cboGeomType.setEnabled(!disable);
        this.lstGeomType.setEnabled(!disable);
        this.lblOri.setEnabled(!disable);
        this.cmbOri.setEnabled(!disable);
        this.cboInsertAllowed.setEnabled(!disable);
        this.cboDeleteAllowed.setEnabled(!disable);
        this.enableLabelControls(!disable);
    }

    private void selectInCombo(JComboBox<?> cmb, String strValue) {
        if (StringUtils.isEmpty((CharSequence)strValue)) {
            cmb.setSelectedIndex(0);
        } else {
            cmb.setSelectedItem(strValue);
            if (!cmb.getSelectedItem().equals(strValue)) {
                cmb.setSelectedIndex(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDMDCol(DMDCollection _dmdCol) {
        this.blockEvents = true;
        try {
            this.dmdCol = _dmdCol;
            this.cmbDatastore.removeAllItems();
            Iterator<DatastoreMetadata> i = this.dmdCol.iterator();
            while (i.hasNext()) {
                this.cmbDatastore.addItem(i.next());
            }
            if (this.fmd != null) {
                String strDataName;
                this.cmbDatastore.getModel().setSelectedItem(this.fmd.getDatastoreName());
                DatastoreMetadata dsMeta = this.dmdCol.getByName(this.fmd.getDatastoreName());
                if (dsMeta != null && (strDataName = this.dmdCol.getByName(this.fmd.getDatastoreName()).getDataName()) != null && strDataName.toLowerCase().indexOf("shape") != -1) {
                    this.fmd.resetDataStore(this.dmdCol);
                }
            }
        }
        finally {
            this.blockEvents = false;
        }
    }

    private void addAttributes(String[] arrAtt, String[] arrAttFilter, List<JComboBox<String>> lstCmb) {
        for (JComboBox<String> cmbToAdd : lstCmb) {
            String attSelected = "";
            if (cmbToAdd.getSelectedItem() != null) {
                attSelected = (String)cmbToAdd.getSelectedItem();
            }
            cmbToAdd.removeAllItems();
            if (cmbToAdd == this.cmbKeyAtt) {
                cmbToAdd.addItem(PRIMARY_KEY);
            } else {
                cmbToAdd.addItem("");
            }
            int selectionIndex = -1;
            if (arrAtt == null) continue;
            if (arrAttFilter != null) {
                List<String> lstAttFilter = Arrays.asList(arrAttFilter);
                int counter = 0;
                for (String arrAtt1 : arrAtt) {
                    if (!lstAttFilter.contains(arrAtt1)) continue;
                    cmbToAdd.addItem(arrAtt1);
                    if (arrAtt1.equals(attSelected)) {
                        selectionIndex = counter;
                    }
                    ++counter;
                }
            }
            if (selectionIndex > -1) {
                cmbToAdd.setSelectedIndex(selectionIndex + 1);
                continue;
            }
            cmbToAdd.setSelectedIndex(0);
        }
        if (this.layerType == 4) {
            boolean upperCase = FeatureTypeUtil.isSchemaNameInUpperCase((String)this.txtDatatype.getText());
            List<String> lstAtt = Arrays.asList(arrAtt);
            List<String> lstAttFilter = Arrays.asList(arrAttFilter);
            if (lstCmb == this.lstCmbAttEdit) {
                String strOri = FeatureTypeUtil.getSchemaAttribute((boolean)upperCase, (String)LabelFeatureAtts.ORIENTATION.getName());
                if (lstAtt.contains(strOri) && lstAttFilter.contains(strOri)) {
                    this.cmbTextOri.setSelectedItem(strOri);
                } else {
                    this.cmbTextOri.setSelectedIndex(0);
                }
                String strLabelText = FeatureTypeUtil.getSchemaAttribute((boolean)upperCase, (String)LabelFeatureAtts.LABEL_TEXT.getName());
                if (lstAtt.contains(strLabelText) && lstAttFilter.contains(strLabelText)) {
                    this.cmbTextContent.setSelectedItem(strLabelText);
                } else {
                    this.cmbTextContent.setSelectedIndex(0);
                }
            } else if (lstCmb == this.lstCmbAtt) {
                String strFidParent = FeatureTypeUtil.getSchemaAttribute((boolean)upperCase, (String)LabelFeatureAtts.FID_PARENT.getName());
                if (lstAtt.contains(strFidParent) && lstAttFilter.contains(strFidParent)) {
                    this.cmbKeyAttView.setSelectedItem(strFidParent);
                } else {
                    this.cmbKeyAttView.setSelectedIndex(0);
                }
            }
        }
    }

    public String testFeatureType(String typeName, String[] arrAtts) {
        if (this.layerType == 4) {
            try {
                DataStore store = this.fmd.getDataStore(this.dmdCol);
                Query query = new Query(typeName, (Filter)Filter.INCLUDE, arrAtts);
                DefaultView view = new DefaultView(store.getFeatureSource(typeName), query);
                SimpleFeatureType schema = view.getSchema();
                Object[] arrError = LabelFeatureAtts.checkStructure((SimpleFeatureType)schema);
                if (arrError != null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',');
                }
            }
            catch (Exception e) {
                return e.getLocalizedMessage();
            }
        }
        return null;
    }

    public String testFeatureType() {
        if (this.layerType == 4) {
            try {
                DataStore store = this.fmd.getDataStore(this.dmdCol);
                Query query = new Query(this.fmd.getDatatypeName(), (Filter)Filter.INCLUDE, this.retrieveAttributes(this.txtAttribute.getText()));
                DefaultView view = new DefaultView(store.getFeatureSource(query.getTypeName()), query);
                SimpleFeatureType schema = view.getSchema();
                Object[] arrError = LabelFeatureAtts.checkStructure((SimpleFeatureType)schema);
                if (arrError != null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',');
                }
                if (this.fmd.getEditInOtherDatatype() && (arrError = LabelFeatureAtts.checkStructure((SimpleFeatureType)(schema = (view = new DefaultView(store.getFeatureSource((query = new Query(this.fmd.getDatatypeNameEdit(), (Filter)Filter.INCLUDE, this.retrieveAttributes(this.txtAttributeEdit.getText()))).getTypeName()), query)).getSchema()))) != null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',');
                }
            }
            catch (Exception e) {
                return e.getLocalizedMessage();
            }
        }
        return null;
    }

    public String testConnection() {
        if (this.dmdCol == null || this.dmdCol.getInternalList().isEmpty()) {
            return I18N.get("de.riwagis.riwajump.FeaturestorePanel.test-impossible");
        }
        String strError = this.fmd.testConnection(this.dmdCol);
        if (strError != null) {
            return strError;
        }
        if (this.layerType == 4) {
            try {
                DataStore store = this.fmd.getDataStore(this.dmdCol);
                Query query = this.fmd.getQuery((Filter)Filter.INCLUDE);
                DefaultView view = new DefaultView(store.getFeatureSource(query.getTypeName()), query);
                SimpleFeatureType schema = view.getSchema();
                Object[] arrError = LabelFeatureAtts.checkStructure((SimpleFeatureType)schema);
                if (arrError != null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',');
                }
                if (this.fmd.getEditInOtherDatatype() && (arrError = LabelFeatureAtts.checkStructure((SimpleFeatureType)(schema = (view = new DefaultView(store.getFeatureSource((query = this.fmd.getQueryEdit((Filter)Filter.INCLUDE)).getTypeName()), query)).getSchema()))) != null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',');
                }
            }
            catch (Exception e) {
                return e.getLocalizedMessage();
            }
        }
        return null;
    }

    private void i18n() {
        this.lblDatastore.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.datastore"));
        this.lblDatatype.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.datatype"));
        this.lblAttribute.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.attribute"));
        this.lblKeyAtt.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.key-att"));
        this.lblKeyAttView.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.key-att-view"));
        this.lblKeyAttView.setToolTipText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.key-att-view-tooltip"));
        this.cmbKeyAttView.setToolTipText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.key-att-view-tooltip"));
        this.cboEditInOtherTable.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.edit-in-other-table"));
        this.lblLinkEdit.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.link-edit"));
        this.lblDatatypeEdit.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.datatype"));
        this.lblAttributeEdit.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.attribute"));
        this.lblCRSFrom.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.crsfrom"));
        this.lblCRSTo.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.crsto"));
        this.tabDetail.setTitleAt(0, I18N.get("de.riwagis.riwajump.FeaturestorePanel.tab-data"));
        this.tabDetail.setTitleAt(1, I18N.get("de.riwagis.riwajump.FeaturestorePanel.tab-common-digi"));
        this.cboInsertAllowed.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.insert-allowed"));
        this.cboDeleteAllowed.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.delete-allowed"));
        this.cboGeomType.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.restrict-geom-type"));
        this.cboGraphicDrafts.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.allow-graphic-drafts"));
        this.lblCalcOri.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.calc-ori"));
        this.lblOri.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.text-ori"));
        this.tabDetail.setTitleAt(2, I18N.get("de.riwagis.riwajump.FeaturestorePanel.tab-text-digi"));
        this.cboUseText.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.use-text"));
        this.lblTextContent.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.text-content"));
        this.lblTextOri.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.text-ori"));
        this.cboTransInOri.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.text-trans-in-ori"));
        this.lblTextDX.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.text-dx"));
        this.lblTextDY.setText(I18N.get("de.riwagis.riwajump.FeaturestorePanel.text-dy"));
        this.tabDetail.setTitleAt(3, I18N.get("de.riwagis.riwajump.FeaturestorePanel.tab-extended-settings"));
    }

    private <E extends Exception> void runWithoutEvents(ThrowingRunnable<E> action) throws E {
        boolean oldBlockEvents = this.blockEvents;
        try {
            this.blockEvents = true;
            action.run();
        }
        finally {
            this.blockEvents = oldBlockEvents;
        }
    }

    private void initComponents() {
        this.lblDatastore = new JLabel();
        this.lblDatatype = new JLabel();
        this.txtDatatype = new JTextField();
        this.lblAttribute = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtAttribute = new JTextArea();
        this.butDatatype = new JButton();
        this.cmbDatastore = new JComboBox();
        this.butAttributes = new JButton();
        this.tabDetail = new JTabbedPane();
        this.pnlData = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.txtFilter = new JTextArea();
        this.lblFilter = new JLabel();
        this.pnlDigiCommon = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstGeomType = new JList();
        this.cboGeomType = new JCheckBox();
        this.txtCalcOri = new JTextField();
        this.lblCalcOri = new JLabel();
        this.cboInsertAllowed = new JCheckBox();
        this.cboDeleteAllowed = new JCheckBox();
        this.cmbOri = new JComboBox();
        this.lblOri = new JLabel();
        this.cboGraphicDrafts = new JCheckBox();
        this.pnlDigiText = new JPanel();
        this.lblTextContent = new JLabel();
        this.lblTextOri = new JLabel();
        this.lblTextDX = new JLabel();
        this.lblTextDY = new JLabel();
        this.cmbTextContent = new JComboBox();
        this.cmbTextOri = new JComboBox();
        this.cmbTextDX = new JComboBox();
        this.cmbTextDY = new JComboBox();
        this.cboUseText = new JCheckBox();
        this.cboTransInOri = new JCheckBox();
        this.pnlExtra = new JPanel();
        this.lblCRSFrom = new JLabel();
        this.cmbCRSFrom = new JComboBox();
        this.lblCRSTo = new JLabel();
        this.cmbCRSTo = new JComboBox();
        this.lblKeyAttView = new JLabel();
        this.cmbKeyAttView = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.cboManualTransformation = new JCheckBox();
        this.cboEditInOtherTable = new JCheckBox();
        this.lblLinkEdit = new JLabel();
        this.txtDatatypeEdit = new JTextField();
        this.lblDatatypeEdit = new JLabel();
        this.butDatatypeEdit = new JButton();
        this.butAttributesEdit = new JButton();
        this.lblAttributeEdit = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.txtAttributeEdit = new JTextArea();
        this.jPanel1 = new JPanel();
        this.cmbKeyAttEdit = new JComboBox();
        this.lblEquals = new JLabel();
        this.lblLinkKeyAttEdit = new JLabel();
        this.cmbKeyAtt = new JComboBox();
        this.lblKeyAtt = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblDatastore.setText("Datenquelle:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(11, 9, 3, 3);
        this.add((Component)this.lblDatastore, gridBagConstraints);
        this.lblDatatype.setText("Tabelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 9, 3, 3);
        this.add((Component)this.lblDatatype, gridBagConstraints);
        this.txtDatatype.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturestorePanel.this.txtDatatype_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDatatype, gridBagConstraints);
        this.lblAttribute.setText("Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblAttribute, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(164, 50));
        this.txtAttribute.setFont(this.txtDatatype.getFont());
        this.txtAttribute.setLineWrap(true);
        this.txtAttribute.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturestorePanel.this.txtAttribute_onKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.txtAttribute);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.butDatatype.setText("...");
        this.butDatatype.addActionListener(this::butDatatype_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butDatatype, gridBagConstraints);
        this.cmbDatastore.setEditable(true);
        this.cmbDatastore.addActionListener(this::cmdDatastore_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add(this.cmbDatastore, gridBagConstraints);
        this.butAttributes.setText("...");
        this.butAttributes.addActionListener(this::butAttributes_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butAttributes, gridBagConstraints);
        this.pnlData.setLayout(new GridBagLayout());
        this.jScrollPane2.setPreferredSize(new Dimension(164, 70));
        this.txtFilter.setFont(this.txtDatatype.getFont());
        this.txtFilter.setLineWrap(true);
        this.txtFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturestorePanel.this.txtFilter_onKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.txtFilter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlData.add((Component)this.jScrollPane2, gridBagConstraints);
        this.lblFilter.setText("Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlData.add((Component)this.lblFilter, gridBagConstraints);
        this.tabDetail.addTab("tab1", this.pnlData);
        this.pnlDigiCommon.setLayout(new GridBagLayout());
        this.jScrollPane3.setMinimumSize(new Dimension(80, 100));
        this.jScrollPane3.setPreferredSize(new Dimension(120, 100));
        this.lstGeomType.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Point", "LineString", "Polygon", "MultiPoint", "MultiLineString", "MultiPolygon", "GeometryCollection"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstGeomType.setEnabled(false);
        this.lstGeomType.addListSelectionListener(this::lstGeomType_onValueChanged);
        this.jScrollPane3.setViewportView(this.lstGeomType);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.jScrollPane3, gridBagConstraints);
        this.cboGeomType.setText("Geometrietypen f\u00fcr Datenerfassung einschr\u00e4nken");
        this.cboGeomType.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboGeomType.setMargin(new Insets(0, 0, 0, 0));
        this.cboGeomType.addActionListener(this::cboGeomType_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.cboGeomType, gridBagConstraints);
        this.txtCalcOri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FeaturestorePanel.this.txtCalcOri_onFocusLost(evt);
            }
        });
        this.txtCalcOri.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturestorePanel.this.txtCalcOri_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        this.pnlDigiCommon.add((Component)this.txtCalcOri, gridBagConstraints);
        this.lblCalcOri.setText("Umwandung Orientierung: (Variable = value)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.lblCalcOri, gridBagConstraints);
        this.cboInsertAllowed.setText("Einf\u00fcgen von Datens\u00e4tzen erlauben");
        this.cboInsertAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboInsertAllowed.setMargin(new Insets(0, 0, 0, 0));
        this.cboInsertAllowed.addActionListener(this::cboInsertAllowed_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.cboInsertAllowed, gridBagConstraints);
        this.cboDeleteAllowed.setText("L\u00f6schen von Datens\u00e4tzen erlauben");
        this.cboDeleteAllowed.setBorder(null);
        this.cboDeleteAllowed.setMargin(new Insets(0, 0, 0, 0));
        this.cboDeleteAllowed.addActionListener(this::cboDeleteAllowedActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.cboDeleteAllowed, gridBagConstraints);
        this.cmbOri.addActionListener(this::cmbOri_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        this.pnlDigiCommon.add(this.cmbOri, gridBagConstraints);
        this.lblOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.lblOri, gridBagConstraints);
        this.cboGraphicDrafts.setText("Vorlagedatensatzerfassung in Grafik erlauben");
        this.cboGraphicDrafts.setActionCommand("Vorlagedatensatzerfassung erlauben");
        this.cboGraphicDrafts.setBorder(null);
        this.cboGraphicDrafts.setMargin(new Insets(0, 0, 0, 0));
        this.cboGraphicDrafts.addActionListener(this::cboGraphicDraftsActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDigiCommon.add((Component)this.cboGraphicDrafts, gridBagConstraints);
        this.tabDetail.addTab("tab4", this.pnlDigiCommon);
        this.pnlDigiText.setLayout(new GridBagLayout());
        this.lblTextContent.setText("Inhalt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlDigiText.add((Component)this.lblTextContent, gridBagConstraints);
        this.lblTextOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDigiText.add((Component)this.lblTextOri, gridBagConstraints);
        this.lblTextDX.setText("Versatz links:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDigiText.add((Component)this.lblTextDX, gridBagConstraints);
        this.lblTextDY.setText("Versatz oben:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 3, 9, 3);
        this.pnlDigiText.add((Component)this.lblTextDY, gridBagConstraints);
        this.cmbTextContent.setMinimumSize(new Dimension(130, 18));
        this.cmbTextContent.setPreferredSize(new Dimension(130, 22));
        this.cmbTextContent.addActionListener(this::cmbTextContent_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlDigiText.add(this.cmbTextContent, gridBagConstraints);
        this.cmbTextOri.addActionListener(this::cmbTextOri_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDigiText.add(this.cmbTextOri, gridBagConstraints);
        this.cmbTextDX.addActionListener(this::cmbTextDX_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDigiText.add(this.cmbTextDX, gridBagConstraints);
        this.cmbTextDY.addActionListener(this::cmbTextDY_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDigiText.add(this.cmbTextDY, gridBagConstraints);
        this.cboUseText.setText("Labels verwenden");
        this.cboUseText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboUseText.setMargin(new Insets(0, 0, 0, 0));
        this.cboUseText.addActionListener(this::cboUseText_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlDigiText.add((Component)this.cboUseText, gridBagConstraints);
        this.cboTransInOri.setText("Versatz in Orientierung");
        this.cboTransInOri.addActionListener(this::cboTransInOriActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlDigiText.add((Component)this.cboTransInOri, gridBagConstraints);
        this.tabDetail.addTab("tab2", this.pnlDigiText);
        this.pnlExtra.setLayout(new GridBagLayout());
        this.lblCRSFrom.setText("Transformation von:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlExtra.add((Component)this.lblCRSFrom, gridBagConstraints);
        this.cmbCRSFrom.addActionListener(this::cmbCRSFrom_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlExtra.add(this.cmbCRSFrom, gridBagConstraints);
        this.lblCRSTo.setText("Transformation nach:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlExtra.add((Component)this.lblCRSTo, gridBagConstraints);
        this.cmbCRSTo.addActionListener(this::cmbCRSTo_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlExtra.add(this.cmbCRSTo, gridBagConstraints);
        this.lblKeyAttView.setText("Anzeige-Attribut:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlExtra.add((Component)this.lblKeyAttView, gridBagConstraints);
        this.cmbKeyAttView.setMinimumSize(new Dimension(40, 22));
        this.cmbKeyAttView.setPreferredSize(new Dimension(130, 22));
        this.cmbKeyAttView.addActionListener(this::cmbKeyAttView_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlExtra.add(this.cmbKeyAttView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        this.pnlExtra.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.pnlExtra.add((Component)this.filler2, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.cboManualTransformation.setText(bundle.getString("de.riwagis.riwajump.FeaturestorePanel.override-crs"));
        this.cboManualTransformation.addActionListener(this::cboManualTransformationActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlExtra.add((Component)this.cboManualTransformation, gridBagConstraints);
        this.tabDetail.addTab("tab4", this.pnlExtra);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabDetail, gridBagConstraints);
        this.cboEditInOtherTable.setText("Datenerfassung in andere Tabelle");
        this.cboEditInOtherTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboEditInOtherTable.setMargin(new Insets(0, 0, 0, 0));
        this.cboEditInOtherTable.addActionListener(this::cboEditInOtherTable_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.cboEditInOtherTable, gridBagConstraints);
        this.lblLinkEdit.setText("Verkn\u00fcpfung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 9, 3, 3);
        this.add((Component)this.lblLinkEdit, gridBagConstraints);
        this.txtDatatypeEdit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturestorePanel.this.txtDatatypeEdit_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDatatypeEdit, gridBagConstraints);
        this.lblDatatypeEdit.setText("Tabelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblDatatypeEdit, gridBagConstraints);
        this.butDatatypeEdit.setText("...");
        this.butDatatypeEdit.addActionListener(this::butDatatypeEdit_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butDatatypeEdit, gridBagConstraints);
        this.butAttributesEdit.setText("...");
        this.butAttributesEdit.addActionListener(this::butAttributesEdit_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butAttributesEdit, gridBagConstraints);
        this.lblAttributeEdit.setText("Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblAttributeEdit, gridBagConstraints);
        this.jScrollPane4.setPreferredSize(new Dimension(164, 50));
        this.txtAttributeEdit.setFont(this.txtDatatype.getFont());
        this.txtAttributeEdit.setLineWrap(true);
        this.txtAttributeEdit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturestorePanel.this.txtAttributeEdit_onKeyReleased(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.txtAttributeEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.cmbKeyAttEdit.setMinimumSize(new Dimension(40, 22));
        this.cmbKeyAttEdit.setPreferredSize(new Dimension(130, 22));
        this.cmbKeyAttEdit.addActionListener(this::cmbKeyAttEdit_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add(this.cmbKeyAttEdit, gridBagConstraints);
        this.lblEquals.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.lblEquals, gridBagConstraints);
        this.lblLinkKeyAttEdit.setText("key");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.lblLinkKeyAttEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.cmbKeyAtt.setMinimumSize(new Dimension(130, 22));
        this.cmbKeyAtt.setPreferredSize(new Dimension(130, 22));
        this.cmbKeyAtt.addActionListener(this::cmbKeyAtt_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cmbKeyAtt, gridBagConstraints);
        this.lblKeyAtt.setText("ID-Attribut:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.lblKeyAtt, gridBagConstraints);
    }

    private void cmbOri_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbOri.getSelectedItem() == null) {
            return;
        }
        this.fmd.setOriAtt(this.cmbOri.getSelectedItem().toString());
        this.fireInputChange();
    }

    private void cboUseText_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setUseText(this.cboUseText.isSelected());
        this.setLabelEnabledState(this.fmd.getUseText());
        this.fireInputChange();
    }

    private void cmbKeyAtt_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.lblLinkKeyAttEdit.setText(ObjectUtils.toString((Object)this.cmbKeyAtt.getSelectedItem()));
        if (this.cmbKeyAtt.getSelectedItem() == null) {
            return;
        }
        if (this.cmbKeyAtt.getSelectedIndex() == 0) {
            this.fmd.setKeyAtt(null);
            return;
        }
        this.fmd.setKeyAtt(this.cmbKeyAtt.getSelectedItem().toString());
        this.fireInputChange();
    }

    private void cmbKeyAttEdit_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbKeyAttEdit.getSelectedItem() == null) {
            return;
        }
        if (this.cmbKeyAttEdit.getSelectedIndex() == 0) {
            this.fmd.setKeyAttEdit(null);
            return;
        }
        this.fmd.setKeyAttEdit(this.cmbKeyAttEdit.getSelectedItem().toString());
        this.fireInputChange();
    }

    private void cboEditInOtherTable_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setEditInOtherDatatype(this.cboEditInOtherTable.isSelected());
        this.setEditEnabledState(this.cboEditInOtherTable.isSelected());
        this.cmbKeyAttEdit_onActionPerformed(null);
        this.fmd.setDatatypeNameEdit(this.txtDatatypeEdit.getText());
        this.txtAttributeEdit_onKeyReleased(null);
        this.fireInputChange();
    }

    private void txtAttributeEdit_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        String[] arrAtt = this.retrieveAttributes(this.txtAttributeEdit.getText());
        if (arrAtt == null) {
            return;
        }
        this.fmd.setAttributesEdit(arrAtt);
        this.addAttributes(this.fmd.getAttributes(), this.fmd.getAttributes(), this.lstCmbAtt);
        this.addAttributes(this.fmd.getAttributesEdit(), this.fmd.getAttributes(), this.lstCmbAttEdit);
        this.fireInputChange();
    }

    private void butAttributesEdit_onActionPerformed(ActionEvent evt) {
        try {
            SimpleFeatureType ftype = this.fmd.getSchemaEdit(this.dmdCol);
            if (this.dlgAttribute == null) {
                this.dlgAttribute = AttributeListDialog.createCenteredToWindow(this);
            }
            this.dlgAttribute.setFeatureType(ftype);
            this.dlgAttribute.setAttributeNames(this.fmd.getAttributesEdit());
            this.dlgAttribute.setVisible(true);
            if (this.dlgAttribute.wasOKPressed()) {
                String[] arrAttNames = this.dlgAttribute.getAttributeNames();
                String error = this.testFeatureType(this.fmd.getDatatypeNameEdit(), arrAttNames);
                if (error != null) {
                    throw new IOException(error);
                }
                this.fmd.setAttributesEdit(arrAttNames);
                this.addAttributes(this.fmd.getAttributes(), this.fmd.getAttributes(), this.lstCmbAtt);
                this.addAttributes(this.fmd.getAttributesEdit(), this.fmd.getAttributes(), this.lstCmbAttEdit);
                this.setFMD(this.fmd);
                this.fireInputChange();
            }
        }
        catch (Exception e) {
            LOG.error("Error at edit attribute selection.", (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void butDatatypeEdit_onActionPerformed(ActionEvent evt) {
        try {
            DatastoreMetadata dmd = this.dmdCol.getByName(this.fmd.getDatastoreName());
            if (dmd == null) {
                throw new IOException(String.format(I18N.get("common.datastore-not-found"), this.fmd.getDatastoreName()));
            }
            DatastoreMetadata newdmd = (DatastoreMetadata)dmd.clone();
            DataStore store = newdmd.getDataStore();
            if (this.dlgDatatype == null) {
                this.dlgDatatype = DatatypeListDialog.createCenteredToWindow(this);
            }
            this.dlgDatatype.setTypeNames(store.getTypeNames());
            if (this.fmd.getDatatypeNameEdit() != null) {
                this.dlgDatatype.setDatatype(this.fmd.getDatatypeNameEdit());
            }
            this.dlgDatatype.setVisible(true);
            if (this.dlgDatatype.wasOKPressed()) {
                this.fmd.setDatatypeNameEdit(this.dlgDatatype.getDatatype());
                this.setFMD(this.fmd);
                this.fireInputChange();
            }
        }
        catch (Exception e) {
            LOG.error("Error at edit table selection.", (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtDatatypeEdit_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setDatatypeNameEdit(this.txtDatatypeEdit.getText());
        this.fireInputChange();
    }

    private void cboInsertAllowed_onActionPerformed(ActionEvent evt) {
        this.fmd.setInsertAllowed(this.cboInsertAllowed.isSelected());
        this.updateDraftState();
        this.fireInputChange();
    }

    private void txtCalcOri_onFocusLost(FocusEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setOriTrans(this.txtCalcOri.getText());
    }

    private void txtCalcOri_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (BshValidator.validateCalculator((String)this.txtCalcOri.getText()) == null) {
            this.txtCalcOri.setForeground(Color.GREEN.darker());
        } else {
            this.txtCalcOri.setForeground(Color.RED.darker());
        }
        this.fmd.setOriTrans(this.txtCalcOri.getText());
        this.fireInputChange();
    }

    private void lstGeomType_onValueChanged(ListSelectionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        int[] arrSel = this.lstGeomType.getSelectedIndices();
        ArrayList<Class> lstGeomClass = new ArrayList<Class>();
        for (int i = 0; i < arrSel.length; ++i) {
            if (arrSel[i] == 0) {
                lstGeomClass.add(Point.class);
                continue;
            }
            if (arrSel[i] == 1) {
                lstGeomClass.add(LineString.class);
                continue;
            }
            if (arrSel[i] == 2) {
                lstGeomClass.add(Polygon.class);
                continue;
            }
            if (arrSel[i] == 3) {
                lstGeomClass.add(MultiPoint.class);
                if (lstGeomClass.contains(Point.class)) continue;
                lstGeomClass.add(0, Point.class);
                this.lstGeomType.addSelectionInterval(0, 0);
                continue;
            }
            if (arrSel[i] == 4) {
                lstGeomClass.add(MultiLineString.class);
                if (lstGeomClass.contains(LineString.class)) continue;
                lstGeomClass.add(0, LineString.class);
                this.lstGeomType.addSelectionInterval(1, 1);
                continue;
            }
            if (arrSel[i] == 5) {
                lstGeomClass.add(MultiPolygon.class);
                if (lstGeomClass.contains(Polygon.class)) continue;
                lstGeomClass.add(0, Polygon.class);
                this.lstGeomType.addSelectionInterval(2, 2);
                continue;
            }
            if (arrSel[i] != 6) continue;
            lstGeomClass.add(GeometryCollection.class);
        }
        Class[] arrGeomClass = lstGeomClass.toArray(new Class[lstGeomClass.size()]);
        this.fmd.setGeomTypes(arrGeomClass);
    }

    private void cboGeomType_onActionPerformed(ActionEvent evt) {
        this.fmd.setRestrictGeomType(this.cboGeomType.isSelected());
        if (this.lstGeomType.isEnabled() != this.cboGeomType.isSelected()) {
            this.lstGeomType.setEnabled(this.cboGeomType.isSelected());
            if (this.cboGeomType.isSelected() && this.lstGeomType.getSelectedIndices().length == 0) {
                int[] arrSel = new int[]{0, 1, 2, 3, 4, 5, 6};
                this.lstGeomType.setSelectedIndices(arrSel);
            }
        }
    }

    private void cmbTextDY_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbTextDY.getSelectedItem() == null) {
            return;
        }
        this.fmd.setTextDYAtt(this.cmbTextDY.getSelectedItem().toString());
    }

    private void cmbTextDX_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbTextDX.getSelectedItem() == null) {
            return;
        }
        this.fmd.setTextDXAtt(this.cmbTextDX.getSelectedItem().toString());
    }

    private void cmbTextOri_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbTextOri.getSelectedItem() == null) {
            return;
        }
        this.fmd.setTextOriAtt(this.cmbTextOri.getSelectedItem().toString());
    }

    private void cmbTextContent_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbTextContent.getSelectedItem() == null) {
            return;
        }
        this.fmd.setTextAtt(this.cmbTextContent.getSelectedItem().toString());
    }

    private void txtFilter_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setFilterText(this.txtFilter.getText());
        this.fireInputChange();
    }

    private void cmbCRSFrom_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setCRSFrom(CRSDefFactory.getKey((CRSDefinition)((CRSDefinition)this.cmbCRSFrom.getSelectedItem())));
    }

    private void cmbCRSTo_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setCRSTo(CRSDefFactory.getKey((CRSDefinition)((CRSDefinition)this.cmbCRSTo.getSelectedItem())));
    }

    private void butAttributes_onActionPerformed(ActionEvent evt) {
        try {
            SimpleFeatureType ftype = this.fmd.getSchema(this.dmdCol);
            if (this.dlgAttribute == null) {
                this.dlgAttribute = AttributeListDialog.createCenteredToWindow(this);
            }
            this.dlgAttribute.setFeatureType(ftype);
            this.dlgAttribute.setAttributeNames(this.fmd.getAttributes());
            this.dlgAttribute.setVisible(true);
            if (this.dlgAttribute.wasOKPressed()) {
                String[] arrAttNames = this.dlgAttribute.getAttributeNames();
                String error = this.testFeatureType(this.fmd.getDatatypeName(), arrAttNames);
                if (error != null) {
                    throw new IOException(error);
                }
                this.fmd.setAttributes(arrAttNames);
                this.addAttributes(this.fmd.getAttributes(), this.fmd.getAttributes(), this.lstCmbAtt);
                this.addAttributes(this.fmd.getAttributesEdit(), this.fmd.getAttributes(), this.lstCmbAttEdit);
                this.setFMD(this.fmd);
                this.fireInputChange();
            }
        }
        catch (Exception e) {
            LOG.error("Error at attribute selection.", (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void butDatatype_onActionPerformed(ActionEvent evt) {
        try {
            DatastoreMetadata dmd = this.dmdCol.getByName(this.fmd.getDatastoreName());
            if (dmd == null) {
                throw new IOException(String.format(I18N.get("common.datastore-not-found"), this.fmd.getDatastoreName()));
            }
            DatastoreMetadata newdmd = (DatastoreMetadata)dmd.clone();
            DataStore store = newdmd.getDataStore();
            if (this.dlgDatatype == null) {
                this.dlgDatatype = DatatypeListDialog.createCenteredToWindow(this);
            }
            this.dlgDatatype.setTypeNames(store.getTypeNames());
            if (this.fmd.getDatatypeName() != null) {
                this.dlgDatatype.setDatatype(this.fmd.getDatatypeName());
            }
            this.dlgDatatype.setVisible(true);
            if (this.dlgDatatype.wasOKPressed()) {
                this.fmd.setDatatypeName(this.dlgDatatype.getDatatype());
                this.setFMD(this.fmd);
                this.fireInputChange();
            }
        }
        catch (Exception e) {
            LOG.error("Error at table selection.", (Throwable)e);
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtAttribute_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        String[] arrAtt = this.retrieveAttributes(this.txtAttribute.getText());
        if (arrAtt == null) {
            return;
        }
        this.fmd.setAttributes(arrAtt);
        this.addAttributes(this.fmd.getAttributes(), this.fmd.getAttributes(), this.lstCmbAtt);
        this.addAttributes(this.fmd.getAttributesEdit(), this.fmd.getAttributes(), this.lstCmbAttEdit);
        this.fireInputChange();
    }

    private String[] retrieveAttributes(String atts) {
        String[] arrAtt = atts.split(",");
        return (String[])Arrays.stream(arrAtt).map(String::trim).filter(item -> !item.isEmpty()).distinct().toArray(String[]::new);
    }

    private void txtDatatype_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setDatatypeName(this.txtDatatype.getText());
        this.fireInputChange();
    }

    private void cmdDatastore_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbDatastore.getSelectedItem() instanceof DatastoreMetadata) {
            this.fmd.setDatastoreName(((DatastoreMetadata)this.cmbDatastore.getSelectedItem()).getName());
        } else {
            this.fmd.setDatastoreName(this.cmbDatastore.getSelectedItem().toString());
        }
        this.fmd.resetDataStore(this.dmdCol);
        this.updateDraftState();
        this.fireInputChange();
    }

    private void updateDraftState() {
        String message = this.isGraphicDraftsPossible();
        boolean possible = message == null;
        this.cboGraphicDrafts.setEnabled(possible);
        this.cboGraphicDrafts.setToolTipText(message);
    }

    private String isGraphicDraftsPossible() {
        if (!this.fmd.isInsertAllowed()) {
            return I18N.get("de.riwagis.riwajump.FeaturestorePanel.insert-not-allowed");
        }
        if (this.fmd == null || StringUtils.isBlank((CharSequence)this.fmd.getDatatypeName())) {
            return I18N.get("de.riwagis.riwajump.FeaturestorePanel.no-datastore-set");
        }
        try {
            boolean possible = GraphicDrafts.areGraphicDraftsPossible(this.fmd.getDataStore(this.dmdCol), this.fmd.getDatatypeName());
            if (!possible) {
                return I18N.get("de.riwagis.riwajump.FeaturestorePanel.graphic-drafts-not-supported");
            }
            return null;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("cannot get data store", (Throwable)e);
            return I18N.get("de.riwagis.riwajump.FeaturestorePanel.datastore-error");
        }
    }

    private void cmbKeyAttView_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.cmbKeyAttView.getSelectedItem() == null) {
            return;
        }
        if (this.cmbKeyAttView.getSelectedIndex() == 0) {
            this.fmd.setKeyAttView(null);
            return;
        }
        this.fmd.setKeyAttView(this.cmbKeyAttView.getSelectedItem().toString());
        this.fireInputChange();
    }

    private void cboTransInOriActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setTextTransInOri(((JCheckBox)evt.getSource()).isSelected());
        this.fireInputChange();
    }

    private void cboGraphicDraftsActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.fmd.setAllowGraphicDrafts(((JCheckBox)evt.getSource()).isSelected());
        this.fireInputChange();
    }

    private void cboDeleteAllowedActionPerformed(ActionEvent evt) {
        this.fmd.setDeleteAllowed(this.cboDeleteAllowed.isSelected());
        this.updateDraftState();
        this.fireInputChange();
    }

    private void cboManualTransformationActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.setEnabledStateForTransformationUI(true);
        this.updateFMDFromTransformationUI();
        this.updateTransformationUIFromFMD();
    }
}

