/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.data.gui.FeaturestorePanel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FeaturestoreDialog
extends JDialog {
    private FeaturestoreMetadata fmdOri;
    private FeaturestoreMetadata fmdClone;
    private FeaturestorePanel pnlFeaturestore = null;
    private final List<Validator> lstValidator = new ArrayList<Validator>();
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private JPanel pnlOKCancel;
    private JPanel pnlSuperFeatStore;

    public FeaturestoreDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public FeaturestoreDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    private void init() {
        this.initComponents();
        this.pnlFeaturestore = (FeaturestorePanel)this.pnlSuperFeatStore;
        this.i18n();
        this.setSize(new Dimension(450, 350));
    }

    private void i18n() {
        this.setTitle(I18N.get("de.riwagis.riwajump.FeaturestorePanel.title"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public void setFMD(FeaturestoreMetadata _fmd) {
        this.fmdOri = _fmd;
        this.fmdClone = this.fmdOri.clone();
        this.pnlFeaturestore.setFMD(this.fmdClone);
    }

    public void setDMDCol(DMDCollection _dmdCol) {
        if (_dmdCol == null) {
            return;
        }
        this.pnlFeaturestore.setDMDCol(_dmdCol);
    }

    public void addValidator(Validator val) {
        if (!this.lstValidator.contains(val)) {
            this.lstValidator.add(val);
        }
    }

    public void removeValidator(Validator val) {
        if (this.lstValidator.contains(val)) {
            this.lstValidator.remove(val);
        }
    }

    public void clearValidators() {
        this.lstValidator.clear();
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    private void initComponents() {
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlSuperFeatStore = new FeaturestorePanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturestoreDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturestoreDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butCancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlSuperFeatStore, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        for (Validator val : this.lstValidator) {
            String strError = val.check(this.fmdClone);
            if (strError == null) continue;
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
            return;
        }
        this.fmdOri.takeProperties(this.fmdClone);
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    public static void main(String ... args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FeaturestoreMetadata fmd = new FeaturestoreMetadata();
                fmd.setDatastoreName("Test");
                fmd.setDatatypeName("test1");
                fmd.setAttributes(new String[]{"spalte1", "spalte2"});
                fmd.setFilterText("test>19");
                FeaturestoreDialog dlg = new FeaturestoreDialog((Frame)null, true);
                dlg.setFMD(fmd);
                dlg.setVisible(true);
            }
        });
    }
}

