/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.gui.AttributeTypes;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class FeatureTypeTableModel
extends AbstractTableModel {
    private final List<AttrDescriptorFacade> lstAttributes = new ArrayList<AttrDescriptorFacade>();
    private boolean editable = true;
    private boolean geomEditable = true;
    private String strName = "";
    private boolean useGeometry = true;
    private Map<String, String> mapUpdatedAttNames = null;
    private static String[] arrColnames = new String[2];
    public static final Comparator<AttributeDescriptor> AttributeTypeComparator;

    public FeatureTypeTableModel(SimpleFeatureType fType, boolean useGeometry) {
        this.useGeometry = useGeometry;
        if (!useGeometry) {
            this.geomEditable = false;
        }
        this.setFeatureType(fType);
    }

    private void fillModel(AttributeDescriptor[] arrAtts, boolean forgetFinalTypes) {
        HashSet<String> setFinalTypes = new HashSet<String>();
        if (!forgetFinalTypes) {
            for (AttrDescriptorFacade faca : this.lstAttributes) {
                if (faca.isTypeEditable()) continue;
                setFinalTypes.add(faca.getAttributeDescriptor().getLocalName());
            }
        }
        this.lstAttributes.clear();
        Arrays.sort(arrAtts, AttributeTypeComparator);
        for (AttributeDescriptor arrAtt : arrAtts) {
            AttrDescriptorFacade faca = new AttrDescriptorFacade(this, arrAtt);
            if (setFinalTypes.contains(arrAtt.getLocalName())) {
                faca.setTypeEditable(false);
            }
            this.lstAttributes.add(faca);
        }
        this.fireTableDataChanged();
    }

    public void setFeatureType(SimpleFeatureType fType) {
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>();
        for (AttributeDescriptor ad : fType.getAttributeDescriptors()) {
            if (!this.useGeometry && ad instanceof GeometryDescriptor) continue;
            attributeDescriptors.add(ad);
        }
        AttributeDescriptor[] arrAtts = attributeDescriptors.toArray(new AttributeDescriptor[attributeDescriptors.size()]);
        this.setTypeName(fType.getTypeName());
        this.mapUpdatedAttNames = new HashMap<String, String>();
        this.fillModel(arrAtts, true);
    }

    public void setAttributTypesEditable(boolean editable) {
        for (AttrDescriptorFacade faca : this.lstAttributes) {
            faca.setTypeEditable(editable);
        }
    }

    public final void setTypeName(String _strName) {
        this.strName = _strName;
    }

    public String getTypeName() {
        return this.strName;
    }

    public void setEditable(boolean _editable) {
        this.editable = _editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setGeomEditable(boolean _geomEditable) {
        if (!this.useGeometry) {
            return;
        }
        this.geomEditable = _geomEditable;
    }

    public boolean isGeomEditable() {
        return this.geomEditable;
    }

    public SimpleFeatureType getFeatureType() throws SchemaException {
        AttrDescriptorFacade[] arrType;
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        for (AttrDescriptorFacade attrFac : arrType = this.lstAttributes.toArray(new AttrDescriptorFacade[this.lstAttributes.size()])) {
            ftBuilder.add(attrFac.getAttributeDescriptor());
        }
        ftBuilder.setName(this.strName);
        return ftBuilder.buildFeatureType();
    }

    public Map<String, String> getUpdatedAttributesMap() {
        return this.mapUpdatedAttNames;
    }

    public void removeAttributeType(int i) {
        AttributeDescriptor type;
        if (!this.editable) {
            return;
        }
        if (!this.geomEditable && (type = this.lstAttributes.get(i).getAttributeDescriptor()) instanceof GeometryDescriptor) {
            return;
        }
        if (this.lstAttributes.get(i) != null) {
            String strDelName = this.lstAttributes.get(i).getAttributeDescriptor().getLocalName();
            this.mapUpdatedAttNames.remove(strDelName);
        }
        this.lstAttributes.remove(i);
        this.fireTableRowsDeleted(i, i);
    }

    public String checkAttributeType(AttributeDescriptor attType) {
        String strError = null;
        if (attType.getName() == null || attType.getName().getLocalPart().trim().isEmpty()) {
            strError = I18N.get("common.error") + ": " + I18N.get("de.riwagis.riwajump.FeatureTypeTableModel.invalid-field-name");
        }
        if (attType instanceof GeometryDescriptor && this.hasGeoType()) {
            strError = I18N.get("common.error") + ": " + I18N.get("de.riwagis.riwajump.FeatureTypeTableModel.only-one-geometry");
        }
        if (this.containsName(attType.getName().getLocalPart())) {
            strError = I18N.get("common.error") + ": " + I18N.get("de.riwagis.riwajump.FeatureTypeTableModel.duplicate-field-name");
        }
        return strError;
    }

    private AttributeDescriptor[] getAttrDescArray() {
        AttributeDescriptor[] arrAttrDesc = new AttributeDescriptor[this.lstAttributes.size()];
        for (int i = 0; i < arrAttrDesc.length; ++i) {
            arrAttrDesc[i] = this.lstAttributes.get(i).getAttributeDescriptor();
        }
        return arrAttrDesc;
    }

    public void insertAttributeType(AttributeDescriptor att) throws Exception {
        if (!this.editable) {
            throw new IllegalArgumentException("not editable");
        }
        if (!this.geomEditable && att instanceof GeometryDescriptor) {
            throw new IllegalArgumentException("geometry not editable");
        }
        String strError = this.checkAttributeType(att);
        if (strError != null) {
            throw new IllegalArgumentException(strError);
        }
        this.lstAttributes.add(new AttrDescriptorFacade(this, att));
        this.fillModel(this.getAttrDescArray(), false);
    }

    public boolean hasGeoType() {
        if (!this.useGeometry) {
            return false;
        }
        Iterator<AttrDescriptorFacade> i = this.lstAttributes.iterator();
        while (i.hasNext()) {
            if (!(i.next().getAttributeDescriptor() instanceof GeometryDescriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean containsName(String strName) {
        Iterator<AttrDescriptorFacade> i = this.lstAttributes.iterator();
        while (i.hasNext()) {
            if (!i.next().getAttributeDescriptor().getName().getLocalPart().equalsIgnoreCase(strName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.lstAttributes.size();
    }

    @Override
    public int getColumnCount() {
        return arrColnames.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        AttributeDescriptor type = this.lstAttributes.get(row).getAttributeDescriptor();
        if (column == 0) {
            return type.getName();
        }
        if (column == 1) {
            return AttributeTypes.getAttributeTypeForClass(type.getType().getBinding());
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        return arrColnames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 1 && !this.lstAttributes.get(row).isTypeEditable()) {
            return false;
        }
        if (this.editable && this.geomEditable) {
            return true;
        }
        if (!this.editable) {
            return false;
        }
        AttributeDescriptor type = this.lstAttributes.get(row).getAttributeDescriptor();
        return !(type instanceof GeometryDescriptor);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        AttrDescriptorFacade delFacade = this.lstAttributes.remove(row);
        AttributeDescriptor delType = null;
        if (delFacade != null) {
            delType = delFacade.getAttributeDescriptor();
        }
        AttributeDescriptor type = null;
        AttributeTypeBuilder atBuilder = new AttributeTypeBuilder();
        atBuilder.init(delType);
        if (column == 0) {
            String strAttNameNew = (String)value;
            if (delType != null) {
                String strAttNameOld = delType.getLocalName();
                this.mapUpdatedAttNames.put(strAttNameOld, strAttNameNew);
            }
            atBuilder.setName(strAttNameNew);
            type = atBuilder.buildDescriptor(strAttNameNew);
        }
        if (column == 1) {
            atBuilder.setBinding(((AttributeTypes)((Object)value)).getBinding());
            type = atBuilder.buildDescriptor(delType.getName().getLocalPart());
        }
        if (type == null) {
            this.lstAttributes.add(row, delFacade);
            return;
        }
        if (this.checkAttributeType(type) != null) {
            Toolkit.getDefaultToolkit().beep();
            this.lstAttributes.add(row, delFacade);
            return;
        }
        this.lstAttributes.add(row, new AttrDescriptorFacade(this, type, delFacade.isTypeEditable()));
        this.fillModel(this.getAttrDescArray(), false);
    }

    static {
        FeatureTypeTableModel.arrColnames[0] = I18N.get("de.riwagis.riwajump.FeatureTypeTableModel.field-name");
        FeatureTypeTableModel.arrColnames[1] = I18N.get("de.riwagis.riwajump.FeatureTypeTableModel.datatype");
        AttributeTypeComparator = new Comparator<AttributeDescriptor>(){

            @Override
            public int compare(AttributeDescriptor att1, AttributeDescriptor att2) {
                return att1.getName().getLocalPart().compareTo(att2.getName().getLocalPart());
            }
        };
    }

    private class AttrDescriptorFacade {
        private AttributeDescriptor attrDesc = null;
        private boolean editable = true;

        private AttrDescriptorFacade(FeatureTypeTableModel featureTypeTableModel, AttributeDescriptor attrDesc) {
            this.attrDesc = attrDesc;
        }

        private AttrDescriptorFacade(FeatureTypeTableModel featureTypeTableModel, AttributeDescriptor attrDesc, boolean typeEditable) {
            this.attrDesc = attrDesc;
            this.editable = typeEditable;
        }

        private AttributeDescriptor getAttributeDescriptor() {
            return this.attrDesc;
        }

        private boolean isTypeEditable() {
            return this.editable;
        }

        private void setTypeEditable(boolean editable) {
            this.editable = editable;
        }
    }
}

