/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import de.riwagis.riwajump.data.gui.AttributeCategories;
import de.riwagis.riwajump.data.gui.AttributeTypeComboBox;
import de.riwagis.riwajump.data.gui.AttributeTypes;
import de.riwagis.riwajump.data.gui.FeatureTypeTableModel;
import java.awt.Component;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTypeTable
extends JTable {
    private SimpleFeatureType fType = null;
    private final Collection<AttributeTypes> setRestrictions = EnumSet.noneOf(AttributeTypes.class);
    private final boolean useGeometry;

    public FeatureTypeTable(SimpleFeatureType _fType, boolean useGeometry) {
        this.fType = _fType;
        this.useGeometry = useGeometry;
        this.setModel(new FeatureTypeTableModel(this.fType, useGeometry));
        TableColumn typeColumn = this.getColumn(this.getColumnName(1));
        typeColumn.setCellEditor(new ClassListTableCellEditor());
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void addTypeRestriction(AttributeTypes clazz) {
        if (!this.setRestrictions.contains((Object)clazz)) {
            this.setRestrictions.add(clazz);
        }
    }

    public Collection<AttributeTypes> getTypeRestrictions() {
        return this.setRestrictions;
    }

    public void setFeatureType(SimpleFeatureType _fType) {
        this.fType = _fType;
        ((FeatureTypeTableModel)this.getModel()).setFeatureType(this.fType);
    }

    private class ClassListTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private AttributeTypeComboBox cmbReturn = null;

        private ClassListTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            if (this.cmbReturn == null) {
                return String.class;
            }
            return this.cmbReturn.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.cmbReturn == null) {
                this.cmbReturn = new AttributeTypeComboBox(FeatureTypeTable.this.useGeometry ? AttributeCategories.ALL : AttributeCategories.NONGEOMETRIC);
                for (AttributeTypes ats : FeatureTypeTable.this.setRestrictions) {
                    this.cmbReturn.addTypeRestriction(ats);
                }
            }
            this.cmbReturn.setSelectedItem(value);
            return this.cmbReturn;
        }
    }
}

