/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.guitools.Tasks;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.gui.AddAttributeTypeDialog;
import de.riwagis.riwajump.data.gui.AttributeCategories;
import de.riwagis.riwajump.data.gui.AttributeTypeComboBox;
import de.riwagis.riwajump.data.gui.AttributeTypes;
import de.riwagis.riwajump.data.gui.FeatureTypeTable;
import de.riwagis.riwajump.data.gui.FeatureTypeTableModel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.workbench.ui.plugin.ImportStyleDefaults;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureTypePanel
extends JPanel {
    private static final Set<String> EVENT_BLACKLIST = Set.of("selectionBackground", "selectionForeground");
    private SimpleFeatureType fType = null;
    private final EditorFormat editorFormat;
    private final int mode;
    private final List<ActionListener> lstActionListeners = new ArrayList<ActionListener>();
    private String geometryName = null;
    public static final int MODE_CREATE = 0;
    public static final int MODE_EDIT = 1;
    public static final int MODE_VIEW = 2;
    private boolean boolShowGeometryInTable = false;
    private boolean boolShowGeometryInComboBox = true;
    private FeatureTypeSelector featureTypeSelector;
    private boolean blockEvents = false;
    private DatastoreMetadata dmd;
    private PlugInContext context;
    private JButton butAdd;
    private JButton butApply;
    private JButton butDelete;
    private JButton butTypeAdd;
    private JButton butTypeCreateLayer;
    private JButton butTypeDelete;
    private JButton butUndo;
    private JComboBox<CRSDefinition> cbCRS;
    private JComboBox cbGeometryType;
    private JComboBox<String> cbTypes;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler5;
    private JLabel lblAlias;
    private JLabel lblCRS;
    private JLabel lblGeometryType;
    private JLabel lblName;
    private JPanel pnlBottom;
    private JPanel pnlLeft;
    private JPanel pnlMultiTypes;
    private JPanel pnlTop;
    private JScrollPane scpFeatureType;
    private JTable tblFeatureType;
    private JTextField txtAlias;
    private JTextField txtName;

    public FeatureTypePanel(PlugInContext context, SimpleFeatureType fType, int mode, EditorFormat editorFormat) {
        this.context = context;
        this.fType = fType;
        this.editorFormat = editorFormat;
        this.mode = mode;
        this.initComponents();
        if (editorFormat.editAllDataTypesAtOnce() && mode != 0) {
            this.setupMultiTypeEdit();
        } else {
            this.setupSingleTypeEdit();
        }
        this.setFeatureType(fType);
        this.i18n();
    }

    private void i18n() {
        this.butUndo.setText(I18N.get("de.riwagis.riwajump.FeatureTypePanel.undo"));
        this.butApply.setText(I18N.get("apply"));
        this.butAdd.setToolTipText(I18N.get("common.add"));
        this.butDelete.setToolTipText(I18N.get("common.remove"));
        this.butTypeAdd.setToolTipText(I18N.get("add-datatype"));
        this.butTypeDelete.setToolTipText(I18N.get("delete-datatype"));
        this.butTypeCreateLayer.setToolTipText(I18N.get("create-layer-for-datatype"));
        this.lblName.setText(I18N.get("de.riwagis.riwajump.FeatureTypePanel.type-name"));
        if (this.lblAlias != null) {
            this.lblAlias.setText(I18N.get("label-alias"));
        }
        this.lblGeometryType.setText(I18N.get("label-geometrytype"));
        this.lblCRS.setText(I18N.get("label-crs"));
    }

    public void setDMD(DatastoreMetadata dmd) {
        this.dmd = dmd;
    }

    private void setupMultiTypeEdit() {
        this.featureTypeSelector = new MultiFeatureTypeSelector();
        this.pnlMultiTypes.setVisible(true);
        this.txtName.setVisible(false);
    }

    private void setupSingleTypeEdit() {
        this.featureTypeSelector = new SingleFeatureTypeSelector();
        this.pnlMultiTypes.setVisible(false);
        this.txtName.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatureType(SimpleFeatureType fType) {
        try {
            boolean typeSelected;
            this.blockEvents = true;
            this.fType = fType;
            boolean bl = typeSelected = fType != null;
            if (!typeSelected) {
                SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
                ftBuilder.setName("EMPTY");
                fType = ftBuilder.buildFeatureType();
            }
            boolean isInsert = !this.editorFormat.storeContainsType(this.dmd, fType.getTypeName()) && typeSelected;
            boolean isCreateOrInsert = this.mode == 0 || this.mode == 1 && this.editorFormat.editAllDataTypesAtOnce() && isInsert;
            this.filler1.setVisible(this.mode == 1);
            this.butApply.setVisible(this.mode == 1 && this.editorFormat.editAllDataTypesAtOnce());
            this.butApply.setEnabled(isInsert);
            this.butUndo.setEnabled(false);
            this.featureTypeSelector.setType(fType.getTypeName());
            ((FeatureTypeTable)this.tblFeatureType).setFeatureType(fType);
            FeatureTypeTableModel attributeModel = (FeatureTypeTableModel)this.tblFeatureType.getModel();
            this.butAdd.setEnabled(this.mode != 2 && typeSelected);
            this.butDelete.setEnabled(this.mode != 2 && typeSelected);
            attributeModel.setEditable(this.mode != 2 && typeSelected);
            attributeModel.setAttributTypesEditable(isCreateOrInsert);
            if (this.boolShowGeometryInComboBox) {
                AttributeTypeComboBox cbGeometryType = (AttributeTypeComboBox)this.cbGeometryType;
                GeometryDescriptor geometryDescriptor = fType.getGeometryDescriptor();
                if (geometryDescriptor != null) {
                    cbGeometryType.setAttributeType((AttributeType)geometryDescriptor.getType());
                    this.cbCRS.setSelectedItem(this.getCRSDefinition(fType));
                    this.geometryName = geometryDescriptor.getName().getLocalPart();
                } else {
                    cbGeometryType.setAttributeType(AttributeTypes.NO_GEOMETRY);
                    this.cbCRS.setSelectedItem(null);
                }
                cbGeometryType.setEnabled(isCreateOrInsert);
                this.cbCRS.setEnabled(isCreateOrInsert);
            }
            if (this.editorFormat.isTypeAliasable()) {
                this.txtAlias.setText(this.editorFormat.getAliasFromType(fType));
                this.txtAlias.setEnabled(typeSelected);
            }
            this.cbTypes.setEnabled(typeSelected);
            this.tblFeatureType.setEnabled(typeSelected);
            this.butTypeDelete.setEnabled(typeSelected);
            this.butTypeCreateLayer.setEnabled(typeSelected && !isInsert);
        }
        finally {
            this.blockEvents = false;
        }
    }

    private CRSDefinition getCRSDefinition(SimpleFeatureType fType) {
        CoordinateReferenceSystem crs = fType.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (crs == null) {
            return this.context.getTask().getCRSDefinition();
        }
        try {
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
            return CRSDefFactory.getCRSDefinition((String)Objects.toString(epsgCode));
        }
        catch (FactoryException ex) {
            throw new IllegalStateException("Cannot determine CRS from feature type", ex);
        }
    }

    public void addTypeRestriction(AttributeTypes clazz) {
        ((FeatureTypeTable)this.tblFeatureType).addTypeRestriction(clazz);
        if (this.boolShowGeometryInComboBox) {
            ((AttributeTypeComboBox)this.cbGeometryType).addTypeRestriction(clazz);
        }
    }

    public void setSchemaNameEditable(boolean editable) {
        this.featureTypeSelector.setEditable(editable);
    }

    public SimpleFeatureType getFeatureType() {
        try {
            this.stopEditing();
            FeatureTypeTableModel tableModel = (FeatureTypeTableModel)this.tblFeatureType.getModel();
            SimpleFeatureType schema = tableModel.getFeatureType();
            if (this.boolShowGeometryInComboBox) {
                GeometryType geomType;
                SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
                sftb.init(schema);
                sftb.setName(tableModel.getTypeName());
                CRSDefinition targetCRS = (CRSDefinition)this.cbCRS.getSelectedItem();
                if (targetCRS != null && (geomType = (GeometryType)((AttributeTypeComboBox)this.cbGeometryType).getAttributeType(targetCRS.getCRS())) != null) {
                    AttributeTypeBuilder atb = new AttributeTypeBuilder();
                    String finalGeomName = Objects.requireNonNullElse(this.geometryName, this.editorFormat.getGeometryName());
                    sftb.add((AttributeDescriptor)atb.buildDescriptor(finalGeomName, geomType));
                }
                schema = sftb.buildFeatureType();
            }
            if (this.editorFormat.isTypeAliasable()) {
                this.editorFormat.setAliasToType(schema, this.txtAlias.getText());
            }
            return schema;
        }
        catch (Exception e) {
            this.showErrorMessage("FeatureTypePanel. Error creating FeatureType.");
            return null;
        }
    }

    public Map<String, String> getUpdatedAttributesMap() {
        try {
            this.stopEditing();
            return ((FeatureTypeTableModel)this.tblFeatureType.getModel()).getUpdatedAttributesMap();
        }
        catch (Exception e) {
            this.showErrorMessage("FeatureTypePanel. Error creating updated attributes map.");
            return null;
        }
    }

    public void stopEditing() {
        if (this.tblFeatureType.getCellEditor() != null) {
            this.tblFeatureType.getCellEditor().stopCellEditing();
        }
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void addActionListener(ActionListener listener) {
        this.lstActionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.lstActionListeners.remove(listener);
    }

    private void fireInputChange() {
        this.fireInputChange(true);
    }

    private void fireInputChange(boolean updateChangedButtons) {
        if (this.blockEvents) {
            return;
        }
        if (updateChangedButtons) {
            this.butApply.setEnabled(true);
            this.butUndo.setEnabled(true);
        }
        ActionEvent e = new ActionEvent(this, 0, "INPUT_CHANGE");
        for (ActionListener listener : this.lstActionListeners) {
            listener.actionPerformed(e);
        }
    }

    public boolean hasUnsavedChanges() {
        return this.butApply.isEnabled();
    }

    private SimpleFeatureType persistChanges() {
        SimpleFeatureType targetSchema = this.getFeatureType();
        AtomicReference updatedSchemaRef = new AtomicReference();
        Tasks.submit(() -> {
            SimpleFeatureType updatedSchema = this.editorFormat.insertOrUpdateSchema(this.context, this.dmd, targetSchema, this.getUpdatedAttributesMap());
            updatedSchemaRef.set(updatedSchema);
        }, false, SwingUtilities.windowForComponent(this));
        return (SimpleFeatureType)updatedSchemaRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypesAndSelect(String[] typeNames, String selectedType) {
        this.setDMD(this.dmd);
        try {
            this.blockEvents = true;
            Arrays.sort(typeNames);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbTypes.getModel();
            model.removeAllElements();
            model.addAll(List.of(typeNames));
        }
        finally {
            this.blockEvents = false;
        }
        if (typeNames.length > 0) {
            if (selectedType == null) {
                selectedType = typeNames[0];
            }
            this.cbTypes.setSelectedItem(selectedType);
        } else {
            this.setFeatureType(null);
        }
    }

    private void initComponents() {
        this.pnlTop = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.pnlMultiTypes = new JPanel();
        this.cbTypes = new JComboBox();
        this.butTypeAdd = new JButton();
        this.butTypeDelete = new JButton();
        this.butTypeCreateLayer = new JButton();
        if (this.editorFormat.isTypeAliasable()) {
            this.lblAlias = new JLabel();
        }
        if (this.editorFormat.isTypeAliasable()) {
            this.txtAlias = new JTextField();
        }
        if (this.boolShowGeometryInComboBox) {
            this.lblGeometryType = new JLabel();
        }
        if (this.boolShowGeometryInComboBox) {
            this.cbGeometryType = new AttributeTypeComboBox(AttributeCategories.GEOMETRIC);
        }
        if (this.boolShowGeometryInComboBox) {
            this.lblCRS = new JLabel();
        }
        this.cbCRS = new JComboBox();
        ArrayList lstCRS = new ArrayList(CRSDefFactory.getCRSDefinitionList());
        Collections.sort(lstCRS);
        for (CRSDefinition crsDef : lstCRS) {
            this.cbCRS.addItem(crsDef);
        }
        this.pnlLeft = new JPanel();
        this.butAdd = new JButton();
        this.filler5 = new Box.Filler(new Dimension(0, 3), new Dimension(0, 3), new Dimension(Short.MAX_VALUE, 3));
        this.butDelete = new JButton();
        this.scpFeatureType = new JScrollPane();
        this.tblFeatureType = new FeatureTypeTable(this.fType, false);
        this.pnlBottom = new JPanel();
        this.filler2 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.butUndo = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(5, 5), new Dimension(0, 0));
        this.butApply = new JButton();
        this.setLayout(new GridBagLayout());
        this.pnlTop.setLayout(new GridBagLayout());
        this.lblName.setText("Name:");
        this.lblName.setHorizontalTextPosition(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        this.pnlTop.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setColumns(20);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeatureTypePanel.this.txtName_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        this.pnlTop.add((Component)this.txtName, gridBagConstraints);
        this.pnlMultiTypes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pnlMultiTypes.setLayout(new GridBagLayout());
        this.cbTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FeatureTypePanel.this.cbTypesItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        this.pnlMultiTypes.add(this.cbTypes, gridBagConstraints);
        this.butTypeAdd.setIcon(IconLoader.svgIconSmall((String)"common_add.svg"));
        this.butTypeAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butTypeAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlMultiTypes.add((Component)this.butTypeAdd, gridBagConstraints);
        this.butTypeDelete.setIcon(IconLoader.svgIconSmall((String)"common_delete.svg"));
        this.butTypeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butTypeDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlMultiTypes.add((Component)this.butTypeDelete, gridBagConstraints);
        this.butTypeCreateLayer.setIcon(IconLoader.svgIconSmall((String)"layer_add.svg"));
        this.butTypeCreateLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butTypeCreateLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlMultiTypes.add((Component)this.butTypeCreateLayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.pnlTop.add((Component)this.pnlMultiTypes, gridBagConstraints);
        if (this.editorFormat.isTypeAliasable()) {
            this.lblAlias.setText("Alias:");
            this.lblAlias.setHorizontalTextPosition(4);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(6, 6, 3, 3);
            this.pnlTop.add((Component)this.lblAlias, gridBagConstraints);
        }
        if (this.editorFormat.isTypeAliasable()) {
            this.txtAlias.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    FeatureTypePanel.this.txtAliasKeyReleased(evt);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 3, 3);
            this.pnlTop.add((Component)this.txtAlias, gridBagConstraints);
        }
        if (this.boolShowGeometryInComboBox) {
            this.lblGeometryType.setText("Geometrietyp:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(6, 6, 3, 3);
            this.pnlTop.add((Component)this.lblGeometryType, gridBagConstraints);
        }
        if (this.boolShowGeometryInComboBox) {
            this.cbGeometryType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    FeatureTypePanel.this.cbGeometryTypeItemStateChanged(evt);
                }
            });
            this.cbGeometryType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FeatureTypePanel.this.cbGeometryTypeActionPerformed(evt);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(6, 6, 3, 3);
            this.pnlTop.add((Component)this.cbGeometryType, gridBagConstraints);
        }
        if (this.boolShowGeometryInComboBox) {
            this.lblCRS.setText("Koordinatensystem:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(6, 6, 3, 3);
            this.pnlTop.add((Component)this.lblCRS, gridBagConstraints);
        }
        this.cbCRS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FeatureTypePanel.this.cbCRSItemStateChanged(evt);
            }
        });
        this.cbCRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.cbCRSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        this.pnlTop.add(this.cbCRS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTop, gridBagConstraints);
        this.pnlLeft.setLayout(new BoxLayout(this.pnlLeft, 1));
        this.butAdd.setIcon(IconLoader.svgIconSmall((String)"common_add.svg"));
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butAdd_onActionPerformed(evt);
            }
        });
        this.pnlLeft.add(this.butAdd);
        this.pnlLeft.add(this.filler5);
        this.butDelete.setIcon(IconLoader.svgIconSmall((String)"common_delete.svg"));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.pnlLeft.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlLeft, gridBagConstraints);
        this.scpFeatureType.setPreferredSize(new Dimension(200, 100));
        this.tblFeatureType.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FeatureTypePanel.this.tblFeatureType_onPropertyChange(evt);
            }
        });
        this.scpFeatureType.setViewportView(this.tblFeatureType);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.scpFeatureType, gridBagConstraints);
        this.pnlBottom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pnlBottom.setLayout(new FlowLayout(2, 0, 0));
        this.pnlBottom.add(this.filler2);
        this.butUndo.setText("\u00c4nderungen verwerfen");
        this.butUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butUndo_onActionPerformed(evt);
            }
        });
        this.pnlBottom.add(this.butUndo);
        this.pnlBottom.add(this.filler1);
        this.butApply.setText("Anwenden");
        this.butApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTypePanel.this.butApplyActionPerformed(evt);
            }
        });
        this.pnlBottom.add(this.butApply);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlBottom, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butAdd_onActionPerformed(ActionEvent evt) {
        AttributeCategories showGeometry;
        this.stopEditing();
        Window parent = SwingUtilities.windowForComponent(this);
        Window typeDlg = null;
        AttributeCategories attributeCategories = showGeometry = this.boolShowGeometryInTable ? AttributeCategories.ALL : AttributeCategories.NONGEOMETRIC;
        if (parent instanceof Frame) {
            typeDlg = new AddAttributeTypeDialog((Frame)parent, (FeatureTypeTable)this.tblFeatureType, true, showGeometry);
        } else if (parent instanceof Dialog) {
            typeDlg = new AddAttributeTypeDialog((Dialog)parent, (FeatureTypeTable)this.tblFeatureType, true, showGeometry);
        }
        typeDlg.setLocationRelativeTo(parent);
        ((Dialog)typeDlg).setVisible(true);
        if (((AddAttributeTypeDialog)typeDlg).wasOKPressed()) {
            try {
                FeatureTypeTableModel model = (FeatureTypeTableModel)this.tblFeatureType.getModel();
                AttributeDescriptor attType = ((AddAttributeTypeDialog)typeDlg).getAttributeDescriptor();
                model.insertAttributeType(attType);
            }
            catch (Exception e) {
                this.showErrorMessage(e.getMessage());
                this.butAdd_onActionPerformed(evt);
            }
            finally {
                this.fireInputChange();
            }
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        this.stopEditing();
        int[] arrRows = this.tblFeatureType.getSelectedRows();
        Arrays.sort(arrRows);
        for (int i = arrRows.length - 1; i > -1; --i) {
            ((FeatureTypeTableModel)this.tblFeatureType.getModel()).removeAttributeType(arrRows[i]);
        }
        this.fireInputChange();
    }

    private void butUndo_onActionPerformed(ActionEvent evt) {
        this.stopEditing();
        this.setFeatureType(this.fType);
        this.fireInputChange(false);
    }

    private void txtName_onKeyReleased(KeyEvent evt) {
        ((FeatureTypeTableModel)this.tblFeatureType.getModel()).setTypeName(this.txtName.getText());
        this.fireInputChange();
    }

    private void cbGeometryTypeItemStateChanged(ItemEvent evt) {
        this.cbCRS.setEnabled(AttributeTypes.NO_GEOMETRY != this.cbGeometryType.getSelectedItem());
        this.fireInputChange();
    }

    private void cbGeometryTypeActionPerformed(ActionEvent evt) {
        this.fireInputChange();
    }

    private void tblFeatureType_onPropertyChange(PropertyChangeEvent evt) {
        if (this.blockEvents || EVENT_BLACKLIST.contains(evt.getPropertyName())) {
            return;
        }
        this.fireInputChange();
    }

    private void cbCRSActionPerformed(ActionEvent evt) {
        this.fireInputChange();
    }

    private void cbCRSItemStateChanged(ItemEvent evt) {
        this.fireInputChange();
    }

    private void txtAliasKeyReleased(KeyEvent evt) {
        this.fireInputChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cbTypesItemStateChanged(ItemEvent evt) {
        block11: {
            if (this.blockEvents) {
                return;
            }
            try {
                if (evt.getStateChange() == 2) {
                    if (!this.hasUnsavedChanges()) break block11;
                    boolean saveChanges = GUISupport.yesnobox((Component)SwingUtilities.windowForComponent(this), (String)I18N.get("question-datatype-contains-changes-save"), (String)I18N.get("change-datatype"));
                    if (saveChanges) {
                        this.persistChanges();
                        break block11;
                    }
                    String typeName = this.getFeatureType().getTypeName();
                    if (this.editorFormat.storeContainsType(this.dmd, typeName)) break block11;
                    try {
                        this.blockEvents = true;
                        this.cbTypes.removeItem(typeName);
                        break block11;
                    }
                    finally {
                        this.blockEvents = false;
                    }
                }
                if (evt.getStateChange() == 1) {
                    SimpleFeatureType schema;
                    String typeName = (String)evt.getItem();
                    ((FeatureTypeTableModel)this.tblFeatureType.getModel()).setTypeName((String)this.cbTypes.getSelectedItem());
                    boolean containsType = this.editorFormat.storeContainsType(this.dmd, typeName);
                    if (containsType) {
                        schema = this.editorFormat.getSchemaFromStore(this.dmd.getDataStore(), typeName);
                    } else {
                        CoordinateReferenceSystem crs = this.context.getTask().getCRSDefinition().getCRS();
                        schema = ImportStyleDefaults.createTemplateType(typeName, this.editorFormat.getGeometryName(), crs);
                    }
                    this.setFeatureType(schema);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private void butApplyActionPerformed(ActionEvent evt) {
        SimpleFeatureType updatedSchema = this.persistChanges();
        if (updatedSchema == null) {
            return;
        }
        this.setFeatureType(updatedSchema);
    }

    private void butTypeAddActionPerformed(ActionEvent evt) {
        try {
            String typeName;
            boolean isValidType;
            Object[] typeNames = this.dmd.getDataStore().getTypeNames();
            do {
                if (StringUtils.isBlank((CharSequence)(typeName = JOptionPane.showInputDialog(SwingUtilities.windowForComponent(this), I18N.get("prompt-datatype"), I18N.get("add-datatype"), 3)))) {
                    return;
                }
                boolean bl = isValidType = !ArrayUtils.contains((Object[])typeNames, (Object)typeName);
                if (isValidType) continue;
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), I18N.get("error-datatype-already-used"), I18N.get("common.error"), 0);
            } while (!isValidType);
            typeNames = (String[])ArrayUtils.add((Object[])typeNames, (Object)typeName);
            this.setTypesAndSelect((String[])typeNames, typeName);
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, SwingUtilities.windowForComponent(this));
        }
    }

    private void butTypeDeleteActionPerformed(ActionEvent evt) {
        try {
            String typeToDelete = (String)this.cbTypes.getSelectedItem();
            boolean ok = GUISupport.okcancelbox((Component)SwingUtilities.windowForComponent(this), (String)I18N.getMessage("question-confirm-datatype-deletion", typeToDelete), (String)I18N.get("delete-datatype"));
            if (!ok) {
                return;
            }
            if (this.editorFormat.storeContainsType(this.dmd, typeToDelete)) {
                this.editorFormat.deleteSchema(this.dmd, typeToDelete);
            }
            String[] typeNames = this.dmd.getDataStore().getTypeNames();
            this.setTypesAndSelect(typeNames, null);
            this.editorFormat.deleteLayersReferencingSchema(this.context.getTask(), typeToDelete, this.editorFormat.getFileSystemStoreSource(this.dmd));
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, SwingUtilities.windowForComponent(this));
        }
    }

    private void butTypeCreateLayerActionPerformed(ActionEvent evt) {
        try {
            String typeName = (String)this.cbTypes.getSelectedItem();
            this.editorFormat.addLayerForType(this.context, this.dmd, typeName);
        }
        catch (Exception ex) {
            WorkbenchFrame.handleThrowable(ex, SwingUtilities.windowForComponent(this));
        }
    }

    private class MultiFeatureTypeSelector
    implements FeatureTypeSelector {
        private MultiFeatureTypeSelector() {
        }

        @Override
        public void setType(String typeName) {
            FeatureTypePanel.this.cbTypes.setSelectedItem(typeName);
        }

        @Override
        public void setEditable(boolean b) {
            FeatureTypePanel.this.cbTypes.setEditable(b);
            FeatureTypePanel.this.cbTypes.setEnabled(b);
        }

        @Override
        public JComponent getComponent() {
            return FeatureTypePanel.this.cbTypes;
        }
    }

    private static interface FeatureTypeSelector {
        public void setType(String var1);

        public void setEditable(boolean var1);

        public JComponent getComponent();
    }

    private class SingleFeatureTypeSelector
    implements FeatureTypeSelector {
        private SingleFeatureTypeSelector() {
        }

        @Override
        public void setType(String typeName) {
            FeatureTypePanel.this.txtName.setText(typeName);
        }

        @Override
        public void setEditable(boolean b) {
            FeatureTypePanel.this.txtName.setEditable(b);
        }

        @Override
        public JComponent getComponent() {
            return FeatureTypePanel.this.txtName;
        }
    }
}

