/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.net.URL;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.ObjectUtils;
import org.geotools.data.DataAccessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreTableModel
extends AbstractTableModel {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreTableModel.class);
    private DatastoreMetadata mData;
    private static final String[] arrColnames = new String[2];

    public DatastoreTableModel(DatastoreMetadata _mData) {
        this.mData = _mData;
    }

    public void setDatastoreMetadata(DatastoreMetadata _mData) {
        this.mData = _mData;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.mData.getFactory().getParametersInfo().length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.mData.getFactory().getParametersInfo()[row].key;
        }
        DataAccessFactory.Param param = this.mData.getFactory().getParametersInfo()[row];
        Object obj = this.mData.getParameters().get(param.key);
        if (obj == null) {
            return "";
        }
        return param.text(obj);
    }

    @Override
    public String getColumnName(int column) {
        return arrColnames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column != 1) {
            return;
        }
        DataAccessFactory.Param param = this.mData.getFactory().getParametersInfo()[row];
        String strValue = value.toString();
        if (param.type == URL.class) {
            strValue = this.toURL(strValue);
        }
        if (param.type == String[].class) {
            this.mData.getParameters().put(param.key, strValue.split(","));
            this.mData.reset();
            return;
        }
        if (param.type == Character.class && strValue.length() >= 1) {
            this.mData.getParameters().put(param.key, Character.valueOf(strValue.charAt(0)));
            this.mData.reset();
            return;
        }
        try {
            this.mData.getParameters().put(param.key, param.parse(strValue));
            this.mData.reset();
        }
        catch (Throwable t) {
            LOG.warn(t.getMessage(), t);
        }
    }

    private String toURL(String strURL) {
        if (strURL == null || strURL.isEmpty()) {
            return "";
        }
        if (strURL.startsWith("file:/") || strURL.startsWith("http:/") || strURL.startsWith("https:/") || strURL.startsWith("ftp:/")) {
            return strURL;
        }
        return "file:/" + strURL;
    }

    public boolean isRequired(int row) {
        DataAccessFactory.Param param = this.mData.getFactory().getParametersInfo()[row];
        return param.required;
    }

    public String getDescription(int row) {
        DataAccessFactory.Param param = this.mData.getFactory().getParametersInfo()[row];
        return ObjectUtils.toString((Object)param.description);
    }

    static {
        DatastoreTableModel.arrColnames[0] = I18N.get("de.riwagis.riwajump.DatastorePanel.property-name");
        DatastoreTableModel.arrColnames[1] = I18N.get("de.riwagis.riwajump.DatastorePanel.property-value");
    }
}

