/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.RelativePaths;
import de.riwagis.riwajump.data.gui.DatastoreTableModel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.util.gui.components.TextFieldFileChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DatastoreTable
extends JTable {
    private DatastoreMetadata mData = null;
    DefaultTableCellRenderer colRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected || hasFocus) {
                return comp;
            }
            if (((DatastoreTableModel)table.getModel()).isRequired(row)) {
                comp.setBackground(Color.YELLOW);
            } else {
                comp.setBackground(Color.WHITE);
            }
            return comp;
        }
    };

    public DatastoreTable(DatastoreMetadata _mData) {
        this.mData = _mData;
        this.setModel(new DatastoreTableModel(this.mData));
        TableColumn col1 = this.getColumn(this.getColumnName(0));
        col1.setCellRenderer(this.colRenderer);
        TableColumn col2 = this.getColumn(this.getColumnName(1));
        col2.setCellRenderer(this.colRenderer);
        col2.setCellEditor(new MDataTableCellEditor());
        this.setRowHeight(this.getRowHeight());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int intRow = DatastoreTable.this.getSelectedRow();
                DatastoreTable.this.setRowSelectionInterval(intRow, intRow);
                DatastoreTable.this.setColumnSelectionInterval(1, 1);
                if (e.getClickCount() > 1) {
                    DatastoreTable.this.editCellAt(intRow, 1);
                }
            }
        });
    }

    public void setDatastoreMetadata(DatastoreMetadata _mData) {
        this.mData = _mData;
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        ((DatastoreTableModel)this.getModel()).setDatastoreMetadata(this.mData);
    }

    private class MDataTableCellEditor
    extends DefaultCellEditor {
        private static final int DATATYPE_SUPER = 1;
        private static final int DATATYPE_SHAPE_FILEPATH = 2;
        private static final int DATATYPE_SHAPE_CHARSET = 3;
        private static final int DATATYPE_GEOPACKAGE_FILENAME = 4;
        private static final int DATATYPE_RIWADATATABLE_DBTYPE = 4;
        private static final int DATATYPE_RIWADATATABLE_DBPORT = 5;
        private static final int DATATYPE_CSV_FILENAME = 6;
        private static final String DATANAME_SHAPE__DIRECTORY = "Shape Directory";
        private static final String DATANAME_GEOPACKAGE = "GeoPackage";
        private static final String DATANAME_RIWA_DATA_TABLE = "RiwaDataTable";
        private static final String DATANAME_CSV = "CSV";
        private int datatype;
        private final TextFieldFileChooser tfDirChooser;
        private final TextFieldFileChooser tfFileChooser;
        private final JComboBox<String> cbCharset;
        private final JComboBox<String> cbDbType;
        private final String[] dbPorts;
        private final JComboBox<String> cbDbPort;

        public MDataTableCellEditor() {
            super(new JTextField());
            this.datatype = 1;
            this.tfDirChooser = new TextFieldFileChooser();
            this.tfFileChooser = new TextFieldFileChooser();
            this.cbCharset = new JComboBox<String>(new String[]{"ISO-8859-1", "cp850", "UTF-8"});
            this.cbDbType = new JComboBox<String>(new String[]{"DB_MySQL", "DB_Postgres", "DB_Oracle", "DB_MariaDB", "DB_MSSQLServer"});
            this.dbPorts = new String[]{"3306 (MySQL, MariaDB)", "5432 (Postgres)", "1521 (Oracle)", "1433 (MSSQLServer)"};
            this.cbDbPort = new JComboBox<String>(this.dbPorts);
            this.tfDirChooser.onlyDirectories(true);
            this.tfDirChooser.setMode(0);
            this.tfDirChooser.displayChoose(false);
            this.tfFileChooser.onlyDirectories(false);
            this.tfFileChooser.setMode(0);
            this.tfFileChooser.displayChoose(false);
            this.cbCharset.setEditable(true);
            this.cbCharset.addItemListener(evt -> {
                if (evt.getStateChange() == 1) {
                    Object obj = evt.getItem();
                    try {
                        if (obj != null) {
                            Charset.forName(ObjectUtils.toString((Object)obj));
                        }
                    }
                    catch (UnsupportedCharsetException e) {
                        JOptionPane.showMessageDialog(null, I18N.get("ui.plugin.shapefile.LoadShapefilePlugIn.error-encoding-unsupported") + " " + String.valueOf(obj), I18N.get("common.error"), 0);
                    }
                }
            });
            this.cbDbType.setEditable(true);
            this.cbDbPort.setEditable(true);
            this.setClickCountToStart(1);
        }

        @Override
        public Object getCellEditorValue() {
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_SHAPE__DIRECTORY)) {
                if (this.datatype == 2) {
                    return RelativePaths.normalize(this.tfDirChooser.getAbsolutePath());
                }
                if (this.datatype == 3) {
                    return this.cbCharset.getSelectedItem();
                }
            }
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_GEOPACKAGE) && this.datatype == 4) {
                return RelativePaths.normalize(this.tfFileChooser.getAbsolutePath());
            }
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_RIWA_DATA_TABLE)) {
                if (this.datatype == 4) {
                    return this.cbDbType.getSelectedItem();
                }
                if (this.datatype == 5) {
                    Object editorItem = this.cbDbPort.getEditor().getItem();
                    if (this.cbDbPort.getEditor().getItem() != null) {
                        int itemIndex = ArrayUtils.indexOf((Object[])this.dbPorts, (Object)editorItem);
                        switch (itemIndex) {
                            case 0: {
                                return 3306;
                            }
                            case 1: {
                                return 5432;
                            }
                            case 2: {
                                return 1521;
                            }
                            case 3: {
                                return 1433;
                            }
                        }
                        try {
                            return Integer.parseInt(editorItem.toString());
                        }
                        catch (NumberFormatException nfe) {
                            return 0;
                        }
                    }
                    return 0;
                }
            }
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_CSV) && this.datatype == 6) {
                return RelativePaths.normalize(this.tfFileChooser.getAbsolutePath());
            }
            return super.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_SHAPE__DIRECTORY)) {
                if (row == 0 && column == 1) {
                    this.datatype = 2;
                    this.tfDirChooser.setAbsolutePath(value.toString());
                    return this.tfDirChooser;
                }
                if (row == 1 && column == 1) {
                    this.datatype = 3;
                    this.cbCharset.setSelectedItem(ObjectUtils.toString((Object)value));
                    return this.cbCharset;
                }
            }
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_CSV) && row == 0 && column == 1) {
                this.datatype = 6;
                this.tfFileChooser.setAbsolutePath(value.toString());
                this.tfFileChooser.setFileTypes(new String[]{"csv"});
                return this.tfFileChooser;
            }
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_GEOPACKAGE) && row == 0 && column == 1) {
                this.datatype = 4;
                this.tfFileChooser.setAbsolutePath(value.toString());
                this.tfFileChooser.setFileTypes(new String[]{"gpkg"});
                return this.tfFileChooser;
            }
            if (DatastoreTable.this.mData.getDataName().equals(DATANAME_RIWA_DATA_TABLE)) {
                if (row == 0 && column == 1) {
                    this.datatype = 4;
                    this.cbDbType.setSelectedItem(ObjectUtils.toString((Object)value));
                    return this.cbDbType;
                }
                if (row == 2 && column == 1) {
                    this.datatype = 5;
                    switch (ObjectUtils.toString((Object)value)) {
                        case "3306": {
                            this.cbDbPort.setSelectedIndex(0);
                            break;
                        }
                        case "5432": {
                            this.cbDbPort.setSelectedIndex(1);
                            break;
                        }
                        case "1521": {
                            this.cbDbPort.setSelectedIndex(2);
                            break;
                        }
                        case "1433": {
                            this.cbDbPort.setSelectedIndex(3);
                            break;
                        }
                        default: {
                            this.cbDbPort.getEditor().setItem(ObjectUtils.toString((Object)value));
                        }
                    }
                    return this.cbDbPort;
                }
            }
            this.datatype = 1;
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ((JTextField)comp).selectAll();
            SwingUtilities.invokeLater(() -> {
                if (comp instanceof JTextField) {
                    ((JTextField)comp).setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                }
            });
            return comp;
        }
    }
}

