/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.data.gui.DatastoreTable;
import de.riwagis.riwajump.data.gui.DatastoreTableModel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastorePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(DatastorePanel.class);
    private boolean blockEvents = false;
    private DatastoreMetadata mData = null;
    private JButton butTestConn;
    private JComboBox cboType;
    private JLabel lblDesc;
    private JLabel lblDescText;
    private JLabel lblName;
    private JLabel lblProperties;
    private JLabel lblType;
    private JScrollPane scrPaneProperties;
    private JTable tblProperties;
    private JTextField txtName;

    public DatastorePanel(DatastoreMetadata _mData) {
        this.mData = _mData;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.lblName.setText(I18N.get("de.riwagis.riwajump.DatastorePanel.name"));
        this.lblProperties.setText(I18N.get("de.riwagis.riwajump.DatastorePanel.properties"));
        this.lblType.setText(I18N.get("de.riwagis.riwajump.DatastorePanel.datatype"));
        this.lblDesc.setText(I18N.get("de.riwagis.riwajump.DatastorePanel.property-desc"));
        this.lblDescText.setText("  ");
        this.butTestConn.setText(I18N.get("de.riwagis.riwajump.DatastorePanel.test-connection"));
    }

    private void init() {
        this.blockEvents = true;
        try {
            this.cboType.removeAllItems();
            DatastoreMetadata.getFactories().stream().forEach(fac -> this.cboType.addItem(fac.getDisplayName()));
        }
        finally {
            this.blockEvents = false;
        }
        this.setMetaData(this.mData);
    }

    public void setMetaData(DatastoreMetadata _mData) {
        this.mData = _mData;
        this.blockEvents = true;
        try {
            this.stopEditing();
            this.txtName.setText(this.mData.getName());
            if (this.mData.getFactory() != null) {
                this.cboType.setSelectedItem(this.mData.getFactory().getDisplayName());
                ((DatastoreTable)this.tblProperties).setDatastoreMetadata(this.mData);
            } else {
                LOG.error(this.mData.getDataName() + " - Datastorefactory not found.");
            }
            this.updateDescription();
        }
        finally {
            this.blockEvents = false;
        }
    }

    public void stopEditing() {
        if (this.tblProperties.getCellEditor() != null) {
            this.tblProperties.getCellEditor().stopCellEditing();
        }
    }

    private void updateDescription() {
        int row = this.tblProperties.getSelectedRow();
        if (row > -1) {
            this.lblDescText.setText("<html>" + ((DatastoreTableModel)this.tblProperties.getModel()).getDescription(row) + "</html>");
        } else {
            this.lblDescText.setText("  ");
        }
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.cboType = new JComboBox();
        this.lblProperties = new JLabel();
        this.scrPaneProperties = new JScrollPane();
        this.tblProperties = new DatastoreTable(this.mData);
        this.lblDesc = new JLabel();
        this.lblDescText = new JLabel();
        this.butTestConn = new JButton();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblType.setText("Datentyp:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.lblType, gridBagConstraints);
        this.cboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastorePanel.this.cboType_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.cboType, gridBagConstraints);
        this.lblProperties.setText("Eigenschaften:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.lblProperties, gridBagConstraints);
        this.tblProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DatastorePanel.this.tblProperties_onMouseClicked(evt);
            }
        });
        this.tblProperties.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DatastorePanel.this.tblProperties_onKeyReleased(evt);
            }
        });
        this.scrPaneProperties.setViewportView(this.tblProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.scrPaneProperties, gridBagConstraints);
        this.lblDesc.setText("Parameterbeschreibung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 9, 6, 9);
        this.add((Component)this.lblDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.add((Component)this.lblDescText, gridBagConstraints);
        this.butTestConn.setText("Verbindung testen");
        this.butTestConn.setMinimumSize(new Dimension(140, 23));
        this.butTestConn.setPreferredSize(new Dimension(140, 23));
        this.butTestConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastorePanel.this.butTestConn_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.butTestConn, gridBagConstraints);
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.lblName, gridBagConstraints);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DatastorePanel.this.txtName_onKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                DatastorePanel.this.txtName_onKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.txtName, gridBagConstraints);
    }

    private void butTestConn_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.stopEditing();
        String strError = this.mData.testConnection();
        JOptionPane optMessage = new JOptionPane();
        if (strError == null) {
            JOptionPane.showMessageDialog(this, I18N.get("de.riwagis.riwajump.DatastorePanel.test-succeeded"));
        } else {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
        }
    }

    private void tblProperties_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateDescription();
    }

    private void tblProperties_onMouseClicked(MouseEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.updateDescription();
    }

    private void txtName_onKeyReleased(KeyEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.mData.setName(this.txtName.getText());
    }

    private void cboType_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.stopEditing();
        if (this.cboType.getSelectedItem().equals(this.mData.getDataName())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int option = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(DatastorePanel.this), I18N.get("de.riwagis.riwajump.DatastorePanel.change-datatype"), I18N.get("common.message"), 0);
                if (option == 0) {
                    DatastorePanel.this.mData.setDataName((String)DatastorePanel.this.cboType.getSelectedItem());
                    DatastorePanel.this.setMetaData(DatastorePanel.this.mData);
                } else {
                    DatastorePanel.this.cboType.setSelectedItem(DatastorePanel.this.mData.getDataName());
                }
            }
        });
    }

    private void txtName_onKeyTyped(KeyEvent evt) {
    }
}

