/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.data.gui.DatastoreDialog;
import de.riwagis.riwajump.data.gui.DatastoreListModel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DatastoreListPanel
extends JPanel {
    private DMDCollection dmdCol = new DMDCollection();
    private DatastoreListModel listModel = null;
    private DatastoreDialog dlg = null;
    private String editName = "";
    private JButton butAdd;
    private JButton butDelete;
    private JButton butEdit;
    private JLabel lblDatastores;
    private JList<DatastoreMetadata> lstDatastores;
    private JPanel pnlBut;
    private JScrollPane scrDatastores;

    public DatastoreListPanel() {
        this.initComponents();
        this.i18n();
        this.listModel = new DatastoreListModel(this.dmdCol);
        this.lstDatastores.setModel(this.listModel);
    }

    private void i18n() {
        this.lblDatastores.setText(I18N.get("de.riwagis.riwajump.DatastoreListPanel.datastores"));
        this.butAdd.setText(I18N.get("common.new"));
        this.butEdit.setText(I18N.get("common.change"));
        this.butDelete.setText(I18N.get("common.delete"));
    }

    public void setDMDCollection(DMDCollection _dmdCol) {
        this.dmdCol = _dmdCol;
        this.listModel.setDMDCollection(this.dmdCol);
    }

    public DatastoreDialog getDialog(int _intMode, DatastoreMetadata _mData) {
        if (this.dlg == null) {
            Window parent = SwingUtilities.windowForComponent(this);
            if (parent instanceof Frame) {
                this.dlg = new DatastoreDialog((Frame)parent, true, _intMode, _mData);
            }
            if (parent instanceof Dialog) {
                this.dlg = new DatastoreDialog((Dialog)parent, true, _intMode, _mData);
            }
            Validator validator = new Validator(){

                @Override
                public String check(Object obj) {
                    try {
                        int count = 0;
                        DatastoreMetadata dmData = (DatastoreMetadata)obj;
                        for (DatastoreMetadata tmpData : DatastoreListPanel.this.dmdCol) {
                            if (!tmpData.getName().equals(dmData.getName())) continue;
                            ++count;
                        }
                        if (0 == DatastoreListPanel.this.dlg.getMode() && count > 0) {
                            return "\"" + dmData.getName() + "\". " + I18N.get("de.riwagis.riwajump.DatastoreListPanel.duplicate-name");
                        }
                        if (1 == DatastoreListPanel.this.dlg.getMode() && count > 0 && !DatastoreListPanel.this.editName.equals(dmData.getName())) {
                            return "\"" + dmData.getName() + "\". " + I18N.get("de.riwagis.riwajump.DatastoreListPanel.duplicate-name");
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return I18N.get("common.error") + " in check: " + e.getMessage();
                    }
                }
            };
            this.dlg.addValidator(validator);
            this.dlg.setLocationRelativeTo(this);
            return this.dlg;
        }
        this.dlg.setMode(_intMode);
        this.dlg.setMetaData(_mData);
        return this.dlg;
    }

    private void initComponents() {
        this.lblDatastores = new JLabel();
        this.scrDatastores = new JScrollPane();
        this.lstDatastores = new JList();
        this.pnlBut = new JPanel();
        this.butAdd = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblDatastores.setText("Datenquellen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.lblDatastores, gridBagConstraints);
        this.scrDatastores.setMinimumSize(new Dimension(150, 200));
        this.scrDatastores.setPreferredSize(new Dimension(150, 200));
        this.lstDatastores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DatastoreListPanel.this.lstDatastores_onMouseClicked(evt);
            }
        });
        this.scrDatastores.setViewportView(this.lstDatastores);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.add((Component)this.scrDatastores, gridBagConstraints);
        this.pnlBut.setLayout(new GridLayout(3, 1, 3, 4));
        this.butAdd.setText("neu");
        this.butAdd.setMinimumSize(new Dimension(80, 23));
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreListPanel.this.butAdd_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butAdd);
        this.butEdit.setText("\u00e4ndern");
        this.butEdit.setMinimumSize(new Dimension(80, 23));
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreListPanel.this.butEdit_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butEdit);
        this.butDelete.setText("l\u00f6schen");
        this.butDelete.setMinimumSize(new Dimension(80, 23));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreListPanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.pnlBut.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.add((Component)this.pnlBut, gridBagConstraints);
    }

    private void lstDatastores_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butEdit_onActionPerformed(null);
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        List<DatastoreMetadata> selectedValues = this.lstDatastores.getSelectedValuesList();
        if (selectedValues.size() != 1) {
            return;
        }
        DatastoreMetadata oldMData = this.lstDatastores.getSelectedValue();
        DatastoreMetadata newMData = oldMData.cloneDMD();
        this.editName = oldMData.getName();
        this.dlg = this.getDialog(1, newMData);
        this.dlg.setVisible(true);
        if (this.dlg.wasOKPressed()) {
            this.listModel.replaceDatastore(oldMData, newMData);
            this.lstDatastores.setSelectedValue(newMData, true);
        }
    }

    private void butAdd_onActionPerformed(ActionEvent evt) {
        DatastoreMetadata mData = new DatastoreMetadata("new");
        this.dlg = this.getDialog(0, mData);
        this.dlg.setVisible(true);
        if (this.dlg.wasOKPressed()) {
            this.listModel.addDatastore(mData);
            this.lstDatastores.setSelectedValue(mData, true);
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        List<DatastoreMetadata> selectedValues = this.lstDatastores.getSelectedValuesList();
        if (selectedValues.isEmpty()) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(this, I18N.get("de.riwagis.riwajump.DatastoreListPanel.delete-question"), I18N.get("common.message"), 0);
        if (option == 0) {
            for (DatastoreMetadata currDMD : selectedValues) {
                this.listModel.removeDatastore(currDMD);
            }
        }
    }
}

