/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import javax.swing.AbstractListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreListModel
extends AbstractListModel<DatastoreMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreListModel.class);
    private DMDCollection dmdCol = null;

    public DatastoreListModel(DMDCollection _dmdCol) {
        this.setDMDCollection(_dmdCol);
    }

    @Override
    public DatastoreMetadata getElementAt(int index) {
        return this.dmdCol.getInternalList().get(index);
    }

    @Override
    public int getSize() {
        return this.dmdCol.getInternalList().size();
    }

    public void setDMDCollection(DMDCollection _dmdCol) {
        this.dmdCol = _dmdCol;
        for (DatastoreMetadata dmd : this.dmdCol.getInternalList()) {
            dmd.adjustDataStoreParams();
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void addDatastore(DatastoreMetadata dataMeta) {
        int index = this.dmdCol.addDatastore(dataMeta);
        this.fireIntervalAdded(this, index, index);
    }

    public void replaceDatastore(DatastoreMetadata oldMeta, DatastoreMetadata newMeta) {
        this.dmdCol.replaceDatastore(oldMeta, newMeta);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void removeDatastore(DatastoreMetadata dataMeta) {
        int index = this.dmdCol.removeDatastore(dataMeta);
        if (index != -1) {
            this.fireIntervalRemoved(this, index, index);
        }
    }
}

