/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.data.gui.DatastoreListPanel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreListDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreListDialog.class);
    private DMDCollection dmdOri = null;
    private DMDCollection dmdClone = null;
    private final List<Validator> lstValidator = new ArrayList<Validator>();
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private DatastoreListPanel pnlDatastoreList;
    private JPanel pnlOKCancel;

    public DatastoreListDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        this.i18n();
    }

    public DatastoreListDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
        this.setTitle(I18N.get("de.riwagis.riwajump.DatastoreListDialog.title"));
    }

    public void setDMDCollection(DMDCollection _dmdCol) {
        this.dmdOri = _dmdCol;
        this.dmdClone = new DMDCollection(this.dmdOri.getTask(), this.dmdOri.getCloneList());
        this.pnlDatastoreList.setDMDCollection(this.dmdClone);
    }

    public DatastoreListPanel getPanel() {
        return this.pnlDatastoreList;
    }

    public void addValidator(Validator val) {
        if (!this.lstValidator.contains(val)) {
            this.lstValidator.add(val);
        }
    }

    public void removeValidator(Validator val) {
        if (this.lstValidator.contains(val)) {
            this.lstValidator.remove(val);
        }
    }

    public void clearValidators() {
        this.lstValidator.clear();
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    private void initComponents() {
        this.pnlDatastoreList = new DatastoreListPanel();
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlDatastoreList, gridBagConstraints);
        this.pnlOKCancel.setLayout(new GridBagLayout());
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreListDialog.this.butOK_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlOKCancel.add((Component)this.butOK, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreListDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlOKCancel.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        for (Validator val : this.lstValidator) {
            String strError = val.check(this.dmdClone);
            if (strError == null) continue;
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
            return;
        }
        this.dmdOri.getInternalList().clear();
        Iterator<Object> i = this.dmdClone.iterator();
        while (i.hasNext()) {
            this.dmdOri.getInternalList().add((DatastoreMetadata)i.next());
        }
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DatastoreListDialog dlg = new DatastoreListDialog(new Frame(), true);
                ArrayList<DatastoreMetadata> lstTest = new ArrayList<DatastoreMetadata>();
                lstTest.add(new DatastoreMetadata("abc"));
                lstTest.add(new DatastoreMetadata("neu"));
                DMDCollection dmdCol = new DMDCollection(null, lstTest);
                dlg.setDMDCollection(dmdCol);
                dlg.setVisible(true);
                if (LOG.isDebugEnabled()) {
                    for (DatastoreMetadata dmd : lstTest) {
                        LOG.debug(dmd.toString());
                    }
                }
            }
        });
    }
}

