/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.data.shapefile.ShapefileDataStoreFactory;
import de.riwagis.guitools.Validator;
import de.riwagis.riwajump.data.gui.DatastorePanel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.commons.lang3.ObjectUtils;

public class DatastoreDialog
extends JDialog {
    private List<Validator> lstValidator = new ArrayList<Validator>();
    public static final int MODE_ADD = 0;
    public static final int MODE_EDIT = 1;
    private int intMode = 0;
    private DatastoreMetadata oriDMD = null;
    private DatastoreMetadata cloneDMD = null;
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private JPanel pnlDatastore;
    private JPanel pnlOKCancel;

    public DatastoreDialog(Dialog owner, boolean modal, int _intMode, DatastoreMetadata _mData) {
        super(owner, modal);
        this.init(_intMode, _mData);
    }

    public DatastoreDialog(Frame owner, boolean modal, int _intMode, DatastoreMetadata _mData) {
        super(owner, modal);
        this.init(_intMode, _mData);
    }

    private void init(int _intMode, DatastoreMetadata _mData) {
        this.oriDMD = _mData;
        this.cloneDMD = _mData.cloneDMD();
        this.setMode(_intMode);
        this.initComponents();
        this.i18n();
        this.setSize(400, 690);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DatastoreDialog.this.handleCancelAction();
            }
        });
        this.addValidator(obj -> {
            DatastoreMetadata dmd;
            if (obj instanceof DatastoreMetadata && (dmd = (DatastoreMetadata)obj).getDataName().equals("Shape Directory")) {
                Object ser = dmd.getParameters().get(ShapefileDataStoreFactory.DBFCHARSET.key);
                try {
                    if (ser != null) {
                        Charset.forName(ObjectUtils.toString((Object)ser));
                    }
                }
                catch (UnsupportedCharsetException e) {
                    return I18N.get("ui.plugin.shapefile.LoadShapefilePlugIn.error-encoding-unsupported") + " " + String.valueOf(ser);
                }
            }
            return null;
        });
    }

    public void setMetaData(DatastoreMetadata _mData) {
        this.oriDMD = _mData;
        this.cloneDMD = _mData.cloneDMD();
        ((DatastorePanel)this.pnlDatastore).setMetaData(this.cloneDMD);
    }

    public void addValidator(Validator val) {
        if (!this.lstValidator.contains(val)) {
            this.lstValidator.add(val);
        }
    }

    public void removeValidator(Validator val) {
        if (this.lstValidator.contains(val)) {
            this.lstValidator.remove(val);
        }
    }

    public void clearValidators() {
        this.lstValidator.clear();
    }

    private void i18n() {
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public void setMode(int _intMode) {
        this.intMode = _intMode;
        if (this.intMode != 0 && this.intMode != 1) {
            this.intMode = 0;
        }
        if (this.intMode == 1) {
            this.setTitle(I18N.get("de.riwagis.riwajump.DatastoreDialog.edit-title"));
        } else {
            this.setTitle(I18N.get("de.riwagis.riwajump.DatastoreDialog.add-title"));
        }
    }

    public int getMode() {
        return this.intMode;
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    private void initComponents() {
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlDatastore = new DatastorePanel(this.cloneDMD);
        this.setCursor(new Cursor(0));
        this.setMinimumSize(new Dimension(247, 575));
        this.setName("dlgDatastore");
        this.setPreferredSize(new Dimension(247, 575));
        this.getContentPane().setLayout(new GridBagLayout());
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatastoreDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butCancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlDatastore, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.handleCancelAction();
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        ((DatastorePanel)this.pnlDatastore).stopEditing();
        for (Validator val : this.lstValidator) {
            String strError = val.check(this.cloneDMD);
            if (strError == null) continue;
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + strError);
            return;
        }
        this.oriDMD.takeProperties(this.cloneDMD);
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    private void handleCancelAction() {
        ((DatastorePanel)this.pnlDatastore).stopEditing();
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(() -> {
            DatastoreDialog dlg = new DatastoreDialog((Dialog)new JDialog(), true, 0, new DatastoreMetadata("new"));
            dlg.setVisible(true);
        });
    }
}

