/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public enum AttributeTypes {
    STRING(I18N.get("de.riwagis.riwajump.FeatureTypeTable.string"), String.class),
    BYTE(I18N.get("de.riwagis.riwajump.FeatureTypeTable.byte"), Byte.class),
    SHORT(I18N.get("de.riwagis.riwajump.FeatureTypeTable.short"), Short.class),
    INTEGER(I18N.get("de.riwagis.riwajump.FeatureTypeTable.integer"), Integer.class),
    LONG(I18N.get("de.riwagis.riwajump.FeatureTypeTable.long"), Long.class),
    FLOAT(I18N.get("de.riwagis.riwajump.FeatureTypeTable.float"), Float.class),
    DOUBLE(I18N.get("de.riwagis.riwajump.FeatureTypeTable.double"), Double.class),
    DATE(I18N.get("de.riwagis.riwajump.FeatureTypeTable.date"), Date.class),
    TIMESTAMP(I18N.get("de.riwagis.riwajump.FeatureTypeTable.timestamp"), Timestamp.class),
    BOOLEAN(I18N.get("de.riwagis.riwajump.FeatureTypeTable.boolean"), Boolean.class),
    BLOB(I18N.get("de.riwagis.riwajump.FeatureTypeTable.blob"), byte[].class),
    POINT(I18N.get("de.riwagis.riwajump.FeatureTypeTable.point"), Point.class),
    LINESTRING(I18N.get("de.riwagis.riwajump.FeatureTypeTable.linestring"), LineString.class),
    POLYGON(I18N.get("de.riwagis.riwajump.FeatureTypeTable.polygon"), Polygon.class),
    MULTI_POINT(I18N.get("de.riwagis.riwajump.FeatureTypeTable.multi-point"), MultiPoint.class),
    MULTI_LINESTRING(I18N.get("de.riwagis.riwajump.FeatureTypeTable.multi-linestring"), MultiLineString.class),
    MULTI_POLYGON(I18N.get("de.riwagis.riwajump.FeatureTypeTable.multi-polygon"), MultiPolygon.class),
    GEOMETRY_COLLECTION(I18N.get("de.riwagis.riwajump.FeatureTypeTable.geometry-collection"), GeometryCollection.class),
    GEOMETRY(I18N.get("de.riwagis.riwajump.FeatureTypeTable.geometry"), Geometry.class),
    NO_GEOMETRY(I18N.get("de.riwagis.riwajump.FeatureTypeTable.no-geometry"), NoGeometry.class),
    UNKNOWN(I18N.get("de.riwagis.riwajump.FeatureTypeTable.unknown"), Unknown.class);

    private final Class<?> binding;
    private final String name;
    private static final List<AttributeTypes> ATTRIBUTES_ALL;
    private static final List<AttributeTypes> ATTRIBUTES_KNOWN;
    private static final List<AttributeTypes> ATTRIBUTES_GEOMETRIC;
    private static final List<AttributeTypes> ATTRIBUTES_NONGEOMETRIC;
    private static final Map<Class<?>, AttributeTypes> TYPE_TO_ATTRIBUTE;

    private AttributeTypes(String name, Class<?> binding) {
        this.binding = binding;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public String toString() {
        return this.name;
    }

    public boolean isGeometric() {
        return Geometry.class.isAssignableFrom(this.binding);
    }

    public static Collection<AttributeTypes> getAttributes() {
        return ATTRIBUTES_ALL;
    }

    public static Collection<AttributeTypes> getNonGeometricAttributes() {
        return ATTRIBUTES_NONGEOMETRIC;
    }

    public static Collection<AttributeTypes> getGeometricAttributes() {
        return ATTRIBUTES_GEOMETRIC;
    }

    public static AttributeTypes getAttributeTypeForClass(Class<?> binding) {
        AttributeTypes type = TYPE_TO_ATTRIBUTE.get(binding);
        if (type != null) {
            return type;
        }
        for (AttributeTypes ats : ATTRIBUTES_ALL) {
            if (!ats.binding.isAssignableFrom(binding)) continue;
            return ats;
        }
        return UNKNOWN;
    }

    static {
        ATTRIBUTES_ALL = List.of(AttributeTypes.values());
        ATTRIBUTES_KNOWN = ATTRIBUTES_ALL.subList(0, ATTRIBUTES_ALL.size() - 1);
        ATTRIBUTES_GEOMETRIC = ATTRIBUTES_KNOWN.stream().filter(x -> x.isGeometric()).toList();
        ATTRIBUTES_NONGEOMETRIC = ATTRIBUTES_KNOWN.stream().filter(x -> !x.isGeometric()).toList();
        TYPE_TO_ATTRIBUTE = Arrays.stream(AttributeTypes.values()).collect(Collectors.toMap(x -> x.getBinding(), x -> x));
    }

    public static abstract class NoGeometry
    extends Geometry {
        private NoGeometry(GeometryFactory factory) {
            super(factory);
        }
    }

    public static abstract class Unknown {
    }
}

