/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import de.riwagis.riwajump.data.gui.AttributeCategories;
import de.riwagis.riwajump.data.gui.AttributeTypes;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AttributeTypeComboBox
extends JComboBox<AttributeTypes> {
    private final Collection<AttributeTypes> setRestrictions = EnumSet.noneOf(AttributeTypes.class);

    public AttributeTypeComboBox(AttributeCategories mode) {
        DefaultComboBoxModel<AttributeTypes> model = new DefaultComboBoxModel<AttributeTypes>();
        Collection<AttributeTypes> types = null;
        switch (mode) {
            case NONGEOMETRIC: {
                types = AttributeTypes.getNonGeometricAttributes();
                break;
            }
            case GEOMETRIC: {
                types = AttributeTypes.getGeometricAttributes();
                break;
            }
            default: {
                types = AttributeTypes.getAttributes();
            }
        }
        for (AttributeTypes at : types) {
            model.addElement(at);
        }
        super.setModel(model);
        super.setEditable(false);
    }

    public AttributeType getAttributeType() throws Exception {
        return this.getAttributeType(WorkbenchContext.getTask().getCRSDefinition().getCRS());
    }

    public AttributeType getAttributeType(CoordinateReferenceSystem crs) throws Exception {
        AttributeTypes ats = (AttributeTypes)((Object)this.getSelectedItem());
        if (AttributeTypes.NoGeometry.class.equals(ats.getBinding())) {
            return null;
        }
        AttributeTypeBuilder attBuilder = new AttributeTypeBuilder();
        attBuilder.setName(ats.getName());
        attBuilder.setBinding(ats.getBinding());
        if (ats.isGeometric()) {
            attBuilder.setCRS(crs);
            return attBuilder.buildGeometryType();
        }
        return attBuilder.buildType();
    }

    public void setAttributeType(AttributeType attributeType) {
        super.setSelectedItem((Object)AttributeTypes.getAttributeTypeForClass(attributeType.getBinding()));
    }

    public void setAttributeType(AttributeTypes attributeType) {
        super.setSelectedItem((Object)attributeType);
    }

    public void addTypeRestriction(AttributeTypes clazz) {
        if (!this.setRestrictions.contains((Object)clazz)) {
            this.setRestrictions.add(clazz);
            ((DefaultComboBoxModel)this.getModel()).removeElement((Object)clazz);
        }
    }
}

