/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.riwajump.model.attribute.AttributeProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

class AttributePropertiesTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{I18N.get("ui.style.AttributePanel.attributes"), I18N.get("alias"), I18N.get("org.math.plot.components.DefaultDataPanel.visible")};
    private final List<AttributeProperty> attributeProperties;

    public AttributePropertiesTableModel(List<AttributeProperty> attributeProperties) {
        this.attributeProperties = attributeProperties;
    }

    @Override
    public int getRowCount() {
        return this.attributeProperties.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttributeProperty prop = this.attributeProperties.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return prop.getName();
            }
            case 1: {
                return prop.getAlias();
            }
            case 2: {
                return prop.isVisible();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        AttributeProperty prop = this.attributeProperties.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                prop.setName(aValue.toString());
                break;
            }
            case 1: {
                prop.setAlias(aValue.toString());
                break;
            }
            case 2: {
                if (!(aValue instanceof Boolean)) break;
                Boolean value = (Boolean)aValue;
                prop.setVisible(value.booleanValue());
            }
        }
        this.fireTableRowsUpdated(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public void removeRowsByAttributeName(Set<String> rowsToRemove) {
        for (String attributeName : rowsToRemove) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getValueAt(i, 0).equals(attributeName)) continue;
                this.removeRow(i);
            }
        }
    }

    public void insertRows(Set<String> rowsToAdd) {
        for (String attributeName : rowsToAdd) {
            AttributeProperty property = new AttributeProperty();
            property.setName(attributeName);
            property.setVisible(true);
            this.insertRow(property);
        }
    }

    private void removeRow(int row) {
        this.attributeProperties.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    private void insertRow(AttributeProperty property) {
        this.attributeProperties.add(property);
        this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
    }

    public int moveRow(int fromIndex, int toIndex) {
        int index2Add;
        int last;
        int first;
        AttributeProperty property = this.attributeProperties.get(fromIndex);
        int shift = toIndex - fromIndex;
        if (shift < 0) {
            first = toIndex;
            last = fromIndex;
            index2Add = toIndex;
        } else {
            first = fromIndex;
            last = toIndex--;
            index2Add = toIndex;
        }
        this.attributeProperties.remove(fromIndex);
        this.attributeProperties.add(index2Add, property);
        this.fireTableRowsUpdated(first, last);
        return index2Add;
    }

    public void sortByAttribute() {
        this.sortWithComparator(Comparator.comparing(AttributeProperty::getName, String.CASE_INSENSITIVE_ORDER));
    }

    public void sortByAlias() {
        Comparator<AttributeProperty> comparator = Comparator.comparing(property -> property.getAlias(), Comparator.comparing(String::isEmpty).thenComparing(String.CASE_INSENSITIVE_ORDER));
        this.sortWithComparator(comparator);
    }

    public void sortByFmdData(String[] fmdData) {
        HashMap<String, Integer> positionMap = new HashMap<String, Integer>();
        for (int i = 0; i < fmdData.length; ++i) {
            positionMap.put(fmdData[i], i);
        }
        Comparator comp = (prop1, prop2) -> {
            Integer posProp1 = (Integer)positionMap.get(prop1.getName());
            Integer posProp2 = (Integer)positionMap.get(prop2.getName());
            if (posProp1 != null && posProp2 != null) {
                return posProp1.compareTo(posProp2);
            }
            if (posProp1 != null) {
                return -1;
            }
            if (posProp2 != null) {
                return 1;
            }
            return 0;
        };
        this.sortWithComparator(comp);
    }

    private void sortWithComparator(Comparator comp) {
        ArrayList<AttributeProperty> sortedList = new ArrayList<AttributeProperty>(this.attributeProperties);
        sortedList.sort(comp);
        if (Objects.equals(sortedList, this.attributeProperties)) {
            sortedList.sort(comp.reversed());
        }
        this.replacePropertiesWithNewList(sortedList);
    }

    private void replacePropertiesWithNewList(List<AttributeProperty> newProperties) {
        this.attributeProperties.clear();
        this.attributeProperties.addAll(newProperties);
        this.fireTableDataChanged();
    }
}

