/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.gui.AttributePropertiesTableModel;
import de.riwagis.riwajump.data.model.AttributePropertiesService;
import de.riwagis.riwajump.model.attribute.AttributeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributePropertiesPanel
extends JPanel
implements LayerStylePanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributePropertiesPanel.class);
    private Layer layer;
    private AttributeTableModel attrPropOri;
    private AttributeTableModel attrPropClone;
    private FeatureRetriever featureRetriever;
    private JButton butSort;
    private JLabel lblContent;
    private JPopupMenu popupSort;
    private JScrollPane scpAttributeProperties;
    private JTable tblAttributeProperties;

    public AttributePropertiesPanel(Layerable layer) {
        this.layer = (Layer)layer;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tblAttributeProperties.setModel(new AttributePropertiesTableModel(this.layer.getAttributeTable().getAttributeProperties()));
        this.tblAttributeProperties.setSelectionMode(0);
        this.tblAttributeProperties.getColumnModel().getColumn(2).setCellRenderer(new CheckBoxRenderer());
        this.tblAttributeProperties.getColumnModel().getColumn(2).setMaxWidth(80);
        this.tblAttributeProperties.setDragEnabled(true);
        this.tblAttributeProperties.setDropMode(DropMode.INSERT_ROWS);
        this.tblAttributeProperties.setTransferHandler(new TableRowTransferHandler(this.tblAttributeProperties));
        this.initSortMenu();
    }

    private void updateTableModel(String[] attributes) {
        HashSet<String> currentAttributes = new HashSet<String>();
        AttributePropertiesTableModel tableModel = (AttributePropertiesTableModel)this.tblAttributeProperties.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String attributeName = String.valueOf(tableModel.getValueAt(i, 0));
            currentAttributes.add(attributeName);
        }
        Set<String> attributes2Add = AttributePropertiesService.computeAttributesToAdd(currentAttributes, attributes);
        Set<String> attributes2Delete = AttributePropertiesService.computeAttributesToDelete(currentAttributes, attributes);
        tableModel.removeRowsByAttributeName(attributes2Delete);
        tableModel.insertRows(attributes2Add);
    }

    public void stopEditing() {
        if (this.tblAttributeProperties.getCellEditor() != null) {
            this.tblAttributeProperties.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("table-view");
    }

    @Override
    public void setLayerable(Layerable layerable) {
        this.layer = (Layer)layerable;
        this.tblAttributeProperties.setModel(new AttributePropertiesTableModel(this.layer.getAttributeTable().getAttributeProperties()));
        this.attrPropOri = this.layer.getAttributeTable();
        try {
            this.attrPropClone = (AttributeTableModel)this.attrPropOri.clone();
        }
        catch (CloneNotSupportedException ex) {
            log.error("Could not clone attribute properties.", (Throwable)ex);
        }
    }

    @Override
    public UndoableCommand updateLayer() {
        AttributePropertiesPanelUndoableCommand undo = null;
        try {
            this.stopEditing();
            undo = new AttributePropertiesPanelUndoableCommand(this.layer, (AttributeTableModel)this.attrPropOri.clone(), (AttributeTableModel)this.attrPropClone.clone());
        }
        catch (CloneNotSupportedException ex) {
            log.error("Error creating undoable command. Could not clone attribute properties.", (Throwable)ex);
        }
        return undo;
    }

    @Override
    public String validateInput() {
        return null;
    }

    public void setFeatureRetriever(FeatureRetriever featureRetriever) {
        this.featureRetriever = featureRetriever;
        this.updateTableModel(featureRetriever.getAttributes());
    }

    private void initSortMenu() {
        this.butSort.setIcon(IconLoader.svgIcon((String)"order_table.svg"));
        this.butSort.setToolTipText(I18N.get("AttributePropertiesPanel.order-selection-tooltip"));
        JMenuItem menuItem1 = new JMenuItem(I18N.get("AttributePropertiesPanel.order-selection-attribute"));
        JMenuItem menuItem2 = new JMenuItem(I18N.get("AttributePropertiesPanel.order-selection-alias"));
        JMenuItem menuItem3 = new JMenuItem(I18N.get("AttributePropertiesPanel.order-selection-reset"));
        this.popupSort.add(menuItem1);
        this.popupSort.add(menuItem2);
        this.popupSort.add(menuItem3);
        menuItem1.addActionListener(e -> ((AttributePropertiesTableModel)this.tblAttributeProperties.getModel()).sortByAttribute());
        menuItem2.addActionListener(e -> ((AttributePropertiesTableModel)this.tblAttributeProperties.getModel()).sortByAlias());
        menuItem3.addActionListener(e -> {
            String[] fmdData = this.layer.getFMD().getAttributes();
            ((AttributePropertiesTableModel)this.tblAttributeProperties.getModel()).sortByFmdData(fmdData);
        });
    }

    private void initComponents() {
        this.popupSort = new JPopupMenu();
        this.scpAttributeProperties = new JScrollPane();
        this.tblAttributeProperties = new JTable();
        this.lblContent = new JLabel();
        this.butSort = new JButton();
        this.setLayout(new GridBagLayout());
        this.scpAttributeProperties.setPreferredSize(new Dimension(200, 100));
        this.scpAttributeProperties.setViewportView(this.tblAttributeProperties);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.scpAttributeProperties, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump_de");
        this.lblContent.setText(bundle.getString("column-view-order-headings"));
        this.lblContent.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 5, 3, 3);
        this.add((Component)this.lblContent, gridBagConstraints);
        this.lblContent.getAccessibleContext().setAccessibleName("lblContent");
        this.butSort.setMaximumSize(new Dimension(22, 22));
        this.butSort.setMinimumSize(new Dimension(22, 22));
        this.butSort.setPreferredSize(new Dimension(22, 22));
        this.butSort.addActionListener(this::butSortActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 2, 2, 4);
        this.add((Component)this.butSort, gridBagConstraints);
    }

    private void butSortActionPerformed(ActionEvent evt) {
        this.popupSort.show(this.butSort, 0, this.butSort.getHeight());
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    private class TableRowTransferHandler
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Row Index");
        private JTable table = null;

        public TableRowTransferHandler(JTable table) {
            this.table = table;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable && ((JTable)c).getSelectionModel().isSelectionEmpty()) {
                return null;
            }
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{TableRowTransferHandler.this.localObjectFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return Objects.equals(TableRowTransferHandler.this.localObjectFlavor, flavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return TableRowTransferHandler.this.table.getSelectedRow();
                }
            };
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.getComponent() == this.table && support.isDrop() && support.isDataFlavorSupported(this.localObjectFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            int row;
            JTable.DropLocation dropLocation = (JTable.DropLocation)support.getDropLocation();
            try {
                row = (Integer)support.getTransferable().getTransferData(this.localObjectFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                log.error("DnD error.", (Throwable)e);
                return false;
            }
            int index2Add = ((AttributePropertiesTableModel)AttributePropertiesPanel.this.tblAttributeProperties.getModel()).moveRow(row, dropLocation.getRow());
            AttributePropertiesPanel.this.tblAttributeProperties.setRowSelectionInterval(index2Add, index2Add);
            return true;
        }
    }

    private static class AttributePropertiesPanelUndoableCommand
    extends UndoableCommand {
        private final Layer layer;
        private final AttributeTableModel attrPropdOld;
        private final AttributeTableModel attrPropNew;

        AttributePropertiesPanelUndoableCommand(Layer layer, AttributeTableModel attrPropdOld, AttributeTableModel attrPropNew) {
            super("AttributePropertiesPanel");
            this.layer = layer;
            this.attrPropdOld = attrPropdOld;
            this.attrPropNew = attrPropNew;
        }

        @Override
        public void execute() {
            this.layer.setAttributeTable(this.attrPropNew);
        }

        @Override
        public void unexecute() {
            this.layer.setAttributeTable(this.attrPropdOld);
        }
    }
}

