/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data.gui;

import com.vividsolutions.jump.I18N;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.opengis.feature.simple.SimpleFeatureType;

public class AttributeListDialog
extends JDialog {
    private boolean bolOKPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private JScrollPane jScrollPane1;
    private JLabel lblAttribute;
    private JList<String> lstAttribute;
    private JPanel pnlOKCancel;

    public AttributeListDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public AttributeListDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    private void init() {
        this.initComponents();
        this.i18n();
        this.setSize(300, 300);
    }

    private void i18n() {
        this.setTitle(I18N.get("de.riwagis.riwajump.AttributeListDialog.title"));
        this.lblAttribute.setText(I18N.get("de.riwagis.riwajump.AttributeListDialog.title") + ":");
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
    }

    public void setFeatureType(SimpleFeatureType type) throws Exception {
        String[] arrAtts = new String[type.getAttributeCount()];
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            arrAtts[i] = type.getDescriptor(i).getName().getLocalPart();
        }
        Arrays.sort(arrAtts, String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> lstData = new ArrayList<String>();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            lstData.add(arrAtts[i]);
        }
        ListListModel lstModel = new ListListModel(lstData);
        this.lstAttribute.setModel((ListModel<String>)lstModel);
    }

    public void setAttributeNames(String[] arrNames) {
        if (arrNames == null) {
            return;
        }
        int[] arrIndex = new int[arrNames.length];
        int count = this.lstAttribute.getModel().getSize();
        block0: for (int i = 0; i < arrIndex.length; ++i) {
            for (int j = 0; j < count; ++j) {
                if (!arrNames[i].equals(this.lstAttribute.getModel().getElementAt(j).toString())) continue;
                arrIndex[i] = j;
                continue block0;
            }
        }
        this.lstAttribute.setSelectedIndices(arrIndex);
    }

    public String[] getAttributeNames() {
        List<String> arrObj = this.lstAttribute.getSelectedValuesList();
        return arrObj.toArray(new String[arrObj.size()]);
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    public static AttributeListDialog createCenteredToWindow(Component component) {
        AttributeListDialog instance;
        Window parent = SwingUtilities.windowForComponent(component);
        if (parent instanceof Frame) {
            instance = new AttributeListDialog((Frame)parent, true);
        } else if (parent instanceof Dialog) {
            instance = new AttributeListDialog((Dialog)parent, true);
        } else {
            throw new AssertionError((Object)"Unknown window type");
        }
        instance.setLocationRelativeTo(SwingUtilities.getRoot(component));
        return instance;
    }

    private void initComponents() {
        this.lblAttribute = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstAttribute = new JList();
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblAttribute.setText("Attribute:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.lblAttribute, gridBagConstraints);
        this.lstAttribute.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributeListDialog.this.lstAttribute_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstAttribute);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeListDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeListDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        this.pack();
    }

    private void lstAttribute_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butOK_onActionPerformed(null);
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = true;
        this.setVisible(false);
    }
}

