/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;

public class Filters {
    private static final FilterFactory2 ffac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public static List<Filter> createPartitionedFiltersForFIDs(Collection<? extends Object> ids) {
        List<FeatureId> fids = ids.stream().map(Objects::toString).map(arg_0 -> ((FilterFactory2)ffac).featureId(arg_0)).toList();
        List partitions = Lists.partition(fids, (int)500);
        return partitions.stream().map(p -> ffac.id(new HashSet(p))).toList();
    }

    public static List<Filter> createPartitionedFiltersForAttributeIn(String attribute, Collection<? extends Object> values) {
        PropertyName attributeProperty = ffac.property(attribute);
        List<Filter> filters = values.stream().map(value -> ffac.equals((Expression)attributeProperty, (Expression)ffac.literal(value))).toList();
        List partitions = Lists.partition(filters, (int)100);
        return partitions.stream().map(p -> ffac.or(p)).toList();
    }

    private Filters() {
    }
}

