/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwajump.data;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.io.IOException;
import java.util.Map;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class DataStores {
    public static SimpleFeatureType dumpFeatureType(DatastoreMetadata sourceDMD, SimpleFeatureType sourceSchema, DatastoreMetadata targetDMD, SimpleFeatureType targetSchema, Map<String, String> updatedAttributes) throws IOException {
        try (DefaultTransaction t = new DefaultTransaction("batchInsert");
             FeatureReader reader = sourceDMD.getDataStore().getFeatureReader(new Query(sourceSchema.getTypeName()), (Transaction)t);){
            targetDMD.getDataStore().createSchema((FeatureType)targetSchema);
            targetSchema = targetDMD.getDataStore().getSchema(targetSchema.getTypeName());
            try (FeatureWriter writer = targetDMD.getDataStore().getFeatureWriterAppend(targetSchema.getTypeName(), (Transaction)t);){
                while (reader.hasNext()) {
                    SimpleFeature source = (SimpleFeature)reader.next();
                    SimpleFeature target = (SimpleFeature)writer.next();
                    FeatureUtil.copyFeatureData((SimpleFeature)source, (SimpleFeature)target, updatedAttributes);
                    writer.write();
                }
                t.commit();
            }
        }
        return targetSchema;
    }

    private DataStores() {
    }
}

