/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.rasterize;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderHints;
import de.riwagis.rasterize.ImageFormat;
import de.riwagis.rasterize.RasterException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RasterUtil.class);

    public static Collection<Throwable> rasterize(Envelope env, Task task, Dimension tileSize, BufferedImage image) {
        return RasterUtil.rasterize(env, task, tileSize, image, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Throwable> rasterize(Envelope env, Task task, Dimension tileSize, BufferedImage image, boolean _antialias) {
        final ArrayList<Throwable> lastErrors = new ArrayList<Throwable>();
        LayerViewPanel layerViewPanel = new LayerViewPanel(task.getLayerManager(), new LayerViewPanelContext(){

            @Override
            public void setStatusMessage(String message) {
                LOG.info(message);
            }

            @Override
            public void warnUser(String warning) {
                LOG.warn(warning);
            }

            @Override
            public void handleThrowable(Throwable t) {
                lastErrors.add(t);
                LOG.error(t.getMessage(), t);
            }
        }, true);
        try {
            LOG.debug(String.format("Start rendering '%s', Task: %s)", env, task.getName()));
            layerViewPanel.setRepaint(false);
            SimpleRenderHints rh = new SimpleRenderHints(layerViewPanel.getRenderHints());
            rh.setAntialiasing(_antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            layerViewPanel.setRenderHints(rh);
            RenderingManager rm = layerViewPanel.getRenderingManager();
            Graphics2D imageGraphics = (Graphics2D)image.getGraphics();
            layerViewPanel.setSize(tileSize);
            layerViewPanel.getViewport().zoom(env, false);
            layerViewPanel.paintComponent(imageGraphics);
            imageGraphics.setRenderingHint(Viewport.KEY_IS4PRINT, Viewport.VALUE_IS4PRINT);
            for (Object renderContent : rm.contentIDs()) {
                Layer renderContentLayer;
                Renderer renderer = rm.createRenderer(renderContent);
                if (renderer == null) continue;
                LOG.debug(String.format("Rendering ContentID: %s", renderContent));
                Runnable runner = renderer.createRunnable();
                if (runner != null) {
                    runner.run();
                }
                renderer.copyTo(imageGraphics);
                if (!(renderContent instanceof Layer) || !StringUtils.isNotBlank((CharSequence)(renderContentLayer = (Layer)renderContent).getRenderError())) continue;
                lastErrors.add(new RasterException(String.format("Error rendering %s: %s", renderContent, renderContentLayer.getRenderError())));
            }
            layerViewPanel.getRenderingManager().clearImageCache();
            layerViewPanel.dispose();
        }
        catch (Throwable throwable) {
            layerViewPanel.dispose();
            LOG.debug(String.format("Done rendering '%s', Task: %s)", env, task.getName()));
            throw throwable;
        }
        LOG.debug(String.format("Done rendering '%s', Task: %s)", env, task.getName()));
        return lastErrors;
    }

    public static void saveImage(RenderedImage image, ImageFormat format, File file) throws IOException {
        if (!ImageIO.write(image, format.getFormatString(), file)) {
            throw new IOException(String.format("Error writing image '%s': maybe unknown format '%s'", new Object[]{file, format}));
        }
        LOG.debug(String.format("Image '%s' saved", file));
    }

    public static BufferedImage buildImage(Dimension tileSize) {
        return new BufferedImage(tileSize.width, tileSize.height, 1);
    }

    public static Dimension calcImageSize(Envelope env, double scale, double inchinunit, int ppi) {
        return new Dimension((int)(env.getWidth() / scale / inchinunit * (double)ppi), (int)(env.getHeight() / scale / inchinunit * (double)ppi));
    }

    private RasterUtil() {
    }
}

