/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.rasterize;

import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.renderer.RasterImageLayerRendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import de.riwagis.rasterize.ImageFormat;
import de.riwagis.util.thread.ThreadUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RasterThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(RasterThread.class);
    private final double scale;
    private final LayerViewPanel layerViewPanel;
    private final Envelope env;
    private final Task task;
    private final int ppi;
    private final List<ActionListener> lstListeners = new ArrayList<ActionListener>();
    private final File imgFile;
    private final double inchinunit;
    private final LayerViewPanelContext context = new LayerViewPanelContext(this){

        @Override
        public void setStatusMessage(String message) {
            LOG.info("Status:" + message);
        }

        @Override
        public void warnUser(String warning) {
            LOG.warn("Warning:" + warning);
        }

        @Override
        public void handleThrowable(Throwable t) {
            LOG.error("Error:" + t.getMessage(), t);
        }
    };
    private String strErrorText = null;
    private ImageFormat intFormat = ImageFormat.FORMAT_JPG;

    public RasterThread(int _ppi, Envelope _env, double _scale, Task _task, File _imgFile) {
        super("RasterThread");
        this.task = _task;
        this.ppi = _ppi;
        this.env = _env;
        this.imgFile = _imgFile;
        this.scale = _scale;
        this.layerViewPanel = new LayerViewPanel(_task.getLayerManager(), this.context, true);
        this.layerViewPanel.setRepaint(false);
        this.inchinunit = this.task.getDrawingUnit().getInchInUnit();
    }

    public void setFormat(ImageFormat _intFormat) {
        this.intFormat = _intFormat;
    }

    public void addListener(ActionListener listener) {
        this.lstListeners.add(listener);
    }

    public String getError() {
        return this.strErrorText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info(String.format("Start rendering '%s' (Env: %s, Scale: %f)", this.imgFile, this.env, this.scale));
        long time = System.currentTimeMillis();
        double screenscale = this.task.getScale();
        this.task.setScale(this.scale);
        ArrayList<String> errors = new ArrayList<String>();
        try {
            double screenwidth = this.env.getWidth() / this.scale / this.inchinunit * (double)this.ppi;
            double screenheight = this.env.getHeight() / this.scale / this.inchinunit * (double)this.ppi;
            this.layerViewPanel.setSize(new Dimension((int)screenwidth, (int)screenheight));
            BufferedImage image = new BufferedImage((int)screenwidth, (int)screenheight, 1);
            try {
                this.layerViewPanel.getViewport().zoom(this.env);
            }
            catch (Exception e) {
                LOG.warn("Error while zooming to rendering", (Throwable)e);
            }
            RasterThread.waitRenderingFinished(this.layerViewPanel);
            Graphics2D g = (Graphics2D)image.getGraphics();
            this.layerViewPanel.paintComponent(g);
            for (Layerable currLayer : this.layerViewPanel.getLayerManager().getLayerables()) {
                String strRenderError = currLayer.getRenderError();
                if (strRenderError == null) continue;
                errors.add(strRenderError);
            }
            if (errors.isEmpty()) {
                try {
                    RasterThread.saveImage(image, this.intFormat, this.imgFile);
                    LOG.info("Image: " + String.valueOf(this.imgFile) + " time: " + (System.currentTimeMillis() - time) / 1000L);
                }
                catch (Exception ex) {
                    errors.add(String.format("error on saving the image: '%s'", ex.getMessage()));
                }
            } else {
                LOG.warn("Image: " + String.valueOf(this.imgFile) + " no saved - error during rendering occured.");
            }
            this.layerViewPanel.getRenderingManager().clearImageCache();
            this.layerViewPanel.dispose();
            for (ActionListener listener : this.lstListeners) {
                listener.actionPerformed(new ActionEvent(this, 0, "ready"));
            }
        }
        finally {
            this.task.setScale(screenscale);
            this.strErrorText = StringUtils.join(errors, (String)"\n");
        }
        LOG.info(String.format("Done rendering '%s' (Env: %s, Scale: %f)", this.imgFile, this.env, this.scale));
    }

    public static void saveImage(RenderedImage image, ImageFormat format, File file) throws IOException {
        boolean writerFound = ImageIO.write(image, format.getFormatString(), file);
        Assert.isTrue((boolean)writerFound, (String)"invalid format");
    }

    public static void waitRenderingFinished(LayerViewPanel lv) {
        ThreadUtils.sleepQuietly((long)100L);
        int intNoRenderCount = 0;
        while (intNoRenderCount <= 10) {
            intNoRenderCount = lv.getRenderingManager().isRendering() ? 0 : ++intNoRenderCount;
            ThreadUtils.sleepQuietly((long)50L);
        }
        LOG.debug("Rendering finished.");
    }

    static {
        RenderingManager.putRendererForLayerable(RasterImageLayer.class, new RasterImageLayerRendererFactory());
    }
}

