/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.rasterize;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum ImageFormat {
    FORMAT_UNKNOWN(new String[]{"$$$"}),
    FORMAT_PNG(new String[]{"png"}),
    FORMAT_JPG(new String[]{"jpg", "jpeg"}),
    FORMAT_TIF(new String[]{"tif", "tiff"});

    private final String[] formatString;

    private ImageFormat(String[] formatString) {
        this.formatString = formatString;
    }

    public String getFormatString() {
        return this.formatString[0];
    }

    public static ImageFormat detectImgFormat(String _imgFormatString) {
        return ImageFormat.detectImgFormat(_imgFormatString, FORMAT_UNKNOWN);
    }

    public static ImageFormat detectImgFormat(String _imgFormatString, ImageFormat _defaultImageFormat) {
        ImageFormat res = _defaultImageFormat;
        for (ImageFormat currFormat : ImageFormat.values()) {
            for (String currFormatString : currFormat.formatString) {
                if (!StringUtils.endsWithIgnoreCase((CharSequence)_imgFormatString, (CharSequence)currFormatString)) continue;
                res = currFormat;
            }
        }
        return res;
    }

    public List<String> getFormatStrings() {
        return Arrays.asList(this.formatString);
    }
}

