/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.guitools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import de.riwagis.util.ThrowingRunnable;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class Tasks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Tasks.class);

    private Tasks() {
    }

    public static <E extends Exception> boolean submit(ThrowingRunnable<E> work) {
        return Tasks.submit(work, false);
    }

    public static <E extends Exception> boolean submit(ThrowingRunnable<E> work, boolean cancelable) {
        return Tasks.submit(work, cancelable, WorkbenchContext.getFrame());
    }

    public static <E extends Exception> boolean submit(ThrowingRunnable<E> work, boolean cancelable, Window parent) {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return Tasks.submitHeadless(work);
        }
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parent, (String)I18N.get("common.wait"));
        dlgWait.setCancelable(cancelable);
        dlgWait.addWorkToDo(() -> {
            try {
                work.run();
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(250L);
        if (dlgWait.getError() != null) {
            Tasks.handleThrowable(dlgWait.getError());
            return false;
        }
        return true;
    }

    private static <E extends Exception> boolean submitHeadless(ThrowingRunnable<E> work) {
        try {
            Exception exception = Executors.newSingleThreadExecutor().submit(() -> {
                try {
                    work.run();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }).get();
            if (exception != null) {
                throw new IllegalStateException(exception);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return true;
    }

    public static <T> boolean submit(Function<Consumer<String>, Mono<T>> observable, boolean cancelable) {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.setCancelable(cancelable);
        dlgWait.addWorkToDo(() -> ((Mono)observable.apply(msg -> SwingUtilities.invokeLater(() -> dlgWait.setMessage(msg))).doOnError(e -> {
            log.error("Error while running reactive task. ", e);
            dlgWait.setError((Exception)new RuntimeException((Throwable)e));
        }).doOnSuccess(t -> log.info("Finished execution of reactive task"))).block());
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            Tasks.handleThrowable(dlgWait.getError());
            return false;
        }
        return true;
    }

    private static void handleThrowable(Throwable throwable) {
        WorkbenchFrame.handleThrowable(throwable, WorkbenchContext.getFrame());
    }
}

