/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.guitools;

import com.vividsolutions.jump.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GUIUtil.class);

    public static void centreOnScreen(Component componentToMove) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        componentToMove.setLocation((screenSize.width - componentToMove.getWidth()) / 2, (screenSize.height - componentToMove.getHeight()) / 2);
    }

    public static void handleThrowable(final Throwable t, final Component parent) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOG.error("Exception encountered", t);
                    JOptionPane.showMessageDialog(parent, GUIUtil.split(t.toString(), 80), I18N.get("common.error"), 0);
                }
            });
        }
        catch (Throwable t2) {
            LOG.error("Exception encountered", t2);
        }
    }

    public static String split(String s, int n) {
        StringBuilder b = new StringBuilder();
        boolean wrapPending = false;
        for (int i = 0; i < s.length(); ++i) {
            if (i % n == 0 && i > 0) {
                wrapPending = true;
            }
            char c = s.charAt(i);
            if (wrapPending && c == ' ') {
                b.append("\n");
                wrapPending = false;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String nameWithoutExtension(File file) {
        String name = file.getName();
        int dotPosition = name.indexOf(46);
        return dotPosition < 0 ? name : name.substring(0, dotPosition);
    }

    public static String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

