/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump.map;

import com.google.common.collect.Sets;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.FeatureInfoPlugIn;
import de.riwagis.gis.context.jump.VectorLayerContextImpl;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.selection.ColumnFilter;
import de.riwagis.gis.context.map.selection.SelectionByFilterResult;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectByFilterAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectByFilterAction.class);
    private static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public void selectByFilter(MapContext mapContext, Map<String, ColumnFilter> selection, boolean activateLayers, boolean zoom, double minScale, boolean openFeatureInfo) throws Exception {
        log.debug("New selection with filter: {}", (Object)StringUtils.join((Object[])new Map[]{selection}));
        mapContext.clearSelection();
        Map<Layer, SelectionByFilterResult> layersWithSelections = selection.entrySet().parallelStream().map(kv -> this.doSelectionOnLayer(activateLayers, minScale, mapContext, (String)kv.getKey(), (ColumnFilter)kv.getValue())).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Runnable afterZoomAction = this.createAfterZoomAction(openFeatureInfo, layersWithSelections);
        layersWithSelections.values().stream().map(SelectionByFilterResult::getEnvelope).reduce(this::mergeEnvelope).ifPresentOrElse(envelope -> this.doZoomIfRequired(mapContext, zoom, minScale, (Envelope)envelope, afterZoomAction), () -> SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.get("de.riwagis.gis.context.jump.map.SelectByFilterAction.no-matching-features"), I18N.get("ui.WorkbenchFrame.warning"), 2)));
    }

    private Runnable createAfterZoomAction(boolean openFeatureInfo, Map<Layer, SelectionByFilterResult> layersWithSelections) {
        if (!openFeatureInfo) {
            return null;
        }
        return () -> {
            PlugInContext plugInContext = WorkbenchContext.getInstance().createPlugInContext();
            try {
                FeatureInfoPlugIn featureInfoPlugIn = JUMPWorkbench.getBuiltInPlugIn(FeatureInfoPlugIn.class);
                featureInfoPlugIn.executeForCustomSelectionWithoutInterface(plugInContext, layersWithSelections::keySet, layer -> {
                    SelectionByFilterResult result = (SelectionByFilterResult)layersWithSelections.get(layer);
                    return Sets.union((Set)result.getFeaturesWithGeometry(), (Set)result.getFeaturesWithoutGeometry());
                });
            }
            catch (Exception e) {
                log.error("Could not open feature info", (Throwable)e);
            }
        };
    }

    private Optional<Map.Entry<Layer, SelectionByFilterResult>> doSelectionOnLayer(boolean activateLayers, double minScale, MapContext mapContext, String layerName, ColumnFilter filter) {
        try {
            LayerContext layerContext = mapContext.getMapLayer(layerName);
            if (layerContext == null) {
                log.error("Could not find layer '{}'", (Object)layerName);
                return Optional.empty();
            }
            if (!(layerContext instanceof VectorLayerContextImpl)) {
                log.error("Layer '{}' is no vector layer", (Object)layerName);
                return Optional.empty();
            }
            VectorLayerContextImpl layerContextImpl = (VectorLayerContextImpl)layerContext;
            Layer wrappedLayer = layerContextImpl.getWrappedLayer();
            Filter fidFilter = this.buildFilter(wrappedLayer, filter);
            if (fidFilter == null) {
                log.error("Could not build CQL for layer '{}' and column '{}'", (Object)layerName, (Object)filter.getColumn());
                return Optional.empty();
            }
            if (activateLayers) {
                layerContext.setVisible(true);
            }
            return Optional.of(Map.entry(wrappedLayer, layerContextImpl.setSelectionByFilter(fidFilter, false, minScale, false)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Filter buildFilter(Layer layer, ColumnFilter filter) throws IOException {
        FeaturestoreMetadata fmd = layer.getFMD();
        DMDCollection dataStores = layer.getLayerManager().getTask().getDataStores();
        SimpleFeatureType schema = fmd.getSchema(dataStores);
        String columnName = this.determinePrimaryKeyAttribute(filter.getColumn(), fmd);
        if (columnName == null) {
            log.error("Could not determine primary key for layer '{}'", (Object)layer.getKey());
            return null;
        }
        AttributeType columnType = schema.getType(columnName);
        if (columnType == null) {
            log.error("Could not find a column '{}' for layer '{}'", (Object)columnName, (Object)layer.getKey());
            return null;
        }
        PropertyName property = ff.property(columnName);
        List values = filter.getValues().stream().map(v -> ff.equals((Expression)property, (Expression)ff.literal(v))).collect(Collectors.toList());
        return ff.or(values);
    }

    private String determinePrimaryKeyAttribute(String column, FeaturestoreMetadata fmd) {
        if (column != null) {
            return column;
        }
        if (fmd.getKeyAttView() != null) {
            return fmd.getKeyAttView();
        }
        return fmd.getKeyAtt();
    }

    public Envelope mergeEnvelope(Envelope a, Envelope b) {
        Envelope combined = new Envelope(a);
        combined.expandToInclude(b);
        return combined;
    }

    private void doZoomIfRequired(MapContext mapctx, boolean zoom, double minScale, Envelope envelope, Runnable afterZoomAction) {
        if (!zoom) {
            return;
        }
        if (envelope.isNull() && afterZoomAction != null) {
            afterZoomAction.run();
            return;
        }
        try {
            envelope.expandBy(envelope.getWidth() * 0.2);
            mapctx.zoomEnvelope(envelope, minScale, afterZoomAction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

