/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump.map;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import de.riwagis.gis.context.map.selection.GuidedSelection;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GuidedSelectionDialog {
    private final JLabel displayMessageLabel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JPanel mainPanel;
    private final JDialog selectionDialog;

    public GuidedSelectionDialog(GuidedSelection configuration) {
        WorkbenchContext context = WorkbenchContext.getInstance();
        WorkbenchFrame workbenchFrame = WorkbenchContext.getFrame();
        this.displayMessageLabel = new JLabel(Objects.requireNonNullElseGet(configuration.getDisplayMessage(), () -> I18N.get("de.riwagis.gis.context.jump.map.GuidedSelectionDialog.label-message")));
        this.okButton = new JButton(I18N.get("common.ok"));
        this.cancelButton = new JButton(I18N.get("common.cancel"));
        this.mainPanel = new JPanel();
        this.mainPanel.add(this.displayMessageLabel);
        this.mainPanel.add(this.okButton);
        this.mainPanel.add(this.cancelButton);
        this.selectionDialog = new JDialog((Frame)workbenchFrame, Objects.requireNonNullElseGet(configuration.getDisplayTitle(), () -> I18N.get("de.riwagis.gis.context.jump.map.GuidedSelectionDialog.title")));
        this.selectionDialog.setLayout(new GridLayout());
        this.selectionDialog.setDefaultCloseOperation(2);
        this.selectionDialog.add(this.mainPanel);
        this.selectionDialog.pack();
        LayerViewPanel viewPanel = context.getLayerViewPanel();
        Point topLeft = viewPanel.getLocationOnScreen();
        this.selectionDialog.setLocation(topLeft.x + viewPanel.getWidth() / 2 - this.selectionDialog.getWidth() / 2, topLeft.y + viewPanel.getHeight() * 4 / 5 - this.selectionDialog.getHeight() / 2);
        this.selectionDialog.setResizable(false);
        this.selectionDialog.setVisible(true);
        this.registerListeners(configuration, context, this.okButton, this.cancelButton, this.selectionDialog);
    }

    private void registerListeners(final GuidedSelection configuration, final WorkbenchContext context, JButton okButton, JButton cancelButton, final JDialog selectionDialog) {
        final SelectionListener updateEnabledState = () -> {
            boolean hasMatchingSelection = configuration.isSelectionValid();
            okButton.setEnabled(hasMatchingSelection);
            okButton.setToolTipText(hasMatchingSelection ? null : I18N.get("de.riwagis.gis.context.jump.map.GuidedSelectionDialog.label-no-matching-selection"));
        };
        updateEnabledState.selectionChanged();
        selectionDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GuidedSelectionDialog.this.doCancel(configuration, context, selectionDialog, updateEnabledState);
            }
        });
        okButton.addActionListener(e -> this.doOK(configuration, context, selectionDialog, updateEnabledState));
        cancelButton.addActionListener(e -> this.doCancel(configuration, context, selectionDialog, updateEnabledState));
        context.getSelectionManager().addSelectionListener(updateEnabledState);
    }

    private void doOK(GuidedSelection configuration, WorkbenchContext context, JDialog selectionDialog, SelectionListener updateEnabledState) {
        this.cleanUp(context, selectionDialog, updateEnabledState);
        configuration.ok();
    }

    private void doCancel(GuidedSelection configuration, WorkbenchContext context, JDialog selectionDialog, SelectionListener updateEnabledState) {
        this.cleanUp(context, selectionDialog, updateEnabledState);
        configuration.cancel();
    }

    private void cleanUp(WorkbenchContext context, JDialog selectionDialog, SelectionListener updateEnabledState) {
        selectionDialog.setVisible(false);
        selectionDialog.dispose();
        context.getSelectionManager().removeSelectionListener(updateEnabledState);
    }
}

