/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.AddFeatureGeomDialog;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.plugin.spatial.SpatialOperation;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.gis.context.jump.LayerContextImpl;
import de.riwagis.gis.context.jump.MapContextImpl;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.gis.context.map.selection.SelectionByFilterResult;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.data.model.TransformationService;
import de.riwagis.riwajump.feature.util.SourceTargetResult;
import de.riwagis.riwajump.feature.util.SpatialUtil;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.thread.DummyCancelable;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorLayerContextImpl
extends LayerContextImpl
implements VectorLayerContext {
    private static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private static final Logger LOG = LoggerFactory.getLogger(VectorLayerContextImpl.class);
    public static final double TRESHOLD_SELECTIVITY_FOR_BBOX_REQUEST = 0.66;
    private static AddFeatureGeomDialog dlgAddFeatGeom = null;
    private final TransformationService transformService = new TransformationService();
    private final Layer layer;
    private final TaskFrame frmTask;

    public VectorLayerContextImpl(Layer layer) {
        this(layer, JUMPWorkbench.getFrame().getTaskFrameByTask(layer.getLayerManager().getTask()));
    }

    VectorLayerContextImpl(Layer layer, TaskFrame frmTask) {
        super(layer);
        this.layer = layer;
        this.frmTask = frmTask;
    }

    private String getCrsCode() {
        CRSDefinition crsDef = this.layer.getLayerManager().getTask().getCRSDefinition();
        if (crsDef != null) {
            return crsDef.getCode();
        }
        return null;
    }

    public Layer getWrappedLayer() {
        return this.layer;
    }

    public int getType() {
        return 1;
    }

    public String[] getSelection() throws Exception {
        ArrayList<String> lstKeys = new ArrayList<String>();
        Iterator<String> i = this.layer.getSelectedFeatureKeys();
        while (i.hasNext()) {
            String strKey = ObjectUtils.toString((Object)i.next());
            if (strKey.length() <= 0) continue;
            lstKeys.add(FeatureUtil.getFeatureIDWithoutTable((String)strKey));
        }
        return lstKeys.toArray(new String[lstKeys.size()]);
    }

    public boolean hasSelection() {
        return this.frmTask.getSelectionManager().hasSelections(this.getWrappedLayer());
    }

    public void addFeatureGeometry(String strID) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String[] getSelectionOnLayer(int intMethod, double minAreaOnIntersect, boolean useTouchOnIntersect, String strFilter) throws Exception {
        SpatialOperation spOp = new SpatialOperation("_dummy");
        spOp.setMethod(intMethod);
        spOp.setMinArea(minAreaOnIntersect);
        spOp.setUseTouch(useTouchOnIntersect);
        spOp.setTargetFilter(strFilter);
        spOp.setTargetLayerID(this.layer.getKey());
        List<SourceTargetResult> lstResult = SpatialOperation.executeOperation(this.frmTask.getTask(), spOp, DummyCancelable.NEVER_CANCEL);
        ArrayList<String> lstKeys = new ArrayList<String>();
        FeatureIterator<SimpleFeature> fi = SpatialUtil.getUniqueTargetFeatureIterator(lstResult);
        while (fi.hasNext()) {
            SimpleFeature f = (SimpleFeature)fi.next();
            lstKeys.add(FeatureUtil.getFeatureIDWithoutTable((String)f.getID()));
        }
        return lstKeys.toArray(new String[lstKeys.size()]);
    }

    public Envelope getEnvelope(String[] arrID) throws Exception {
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        return this.getEnvelope(arrID, lstFeatures);
    }

    public Envelope getEnvelope(String[] arrID, Collection<SimpleFeature> lstFeatures) throws Exception {
        Transformer transformer = this.createTransformerIfNecessary();
        boolean filterByID = StringUtils.isEmpty((CharSequence)this.layer.getFMD().getKeyAttView()) && this.layer.getFMD().getKeyAtt() == null;
        int chunkSize = filterByID ? 500 : 100;
        Envelope env = new Envelope();
        List<String> fids = Arrays.asList(arrID);
        List partitions = ListUtils.partition(fids, (int)chunkSize);
        for (List partition : partitions) {
            Filter filter = this.createFidFilter(partition, this.layer, chunkSize);
            this.expandSelection(this.layer, filter, lstFeatures, env, f -> true, transformer);
        }
        env.expandBy(env.getWidth() * 0.2);
        return env;
    }

    public Envelope getEnvelope(String[] arrID, Collection<SimpleFeature> lstFeatures, Filter bboxFilter) throws Exception {
        Transformer transformer = this.createTransformerIfNecessary();
        Set<String> wantedFids = Set.of(arrID);
        Envelope env = new Envelope();
        this.expandSelection(this.layer, bboxFilter, lstFeatures, env, f -> this.setContainsFeature((SimpleFeature)f, wantedFids), transformer);
        env.expandBy(env.getWidth() * 0.2);
        return env;
    }

    private boolean setContainsFeature(SimpleFeature f, Set<String> wantedFids) {
        if (f == null || f.getID() == null) {
            return false;
        }
        return wantedFids.contains(FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)f));
    }

    private Transformer createTransformerIfNecessary() throws NoninvertibleTransformException, FactoryException {
        DMDCollection dmdcol = this.layer.getLayerManager().getTask().getDataStores();
        FeaturestoreMetadata fmd = this.getWrappedLayer().getFMD();
        if (!this.transformService.hasTransformation(fmd, dmdcol)) {
            return null;
        }
        return this.transformService.getTransformer(fmd, dmdcol);
    }

    public Envelope setSelection(String[] arrID, boolean zoomSelection, double minScale, boolean clearOldSelection) throws Exception {
        Envelope env = zoomSelection ? this.getEnvelope(arrID) : new Envelope();
        return this.setSelection(arrID, zoomSelection, minScale, clearOldSelection, env);
    }

    public Envelope setSelection(String[] arrID, boolean zoomSelection, double minScale, boolean clearOldSelection, Envelope zoomEnvelope) throws Exception {
        if (clearOldSelection) {
            this.frmTask.getSelectionManager().clear();
        }
        String crsSource = MapContextImpl.retrieveCrs4Envelope(zoomEnvelope);
        String crsTarget = this.getCrsCode();
        if (crsSource != null && StringUtils.isNotBlank((CharSequence)crsTarget)) {
            Transformer trans = new Transformer(crsSource, crsTarget);
            zoomEnvelope = new Envelope(zoomEnvelope);
            trans.transform2d(zoomEnvelope);
        }
        Runnable doSelect = null;
        if (this.isVisible(true)) {
            doSelect = () -> {
                try {
                    ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
                    if (this.isVisible()) {
                        if (StringUtils.isBlank((CharSequence)this.layer.getFMD().getKeyAttView())) {
                            for (String strFID : arrID) {
                                Geometry geom;
                                SimpleFeature feat = this.layer.getFeatureByKey(strFID, false);
                                if (feat == null || !VectorLayerContextImpl.geometryIsNotNullOrEmpty(geom = (Geometry)feat.getDefaultGeometry())) continue;
                                lstFeatures.add(feat);
                            }
                        } else {
                            HashSet<String> idSet = new HashSet<String>();
                            for (String strFID : arrID) {
                                if (!StringUtils.isNotBlank((CharSequence)strFID)) continue;
                                idSet.add(strFID);
                            }
                            FeatureIterator<SimpleFeature> fi = this.layer.getFeatureIterator((Filter)Filter.INCLUDE);
                            while (fi.hasNext()) {
                                SimpleFeature fCandidate = (SimpleFeature)fi.next();
                                String idCandidate = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)fCandidate, (String)this.layer.getFMD().getKeyAttView()), "");
                                Geometry geom = (Geometry)fCandidate.getDefaultGeometry();
                                if (!idSet.contains(idCandidate) || !VectorLayerContextImpl.geometryIsNotNullOrEmpty(geom)) continue;
                                lstFeatures.add(fCandidate);
                            }
                        }
                    } else {
                        this.requestFeaturesFromDataSource(arrID, lstFeatures);
                    }
                    if (clearOldSelection) {
                        this.frmTask.getSelectionManager().clear();
                    }
                    this.frmTask.getSelectionManager().getFeatureSelection().selectItems(this.layer, lstFeatures);
                }
                catch (Exception e) {
                    WorkbenchContext.getFrame().handleThrowable(e);
                    LOG.error("Error at selecting features.", (Throwable)e);
                }
            };
        }
        if (zoomEnvelope == null) {
            zoomEnvelope = new Envelope();
        }
        if (zoomSelection) {
            if (zoomEnvelope.isNull()) {
                zoomEnvelope = this.getEnvelope(arrID);
            }
            if (!zoomEnvelope.isNull()) {
                this.layer.getLayerManager().getMapContext().zoomEnvelope(zoomEnvelope, minScale, doSelect);
            }
        } else if (doSelect != null) {
            doSelect.run();
        }
        return zoomEnvelope;
    }

    private void requestFeaturesFromDataSource(String[] arrID, Collection<SimpleFeature> lstFeatures) throws Exception {
        boolean doBBOXrequest;
        Envelope envelopeInModelCoordinates = this.frmTask.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        Filter envelopeFilter = this.layer.getEnvelopeFilter(envelopeInModelCoordinates);
        int featuresInEnvelope = this.layer.getFeatureCountForFilter(envelopeFilter);
        boolean bl = doBBOXrequest = (double)arrID.length > 0.66 * (double)featuresInEnvelope;
        if (doBBOXrequest) {
            this.getEnvelope(arrID, lstFeatures, envelopeFilter);
        } else {
            this.getEnvelope(arrID, lstFeatures);
        }
    }

    protected void expandSelection(Layer layer, Filter filter, Collection<SimpleFeature> lstFeatures, Envelope env, Function<SimpleFeature, Boolean> featureChecker, Transformer transformer) throws Exception {
        try {
            DMDCollection dmdCol = layer.getLayerManager().getTask().getDataStores();
            try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = layer.getFMD().getFeatureReader(dmdCol, filter);){
                while (reader.hasNext()) {
                    SimpleFeature f = (SimpleFeature)reader.next();
                    Geometry geom = (Geometry)f.getDefaultGeometry();
                    if (!VectorLayerContextImpl.geometryIsNotNullOrEmpty(geom) || !featureChecker.apply(f).booleanValue()) continue;
                    if (transformer != null) {
                        transformer.transform2d(f);
                    }
                    env.expandToInclude(geom.getEnvelopeInternal());
                    lstFeatures.add(f);
                }
            }
        }
        catch (Throwable t) {
            throw new SystemException(String.format("Error in finding envelope for layer '%s' with filter '%s': %s", layer.getKey(), ObjectUtils.toString((Object)filter), t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionByFilterResult setSelectionByFilter(Filter filter, boolean bolZoomSelection, double minScale, boolean bolClearOldSelection) throws Exception {
        if (bolClearOldSelection) {
            this.frmTask.getSelectionManager().clear();
        }
        HashSet<SimpleFeature> featuresWithGeometry = new HashSet<SimpleFeature>();
        HashSet<SimpleFeature> featuresWithoutGeometry = new HashSet<SimpleFeature>();
        FeatureReader<SimpleFeatureType, SimpleFeature> fread = this.layer.getFMD().getFeatureReader(this.layer.getLayerManager().getTask().getDataStores(), filter);
        Envelope env = new Envelope();
        try {
            while (fread.hasNext()) {
                SimpleFeature f = (SimpleFeature)fread.next();
                if (f.getDefaultGeometry() != null) {
                    env.expandToInclude(((Geometry)f.getDefaultGeometry()).getEnvelopeInternal());
                    featuresWithGeometry.add(f);
                    continue;
                }
                featuresWithoutGeometry.add(f);
            }
        }
        finally {
            FeatureUtil.closeQuietly(fread);
        }
        if (!featuresWithGeometry.isEmpty()) {
            Runnable doSelect = null;
            if (this.isVisible(true)) {
                doSelect = () -> this.frmTask.getSelectionManager().getFeatureSelection().selectItems(this.layer, featuresWithGeometry);
            }
            if (bolZoomSelection && !env.isNull()) {
                this.layer.getLayerManager().getMapContext().zoomEnvelope(env, minScale, doSelect);
            } else if (doSelect != null) {
                doSelect.run();
            }
        }
        return new SelectionByFilterResult(env, featuresWithGeometry, featuresWithoutGeometry);
    }

    public Stream<SimpleFeature> featuresForFIDs(Collection<String> fids, int datasetLimit, Set<String> attributes) {
        Stream<SimpleFeature> stream;
        block9: {
            Filter fidFilter = this.createFidFilter(fids, this.layer, datasetLimit);
            FeatureIterator<SimpleFeature> it = this.layer.getFeatureIterator(fidFilter, attributes);
            try {
                ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                while (it.hasNext()) {
                    features.add((SimpleFeature)it.next());
                }
                stream = features.stream();
                if (it == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Could not read feature from iterator", (Throwable)e);
                    throw new IllegalStateException("Could not read feature from iterator", e);
                }
            }
            it.close();
        }
        return stream;
    }

    public Stream<SimpleFeature> selectedFeatures(Set<String> attributes, int maxAllowedFeatures) {
        Collection<SimpleFeature> featuresToExport = this.frmTask.getSelectionManager().getFeaturesWithSelectedItems(this.getWrappedLayer());
        if (featuresToExport.isEmpty()) {
            return Stream.empty();
        }
        if (Set.of(this.layer.getFMD().getAttributes()).containsAll(attributes)) {
            return featuresToExport.stream();
        }
        List<String> fids = featuresToExport.stream().map(f -> f.getID()).collect(Collectors.toList());
        return this.featuresForFIDs(fids, maxAllowedFeatures, attributes);
    }

    private Filter createFidFilter(Collection<String> fids, Layer layer, int datasetLimit) throws Exception {
        FeaturestoreMetadata fmd = layer.getFMD();
        String viewKey = fmd.getKeyAttView();
        String tableKey = fmd.getKeyAtt();
        Stream<String> fidStream = fids.stream().limit(datasetLimit);
        if (StringUtils.isEmpty((CharSequence)viewKey) && tableKey == null) {
            String typePrefix = fmd.getDatatypeName() + ".";
            Object finalPrefix = fids.iterator().next().startsWith(typePrefix) ? "" : typePrefix;
            return FilterUtil.getFidFilter((String[])fidStream.map(arg_0 -> VectorLayerContextImpl.lambda$createFidFilter$5((String)finalPrefix, arg_0)).collect(Collectors.toList()).toArray(new String[0]));
        }
        String keyAttribute = Objects.requireNonNullElse(viewKey, tableKey);
        PropertyName property = ff.property(keyAttribute);
        List values = fidStream.map(v -> ff.equals((Expression)property, (Expression)ff.literal(v))).collect(Collectors.toList());
        return ff.or(values);
    }

    public String getFilter() {
        return this.layer.getFMD().getFilterText();
    }

    public void setFilter(String strFilter) throws Exception {
        this.layer.getFMD().setFilterText(strFilter);
        this.layer.clearFeatureCache();
        this.layer.fireAppearanceChanged();
    }

    @Override
    public void refresh() {
        this.layer.clearRendererCache();
        this.layer.clearFeatureCache();
        WorkbenchContext.getInstance().getLayerViewPanel().getRenderingManager().render(this.layer, true);
        Gis3DContextImpl.getInstance().syncVectorTileLayerContent(this.layer);
        LayerNamePanel layerNamePanel = this.frmTask.getLayerNamePanel();
        if (layerNamePanel instanceof TreeLayerNamePanel) {
            TreeLayerNamePanel panel = (TreeLayerNamePanel)layerNamePanel;
            panel.treeLayerChanged(this.layer);
        }
    }

    public boolean hasUncommitedData() {
        return this.layer.hasUncommitedData();
    }

    public synchronized boolean addGeometry(final String strID) throws Exception {
        if (strID == null) {
            GUISupport.msgbox((Component)this.frmTask, (String)"Invalid ID.", (String)"error");
            return false;
        }
        if (!this.layer.isEditable()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.layer-not-editable"), (String)I18N.get("common.error"));
            return false;
        }
        if (dlgAddFeatGeom != null) {
            dlgAddFeatGeom.setVisible(false);
            dlgAddFeatGeom.dispose();
        }
        if (this.layer.getFeatureByKey(strID) == null) {
            return false;
        }
        if (this.layer.hasUncommitedData()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features"), (String)I18N.get("common.message"));
            return true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlgAddFeatGeom = new AddFeatureGeomDialog((Frame)WorkbenchContext.getFrame(), VectorLayerContextImpl.this.layer, strID, true);
            }
        });
        return true;
    }

    public boolean isEditable() {
        return this.layer.isEditable();
    }

    public String[] getFIDFilter() {
        Collection<String> whiteList = this.layer.getFidFilterWhiteList();
        if (whiteList == null) {
            return null;
        }
        return whiteList.toArray(new String[whiteList.size()]);
    }

    public void setFIDFilter(String[] arrIDs) {
        try {
            if (arrIDs == null) {
                this.layer.setFidFilterWhiteList(null);
            } else {
                this.layer.setFidFilterWhiteList(new HashSet<String>(Arrays.asList(arrIDs)));
            }
            if (this.layer.isVisibleOnScreen()) {
                WorkbenchContext.getFrame().getTaskFrameByTask(this.layer.getLayerManager().getTask()).getLayerViewPanel().copyTo();
            }
            this.layer.fireAppearanceChanged();
        }
        catch (Exception e) {
            LOG.error("error setting fid filter white list", (Throwable)e);
        }
    }

    public void addFIDFilter(String[] arrIDs) {
        try {
            if (this.layer.getFidFilterWhiteList() == null) {
                this.layer.setFidFilterWhiteList(new HashSet<String>(Arrays.asList(arrIDs)));
            } else {
                this.layer.getFidFilterWhiteList().addAll(Arrays.asList(arrIDs));
            }
            WorkbenchContext.getFrame().getTaskFrameByTask(this.layer.getLayerManager().getTask()).getLayerViewPanel().copyTo();
            this.layer.fireAppearanceChanged();
        }
        catch (Exception e) {
            LOG.error("error adding fid filter to white list", (Throwable)e);
        }
    }

    public void removeFIDFilter(String[] arrIDs) {
        try {
            if (this.layer.getFidFilterWhiteList() == null || this.layer.getFidFilterWhiteList().isEmpty()) {
                return;
            }
            for (String arrID : arrIDs) {
                this.layer.getFidFilterWhiteList().remove(arrID);
            }
            WorkbenchContext.getFrame().getTaskFrameByTask(this.layer.getLayerManager().getTask()).getLayerViewPanel().copyTo();
            this.layer.fireAppearanceChanged();
        }
        catch (Exception e) {
            LOG.error("error adding fid filter to white list", (Throwable)e);
        }
    }

    public Set<String> getFIDs(Filter filter) {
        HashSet<String> hashSet;
        block9: {
            HashSet<String> fids = new HashSet<String>();
            FeatureIterator<SimpleFeature> fi = this.layer.getFeatureIterator(filter);
            try {
                while (fi.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)fi.next();
                    String id = feature.getID();
                    if (StringUtils.isBlank((CharSequence)id)) continue;
                    fids.add(id);
                }
                hashSet = fids;
                if (fi == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not get FIDs for query", ex);
                }
            }
            fi.close();
        }
        return hashSet;
    }

    private static boolean geometryIsNotNullOrEmpty(Geometry geom) {
        return geom != null && !geom.isEmpty();
    }

    private static /* synthetic */ String lambda$createFidFilter$5(String finalPrefix, String fid) {
        return finalPrefix + fid;
    }
}

