/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump;

import com.vividsolutions.jump.workbench.ui.plugin.print.JasperReportSupport;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintSupport {
    public static final int DEFAULT_ORIENTATION = 0;
    public static final float DEFAULT_DPI = 150.0f;
    private static final Logger LOG = LoggerFactory.getLogger(PrintSupport.class);
    public static final Collection<Integer> DEFAULT_SCALES = Arrays.asList(250, 500, 1000, 2500, 5000, 10000, 25000, 50000, 100000, 250000, 500000);
    public static final String KEY_REPORT_DATA = "report_data";

    public static Collection<Integer> determineAllowedScales(String _allowedScales, String _presetScale) {
        ArrayList<Integer> s = new ArrayList<Integer>();
        int _presetScaleInt = NumberUtils.toInt((String)_presetScale, (int)-1);
        if (_presetScaleInt > 0) {
            s.add(_presetScaleInt);
        } else if (StringUtils.isNotBlank((CharSequence)_allowedScales)) {
            for (String currScale : _allowedScales.split("[;,]")) {
                try {
                    s.add(Integer.valueOf(currScale));
                }
                catch (NumberFormatException nfex) {
                    LOG.warn(String.format("Illegal number: %s (%s)", currScale, nfex.getMessage()));
                }
            }
        } else {
            s.addAll(DEFAULT_SCALES);
        }
        return s;
    }

    public static File swapExtension(File expFile, String extension) {
        if (StringUtils.isBlank((CharSequence)extension)) {
            throw new IllegalArgumentException("extension must not be blank.");
        }
        return new File(FilenameUtils.removeExtension((String)expFile.getAbsolutePath()) + "." + extension);
    }

    public static Envelope determineEnvelope(PrintDraft pd, int scale, Envelope env) {
        Dimension2D d = pd.getPrintAreaInUnit("map", scale, JasperReportSupport.DU_METER);
        Envelope p_env = new Envelope();
        p_env.init(0.0, d.getWidth(), 0.0, d.getHeight());
        if (env.centre() != null) {
            p_env.translate(env.centre().x - d.getWidth() / 2.0, env.centre().y - d.getHeight() / 2.0);
        }
        return p_env;
    }

    public static float calcDPI2Quality(float dpi) {
        float effDPI = (double)dpi > 0.0 ? dpi : 150.0f;
        return (float)((double)effDPI / 72.0);
    }

    private PrintSupport() {
    }
}

