/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.task.PrintLayerView;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.plugin.print.JasperReportSupport;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraftUtils;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintThread;
import de.riwagis.gis.context.jump.PrintSupport;
import de.riwagis.gis.context.map.ReportFilePersist;
import de.riwagis.gis.context.map.ReportFilePersistException;
import de.riwagis.jasperreports.datasource.MultiplyingJRDataSource;
import de.riwagis.jr.JRRenderableFactory;
import de.riwagis.renderinterface.RenderInterfaceUtils;
import de.riwagis.renderinterface.parameters.PrintAreaDefinition;
import de.riwagis.renderreport.RenderTarget;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.geom.Dimension2DDouble;
import de.riwagis.util.localdb.HSQLDBUtils;
import de.riwagis.util.localdb.LocalDBBuilder;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.type.PdfPrintScalingEnum;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import net.sf.jasperreports.renderers.Renderable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextPrint {
    public static final float DEFAULT_DPI = 150.0f;
    private static final Logger LOG = LoggerFactory.getLogger(MapContextPrint.class);
    private static final GeometryFactory GFAC = new GeometryFactory();
    private static final WKTReader parser = new WKTReader(GFAC);
    public static final Collection<Integer> DEFAULT_SCALES = Arrays.asList(250, 500, 1000, 2500, 5000, 10000, 25000, 50000, 100000, 250000, 500000);
    public static final int DEFAULT_ORIENTATION = 0;
    private static final RenderTarget rentertarget = new RenderTarget(){

        public Renderable buildRenderer(Object printDefinition) {
            try {
                PrintAreaDefinition defRead = RenderInterfaceUtils.readFromJson((byte[])ObjectUtils.toString((Object)printDefinition).getBytes());
                Envelope env = parser.read(defRead.getGeom()).getEnvelopeInternal();
                LOG.info(String.format("env: %s, scales: %s", env, defRead.getScales()));
                LayerManager layerManager = WorkbenchContext.getInstance().getLayerManager();
                PrintLayerView layerView = new PrintLayerView(layerManager);
                Dimension2DDouble scaleBarOffset = defRead.getPrintScaleBar() ? new Dimension2DDouble(0.0, 0.0) : null;
                float quality = MapContextPrint.calcDPI2Quality(defRead.getDPI());
                PrintRenderer pr = new PrintRenderer((LayerView)layerView, env, (Dimension2D)scaleBarOffset, 0, quality, null, 1000, defRead);
                return pr;
            }
            catch (IOException | ParseException ex) {
                LOG.error(String.format("unable to build renderer: %s", ex.getMessage()), ex);
                return null;
            }
        }

        public String determineScale(Object printDefinition, Dimension printAreaPt) {
            try {
                PrintAreaDefinition defRead = RenderInterfaceUtils.readFromJson((byte[])ObjectUtils.toString((Object)printDefinition).getBytes());
                Envelope env = parser.read(defRead.getGeom()).getEnvelopeInternal();
                PrintLayerView layerView = new PrintLayerView(WorkbenchContext.getInstance().getLayerManager());
                Integer scale = PrintDraftUtils.findMatchingScale(printAreaPt, env, layerView.getLayerManager().getTask().getDrawingUnit(), defRead.getScales());
                if (scale > 0) {
                    return Integer.toString(scale);
                }
            }
            catch (IOException | ParseException ex) {
                LOG.error(String.format("unable to determine scale: %s", ex.getMessage()), ex);
            }
            return "???";
        }
    };

    public static File exportFileLocalDB(Map<String, Object> reportData, File templateFile, Map<String, Object> extraParameters, File tempDir, ReportFilePersist ps) throws IOException, SystemException {
        File file;
        block13: {
            String dbname = FilenameUtils.getBaseName((String)templateFile.getName()) + ".hsqldb";
            File hsqldbDir = new File(tempDir, dbname);
            HSQLDBUtils.deleteHSQLDB((File)hsqldbDir);
            LinkedHashSet reportFiles = new LinkedHashSet();
            Connection c = HSQLDBUtils.createHSQLDBConnection((File)hsqldbDir);
            try {
                LocalDBBuilder.fromList((Connection)c, reportData);
                if (ps != null) {
                    try {
                        reportFiles.addAll(ps.persistReportFiles(c, tempDir));
                    }
                    catch (ReportFilePersistException persEx) {
                        LOG.error("unable to persist report files: " + persEx.getMessage(), (Throwable)persEx);
                    }
                }
                JRRenderableFactory.configure((RenderTarget)rentertarget);
                PrintDraft pd = new PrintDraft(templateFile);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.putAll(extraParameters);
                File expFile = MapContextPrint.getExportFile(tempDir, "export_", ".pdf");
                ArrayList<File> reportSourceDirs = new ArrayList<File>();
                reportSourceDirs.add(templateFile.getParentFile());
                if (pd.getOriginalReportFile() != null && pd.getOriginalReportFile().isFile()) {
                    reportSourceDirs.add(pd.getOriginalReportFile().getParentFile());
                }
                LocalJasperReportsContext context = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
                context.setClassLoader(MapContextPrint.class.getClassLoader());
                context.setFileResolver(JasperReportSupport.buildJRFileResolver(reportSourceDirs));
                JasperPrint jasperPrint = JasperFillManager.getInstance((JasperReportsContext)context).fill(pd.getReport(), parameters, c);
                JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)context);
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(expFile));
                SimplePdfExporterConfiguration config = new SimplePdfExporterConfiguration();
                config.setPdfVersion(PdfVersionEnum.VERSION_1_7);
                config.setCompressed(Boolean.TRUE);
                config.setPrintScaling(PdfPrintScalingEnum.NONE);
                exporter.setConfiguration((ExporterConfiguration)config);
                exporter.exportReport();
                file = expFile;
                if (c == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (SQLException | JRException ex) {
                    throw new SystemException(String.format("error exporting '%s': %s", templateFile, ex.getMessage()), ex);
                }
            }
            c.close();
        }
        return file;
    }

    private MapContextPrint() {
    }

    public static Collection<Integer> determineAllowedScales(String _allowedScales, String _presetScale) {
        ArrayList<Integer> s = new ArrayList<Integer>();
        int _presetScaleInt = NumberUtils.toInt((String)_presetScale, (int)-1);
        if (_presetScaleInt > 0) {
            s.add(_presetScaleInt);
        } else if (StringUtils.isNotBlank((CharSequence)_allowedScales)) {
            for (String currScale : _allowedScales.split("[;,]")) {
                try {
                    s.add(Integer.valueOf(currScale));
                }
                catch (NumberFormatException nfex) {
                    LOG.warn(String.format("Illegal number: %s (%s)", currScale, nfex.getMessage()));
                }
            }
        } else {
            s.addAll(DEFAULT_SCALES);
        }
        return s;
    }

    public static final File getExportFile(File _baseDir, String _prefix, String _suffix) {
        File res = null;
        int tmpCount = 0;
        while (res == null || res.exists()) {
            res = new File(_baseDir, String.format("%s%d%s", _prefix, ++tmpCount, _suffix));
        }
        if (res != null) {
            res.getParentFile().mkdirs();
        }
        return res;
    }

    public static Geometry parseGeometry(Map<String, Object> _reportData) throws SystemException {
        try {
            Geometry geom = _reportData.containsKey("geom") ? parser.read(ObjectUtils.toString((Object)_reportData.get("geom"))) : null;
            return geom;
        }
        catch (ParseException ex) {
            throw new SystemException(String.format("error parsing geom: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    public static Envelope determineEnvelope(PrintDraft pd, int scale, Envelope env) {
        Dimension2D d = pd.getPrintAreaInUnit("map", scale, JasperReportSupport.DU_METER);
        Envelope p_env = new Envelope();
        p_env.init(0.0, d.getWidth(), 0.0, d.getHeight());
        if (env.centre() != null) {
            p_env.translate(env.centre().x - d.getWidth() / 2.0, env.centre().y - d.getHeight() / 2.0);
        }
        return p_env;
    }

    public static float calcDPI2Quality(float dpi) {
        float effDPI = (double)dpi > 0.0 ? dpi : 150.0f;
        return (float)((double)effDPI / 72.0);
    }

    public static File exportFile(Map<String, Object> reportData, File templateFile, Map<String, Object> extraParameters, File tempDir) throws IOException, SystemException {
        try {
            Geometry geom = MapContextPrint.parseGeometry(reportData);
            Collection<Integer> allowedScales = PrintSupport.determineAllowedScales(ObjectUtils.toString((Object)reportData.get("allowed_scales")), ObjectUtils.toString((Object)reportData.get("scale")));
            MultiplyingJRDataSource ds = new MultiplyingJRDataSource(reportData);
            PrintDraft pd = new PrintDraft(templateFile);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.putAll(extraParameters);
            Envelope env = new Envelope();
            if (geom != null) {
                env.init(geom.getEnvelopeInternal());
            }
            int scale = JasperReportSupport.findMatchingScale(pd, env, allowedScales);
            Envelope p_env = PrintSupport.determineEnvelope(pd, scale, env);
            boolean orientation = false;
            File exportFileFin = MapContextPrint.getExportFile(tempDir, "export_", ".pdf");
            PrintThread printThread = new PrintThread(scale, 0, p_env, pd, parameters, WorkbenchContext.getInstance());
            printThread.setDatasource((JRDataSource)ds);
            printThread.setPrintFile(exportFileFin);
            printThread.setShowAfterPrint(false);
            printThread.setPrintQuality(PrintSupport.calcDPI2Quality(150.0f));
            printThread.start();
            printThread.join();
            return exportFileFin;
        }
        catch (InterruptedException | JRException ex) {
            throw new SystemException(String.format("error exporting '%s': %s", templateFile, ex.getMessage()), ex);
        }
    }
}

