/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.WMTSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.ModifierKeySpec;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetCoordinateTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEALayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.FirstTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import com.vividsolutions.jump.workbench.ui.tools.ScreenScale;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.gis.context.GisInterfaceException;
import de.riwagis.gis.context.jump.MapContextPrint;
import de.riwagis.gis.context.jump.VectorLayerContextImpl;
import de.riwagis.gis.context.jump.map.GuidedSelectionDialog;
import de.riwagis.gis.context.jump.map.SelectByFilterAction;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.OverlayFeatureDef;
import de.riwagis.gis.context.map.ReportFilePersist;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.gis.context.map.selection.ColumnFilter;
import de.riwagis.gis.context.map.selection.GuidedSelection;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.components.SelfClosingMessageBox;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextImpl
implements MapContext {
    private static final int MAX_UNCACHED_FEATURES_PER_LAYER_SELECTION = 20000;
    private static final int FLASH_DELAY_LONG = 300;
    private static final int FLASH_DELAY_SHORT = 200;
    private static String markerLayerKey = null;
    private static final Logger LOG = LoggerFactory.getLogger(MapContextImpl.class);
    public static final String SELECTION_MARKER_DURABLE = String.valueOf(MapContextImpl.class) + "_SHOW_DURABLE";
    public static final String SELECTION_MARKER_GEOMETRY = String.valueOf(MapContextImpl.class) + "_SHOW_GEOMETRY";
    private final LayerManager layerManager;
    private final TaskFrame frmTask;
    private static final GeometryFactory gfac = new GeometryFactory();
    private final Blackboard pBB;
    private final Semaphore selectionSemaphore = new Semaphore(1);

    public MapContextImpl(LayerManager _layerManager) {
        this.layerManager = _layerManager;
        this.frmTask = JUMPWorkbench.getFrame().getTaskFrameByTask(this.layerManager.getTask());
        this.pBB = PersistentBlackboardPlugIn.get();
    }

    public String getName() {
        return this.layerManager.getTask().getName();
    }

    public String getCrsCode() {
        CRSDefinition crsDef = this.layerManager.getTask().getCRSDefinition();
        if (crsDef != null) {
            return crsDef.getCode();
        }
        return null;
    }

    public static String retrieveCrs4Envelope(Envelope env) {
        if (env instanceof ReferencedEnvelope) {
            CoordinateReferenceSystem crs = ((ReferencedEnvelope)env).getCoordinateReferenceSystem();
            return Objects.isNull(crs) ? null : (String)crs.getIdentifiers().stream().findFirst().map(Identifier::getCode).filter(StringUtils::isNotBlank).orElse(null);
        }
        return null;
    }

    public void refresh() throws Exception {
        for (Layer ly : this.layerManager.getLayers()) {
            ly.clearFeatureCache();
        }
        this.frmTask.getLayerViewPanel().repaint();
    }

    public void refreshLayerViewPanel() {
        LayerViewPanel lvp = WorkbenchContext.getInstance().getLayerViewPanel();
        if (lvp != null) {
            lvp.copyTo();
        }
    }

    public String[] getSelectedGeometries() {
        Collection<Geometry> colSel = this.frmTask.getSelectionManager().getSelectedItems();
        String[] arrGeom = new String[colSel.size()];
        int counter = 0;
        for (Geometry currSel : colSel) {
            arrGeom[counter] = currSel.toText();
            ++counter;
        }
        return arrGeom;
    }

    public Map<String, String[]> getSelection() throws Exception {
        HashMap<String, String[]> mapSel = new HashMap<String, String[]>();
        for (Layer layer : this.layerManager) {
            if (this.frmTask.getSelectionManager().getFeaturesWithSelectedItems(layer).isEmpty()) continue;
            String[] arrSelection = layer.getVectorLayerContext().getSelection();
            mapSel.put(layer.getKey(), arrSelection);
        }
        return mapSel;
    }

    public void clearSelection() {
        this.frmTask.getSelectionManager().clear();
    }

    public Envelope setSelection(Map<String, String[]> selectionMap, boolean zoomSelection, double minScale) throws Exception {
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        Envelope env = new Envelope();
        Runnable work = () -> {
            try {
                if (!this.isSelectionSizePerLayerValidOrWarnUser(selectionMap.entrySet().stream().map(kv -> Map.entry((String)kv.getKey(), ((String[])kv.getValue()).length)))) {
                    return;
                }
                this.frmTask.getSelectionManager().clear();
                BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("envelope-calculation-%d").build();
                ExecutorService pool = Executors.newFixedThreadPool(7, (ThreadFactory)factory);
                HashSet<Future<Envelope>> setEnv = new HashSet<Future<Envelope>>();
                HashMap mapLayerFeatures = new HashMap();
                for (Map.Entry entry : selectionMap.entrySet()) {
                    Callable<Envelope> envCall = () -> {
                        String strLayerID = (String)entrySet.getKey();
                        String[] arrID = (String[])entrySet.getValue();
                        LayerContext ly = this.getMapLayer(strLayerID);
                        if (ly == null) {
                            return null;
                        }
                        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
                        Envelope envResult = null;
                        if (ly instanceof VectorLayerContext) {
                            VectorLayerContextImpl vLy = (VectorLayerContextImpl)ly;
                            envResult = vLy.getEnvelope(arrID, lstFeatures);
                            mapLayerFeatures.put(vLy, lstFeatures);
                        }
                        return envResult;
                    };
                    setEnv.add(pool.submit(envCall));
                }
                for (Future future : setEnv) {
                    Envelope envTmp = (Envelope)future.get();
                    if (envTmp == null) continue;
                    env.expandToInclude(envTmp);
                }
                Runnable doSelect = () -> {
                    for (Map.Entry entry : mapLayerFeatures.entrySet()) {
                        VectorLayerContextImpl vLy = (VectorLayerContextImpl)entry.getKey();
                        if (!vLy.isVisible(true)) continue;
                        this.frmTask.getSelectionManager().getFeatureSelection().selectItems(vLy.getWrappedLayer(), (Collection)entry.getValue());
                    }
                };
                if (zoomSelection) {
                    if (!env.isNull()) {
                        this.zoomEnvelope(env, minScale, doSelect);
                    }
                } else {
                    doSelect.run();
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return env;
    }

    public Envelope setSelection(Map<String, String[]> selectionMap, boolean zoomSelection, double minScale, Envelope zoomEnvelope) throws Exception {
        Envelope finalEnvelope;
        if (zoomSelection && (zoomEnvelope == null || zoomEnvelope.isNull())) {
            return this.setSelection(selectionMap, zoomSelection, minScale);
        }
        if (!this.isSelectionSizePerLayerValidOrWarnUser(selectionMap.entrySet().stream().map(kv -> Map.entry((String)kv.getKey(), ((String[])kv.getValue()).length)))) {
            return this.getEnvelope();
        }
        String crsSource = MapContextImpl.retrieveCrs4Envelope(zoomEnvelope);
        String crsTarget = this.getCrsCode();
        if (crsSource != null && StringUtils.isNotBlank((CharSequence)crsTarget)) {
            Transformer trans = new Transformer(crsSource, crsTarget);
            finalEnvelope = new Envelope(zoomEnvelope);
            trans.transform2d(finalEnvelope);
        } else {
            finalEnvelope = zoomEnvelope;
        }
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        Runnable work = () -> {
            try {
                this.selectionSemaphore.acquire();
                this.frmTask.getSelectionManager().clear();
                Runnable doSelect = () -> {
                    try {
                        this.doSelect(selectionMap, minScale);
                    }
                    catch (Exception e) {
                        dlgWait.setError(e);
                    }
                    finally {
                        this.selectionSemaphore.release();
                    }
                };
                if (zoomSelection) {
                    if (!finalEnvelope.isNull()) {
                        this.zoomEnvelope(finalEnvelope, minScale, doSelect);
                    }
                } else {
                    doSelect.run();
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return finalEnvelope;
    }

    private void doSelect(Map<String, String[]> selectionMap, double minScale) throws Exception {
        boolean showFilterWarning = false;
        for (Map.Entry<String, String[]> entrySet : selectionMap.entrySet()) {
            VectorLayerContextImpl vLy;
            String strLayerID = entrySet.getKey();
            String[] arrID = entrySet.getValue();
            LayerContext ly = this.getMapLayer(strLayerID);
            if (ly == null || !(ly instanceof VectorLayerContext) || !(vLy = (VectorLayerContextImpl)ly).getWrappedLayer().isVisible()) continue;
            String[] arrFIDFilter = vLy.getFIDFilter();
            if (arrFIDFilter != null) {
                HashSet<String> tempList = new HashSet<String>(Arrays.asList(arrID));
                tempList.retainAll(new HashSet<String>(Arrays.asList(arrFIDFilter)));
                arrID = tempList.toArray(new String[0]);
                showFilterWarning = true;
            }
            vLy.setSelection(arrID, false, minScale, false);
        }
        if (showFilterWarning) {
            SwingUtilities.invokeLater(() -> {
                SelfClosingMessageBox msgBox = new SelfClosingMessageBox((Window)WorkbenchContext.getFrame(), I18N.get("de.riwagis.gis.context.jump.MapContextImpl.fidfilter-warning"), 3000);
                msgBox.setVisible(true);
            });
        }
    }

    public void setSelectionByFilter(Map<String, ColumnFilter> selection, boolean activateLayers, boolean zoom, double minScale, boolean openFeatureInfo) {
        Tasks.submit(() -> {
            if (!this.isSelectionSizePerLayerValidOrWarnUser(selection.entrySet().stream().map(kv -> Map.entry((String)kv.getKey(), ((ColumnFilter)kv.getValue()).getValues().size())))) {
                return;
            }
            new SelectByFilterAction().selectByFilter(this, selection, activateLayers, zoom, minScale, openFeatureInfo);
        });
    }

    public void zoomGeometry(Geometry geom, double minScale, Runnable doAfterZooming, String crsCode) throws Exception {
        Geometry finalGeom;
        if (geom == null || geom.isEmpty()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)crsCode) && StringUtils.isNotBlank((CharSequence)this.getCrsCode())) {
            Transformer trans = new Transformer(crsCode, this.getCrsCode());
            finalGeom = (Geometry)geom.clone();
            trans.transform2d(finalGeom);
        } else {
            finalGeom = geom;
        }
        Runnable highLight = () -> {
            try {
                boolean bolDurable = this.pBB.get(SELECTION_MARKER_DURABLE, true);
                if (bolDurable) {
                    LayerViewPanel lvp = this.frmTask.getLayerViewPanel();
                    GenericOverlayFeature fPreview = new GenericOverlayFeature(finalGeom.buffer(lvp.getViewport().getEnvelopeInModelCoordinates().getHeight() / 30.0), (Stroke)new BasicStroke(2.0f), Color.RED, (Stroke)new BasicStroke(), new Color(0, 0, 0, 0));
                    GenericOverlayPlugin.addFeature(SELECTION_MARKER_GEOMETRY, fPreview);
                    lvp.copyTo();
                } else {
                    double dblPixScale = this.frmTask.getLayerViewPanel().getViewport().getScale();
                    GUIUtil.invokeOnEventThreadLater(() -> {
                        try {
                            double dblBuf = 15.0 / dblPixScale;
                            GeometryCollection gcol = gfac.createGeometryCollection(new Geometry[]{finalGeom.buffer(dblBuf)});
                            this.frmTask.getLayerViewPanel().flash(gcol, Color.BLUE, 300);
                            dblBuf = 10.0 / dblPixScale;
                            gcol = gfac.createGeometryCollection(new Geometry[]{finalGeom.buffer(dblBuf)});
                            this.frmTask.getLayerViewPanel().flash(gcol, Color.BLUE, 300);
                            dblBuf = 5.0 / dblPixScale;
                            gcol = gfac.createGeometryCollection(new Geometry[]{finalGeom.buffer(dblBuf)});
                            this.frmTask.getLayerViewPanel().flash(gcol, Color.BLUE, 300);
                            gcol = gfac.createGeometryCollection(new Geometry[]{finalGeom});
                            this.frmTask.getLayerViewPanel().flash(gcol, Color.BLUE, 200);
                            Thread.sleep(200L);
                            gcol = gfac.createGeometryCollection(new Geometry[]{finalGeom});
                            this.frmTask.getLayerViewPanel().flash(gcol, Color.BLUE, 200);
                            Thread.sleep(200L);
                            gcol = gfac.createGeometryCollection(new Geometry[]{finalGeom});
                            this.frmTask.getLayerViewPanel().flash(gcol, Color.BLUE, 200);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                if (doAfterZooming != null) {
                    doAfterZooming.run();
                }
            }
            catch (Exception e) {
                WorkbenchContext.getFrame().handleThrowable(e);
                LOG.error("Error zooming to Geometry", (Throwable)e);
            }
        };
        this.zoomEnvelope(finalGeom.getEnvelopeInternal(), minScale, highLight);
    }

    public void zoomEnvelope(Envelope env, Runnable doAfterZooming) throws Exception {
        if (env != null && !env.isNull()) {
            Envelope finalEnv;
            String crsSource = MapContextImpl.retrieveCrs4Envelope(env);
            String crsTarget = this.getCrsCode();
            if (crsSource != null && StringUtils.isNotBlank((CharSequence)crsTarget)) {
                Transformer trans = new Transformer(crsSource, crsTarget);
                finalEnv = new Envelope(env);
                trans.transform2d(finalEnv);
            } else {
                finalEnv = env;
            }
            final AtomicBoolean bolRenderingReady = new AtomicBoolean(false);
            RenderingListener listener = new RenderingListener(){

                @Override
                public void renderingStarted(LayerViewPanel panel) {
                    bolRenderingReady.set(false);
                }

                @Override
                public void renderingStopped(LayerViewPanel panel) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("zoomEnvelope - Rendering stopped fired");
                    }
                    bolRenderingReady.set(true);
                }
            };
            this.frmTask.getLayerViewPanel().getRenderingManager().addRenderingListener(listener);
            Runnable zoomer = () -> {
                try {
                    this.frmTask.getLayerViewPanel().getViewport().zoom(finalEnv);
                    int maxCount = 300;
                    int count = 0;
                    int readyCount = 0;
                    while (readyCount < 4) {
                        Thread.sleep(50L);
                        if (count > maxCount) break;
                        ++count;
                        if (bolRenderingReady.get()) {
                            ++readyCount;
                            continue;
                        }
                        readyCount = 0;
                    }
                    if (doAfterZooming != null) {
                        doAfterZooming.run();
                    }
                }
                catch (Exception e) {
                    LOG.error("Error zooming to envelope.", (Throwable)e);
                }
                finally {
                    this.frmTask.getLayerViewPanel().getRenderingManager().removeRenderingListener(listener);
                }
            };
            Thread th = new Thread(zoomer);
            th.start();
        }
    }

    public boolean isInitialized() {
        return this.frmTask.getLayerViewPanel().isInitialized() && FirstTaskPlugIn.isInitialized();
    }

    public boolean isRendering() {
        return this.frmTask.getLayerViewPanel().getRenderingManager().isRendering();
    }

    public void zoomEnvelope(Envelope env, double dblMinScale, Runnable doAfterZooming) throws Exception {
        if (env != null && !env.isNull()) {
            Envelope newEnv;
            String crsSource = MapContextImpl.retrieveCrs4Envelope(env);
            String crsTarget = this.getCrsCode();
            if (crsSource != null && StringUtils.isNotBlank((CharSequence)crsTarget)) {
                Transformer trans = new Transformer(crsSource, crsTarget);
                env = new Envelope(env);
                trans.transform2d(env);
            }
            if ((newEnv = ScreenScale.getEnvelope4MapScale(this.frmTask.getLayerViewPanel().getViewport(), dblMinScale, this.frmTask.getTask().getDrawingUnit())).getWidth() > env.getWidth() && newEnv.getHeight() > env.getHeight()) {
                double dblCenterX = env.centre().x;
                double dblCenterY = env.centre().y;
                env = new Envelope(dblCenterX - newEnv.getWidth() / 2.0, dblCenterX + newEnv.getWidth() / 2.0, dblCenterY - newEnv.getHeight() / 2.0, dblCenterY + newEnv.getHeight() / 2.0);
            }
            this.zoomEnvelope(env, doAfterZooming);
        }
    }

    public void zoomScale(double dblScale) throws Exception {
        Envelope newEnv = ScreenScale.getEnvelope4MapScale(this.frmTask.getLayerViewPanel().getViewport(), dblScale, this.frmTask.getTask().getDrawingUnit());
        this.zoomEnvelope(newEnv, null);
    }

    public Envelope getEnvelope() {
        return this.frmTask.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
    }

    public Coordinate getCoordinate(String strMessage) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new Exception("Method getCoordinate should not be used on swing thread.");
        }
        GetCoordinateTool getCoordTool = new GetCoordinateTool();
        getCoordTool.setDescription(strMessage);
        Object[] arrResult = new Object[1];
        CountDownLatch latch = new CountDownLatch(1);
        getCoordTool.addOnceActionListener(e -> {
            arrResult[0] = getCoordTool.getClickedCoordinate();
            latch.countDown();
        });
        QuasimodeTool tmpTool = new QuasimodeTool(getCoordTool).add(new ModifierKeySpec(true, false, false), null);
        SwingUtilities.invokeLater(() -> {
            WorkbenchContext.getFrame().getDesktopPanel().setRightTabsVisible(true);
            this.frmTask.getLayerViewPanel().setCurrentCursorTool(tmpTool);
        });
        if (!latch.await(1L, TimeUnit.MINUTES)) {
            LOG.warn("Coordinate was not returned within 60 seconds");
            if (this.frmTask.getLayerViewPanel().getCurrentCursorTool() == tmpTool) {
                EditingPanel.instanceOf().activateDefaultCT();
            }
            return null;
        }
        return (Coordinate)arrResult[0];
    }

    public double getScale() {
        return this.frmTask.getTask().getScale();
    }

    public LayerContext getMapLayer(String id) {
        Layerable ly = this.layerManager.getLayerableByKey(id);
        if (ly == null) {
            return null;
        }
        if (ly instanceof Layer) {
            return ((Layer)ly).getVectorLayerContext();
        }
        if (ly instanceof WMSLayer) {
            return ((WMSLayer)ly).getWMSLayerContext();
        }
        if (ly instanceof WMTSLayer) {
            return ((WMTSLayer)ly).getWMTSLayerContext();
        }
        return null;
    }

    public LayerContext[] getMapLayersByName(String name) {
        ArrayList<Object> lstLayers = new ArrayList<Object>();
        for (Layer layer : this.layerManager) {
            if (!layer.getName().equals(name)) continue;
            lstLayers.add(layer.getVectorLayerContext());
        }
        for (WMSLayer wMSLayer : this.layerManager.getLayerables(WMSLayer.class)) {
            if (!wMSLayer.getName().equals(name)) continue;
            lstLayers.add(wMSLayer.getWMSLayerContext());
        }
        for (WMTSLayer wMTSLayer : this.layerManager.getLayerables(WMTSLayer.class)) {
            if (!wMTSLayer.getName().equals(name)) continue;
            lstLayers.add(wMTSLayer.getWMTSLayerContext());
        }
        return lstLayers.toArray(new LayerContext[0]);
    }

    public LayerContext[] getMapLayers() {
        ArrayList<Object> lstLayers = new ArrayList<Object>();
        for (Layer layer : this.layerManager) {
            lstLayers.add(layer.getVectorLayerContext());
        }
        for (WMSLayer wMSLayer : this.layerManager.getLayerables(WMSLayer.class)) {
            lstLayers.add(wMSLayer.getWMSLayerContext());
        }
        for (WMTSLayer wMTSLayer : this.layerManager.getLayerables(WMTSLayer.class)) {
            lstLayers.add(wMTSLayer.getWMTSLayerContext());
        }
        return lstLayers.toArray(new LayerContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMarker(Point createPoint) {
        try {
            Layer markerLayer;
            LayerManager layerman = JUMPWorkbench.getContext().getLayerManager();
            if (markerLayerKey == null) {
                markerLayerKey = layerman.uniqueLayerKey("Marker");
            }
            if ((markerLayer = layerman.getLayerByKey(markerLayerKey)) == null) {
                RedlineLayer tmpMarkerLayer = new RedlineLayer(markerLayerKey, layerman);
                Category selectedCategory = layerman.addCategory("Marker");
                selectedCategory.add(0, tmpMarkerLayer);
                markerLayer = tmpMarkerLayer;
            }
            ArrayList<SimpleFeature> feats = new ArrayList<SimpleFeature>();
            SimpleFeature f = FeatureUtil.createFeature((SimpleFeatureType)markerLayer.getFeatureType(), (Geometry)createPoint);
            boolean saveDefaultFeature = false;
            try {
                if (markerLayer instanceof RedlineLayer) {
                    saveDefaultFeature = ((AbstractCadLayer)markerLayer).getUseDefaultFeature();
                    FeatureUtil.copyFeatureData((SimpleFeature)((AbstractCadLayer)markerLayer).getDefaultFeature(), (SimpleFeature)f);
                }
                f.setAttribute("symbol", (Object)"pin.svg");
                f.setDefaultGeometry((Object)createPoint);
                feats.add(f);
                markerLayer.editFeature(feats, 1);
            }
            finally {
                if (markerLayer instanceof RedlineLayer) {
                    ((AbstractCadLayer)markerLayer).setUseDefaultFeature(saveDefaultFeature);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error creating marker at coordinate:" + String.valueOf(createPoint), (Throwable)ex);
        }
    }

    public void setFIDFilter(Map<String, String[]> mapFilter, boolean setVisible) throws Exception {
        this.invokeFidFilterActionOnLayer(mapFilter, VectorLayerContextImpl::setFIDFilter);
    }

    public void addFIDFilter(Map<String, String[]> mapFilter, boolean setVisible) throws Exception {
        this.invokeFidFilterActionOnLayer(mapFilter, VectorLayerContextImpl::addFIDFilter);
    }

    public void removeFIDFilter(Map<String, String[]> mapFilter, boolean setVisible) throws Exception {
        this.invokeFidFilterActionOnLayer(mapFilter, VectorLayerContextImpl::removeFIDFilter);
    }

    private void invokeFidFilterActionOnLayer(Map<String, String[]> mapFilter, BiConsumer<VectorLayerContextImpl, String[]> layerAndFidConsumer) throws Exception {
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        Runnable work = () -> {
            try {
                for (Map.Entry entrySet : mapFilter.entrySet()) {
                    String strLayerID = (String)entrySet.getKey();
                    String[] arrID = (String[])entrySet.getValue();
                    LayerContext ly = this.getMapLayer(strLayerID);
                    if (!(ly instanceof VectorLayerContext)) continue;
                    VectorLayerContextImpl vLy = (VectorLayerContextImpl)ly;
                    layerAndFidConsumer.accept(vLy, arrID);
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
    }

    public void resetFIDFilter(String ... layerKeys) {
        for (String currLayerKey : layerKeys) {
            LayerContext lyctx = this.getMapLayer(currLayerKey);
            if (lyctx == null) continue;
            VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
            vlyctx.setFIDFilter(null);
        }
    }

    public void addOverlayFeature(String featureID, OverlayFeatureDef feature) throws Exception {
        Geometry localGeom = this.transformGeometry(feature.getGeometry(), feature.getEpsgCode());
        GenericOverlayFeature feat = new GenericOverlayFeature(localGeom, feature.getLineStroke(), feature.getLineColor(), feature.getFillStroke(), feature.getFillColor(), feature.getSymbol(), feature.getSymbolSize(), feature.getOrientation());
        GenericOverlayPlugin.addFeature(featureID, feat);
    }

    public void removeOverlayFeature(String featureID) {
        GenericOverlayPlugin.removeFeature(featureID);
    }

    public void setOverlayFeatureVisible(String featureID, boolean isVisible) {
        GenericOverlayPlugin.setVisible(featureID, isVisible);
    }

    public void addGeometry(Geometry geom, Integer epsgCode) throws Exception {
        Geometry localGeom = this.transformGeometry(geom, epsgCode);
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        if (!GPSNMEALayerUtils.canCreatePoints(ly)) {
            throw new Exception(MessageFormat.format(I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.no-points-allowed-in-layer"), ly == null ? "---" : ly.getName()));
        }
        UndoableCommand cmd = FeatureDrawingUtil.createAddCommand(localGeom, JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false), WorkbenchContext.getInstance().getLayerViewPanel(), "");
        AbstractPlugIn.execute(cmd, (LayerManagerProxy)WorkbenchContext.getInstance());
        SaveLayerFeatureChangesPlugIn.commitLayer(ly, true, false, false);
    }

    private Geometry transformGeometry(Geometry geom, Integer epsgCode) throws Exception {
        CoordinateReferenceSystem crsSrc;
        CoordinateReferenceSystem crsDst = WorkbenchContext.getTask() != null && WorkbenchContext.getTask().getCRSDefinition() != null && WorkbenchContext.getTask().getCRSDefinition().getCRS() != null ? WorkbenchContext.getTask().getCRSDefinition().getCRS() : null;
        if (crsDst != null && !Objects.equals(crsSrc = CRS.decode((String)("EPSG:" + epsgCode)), crsDst)) {
            Transformer trans = new Transformer(crsSrc, crsDst);
            trans.transform2d(geom);
        }
        return geom;
    }

    public void zoomToLayer(String layername) throws Exception {
        Envelope env = new Envelope();
        for (LayerContext c : this.getMapLayers()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)layername, (CharSequence)c.getName()) && !StringUtils.equalsIgnoreCase((CharSequence)layername, (CharSequence)c.getID())) continue;
            LOG.debug(String.format("layer '%s' (ID: '%s') found", c.getName(), c.getID()));
            c.setVisible(true);
            Layer ly = JUMPWorkbench.getContext().getLayerManager().getLayerByKey(c.getID());
            if (ly == null || ly.getEnvelope() == null || ly.getEnvelope().isNull()) continue;
            env.expandToInclude(ly.getEnvelope());
        }
        if (!env.isNull()) {
            this.zoomEnvelope(EnvelopeUtil.bufferByFraction(env, 0.03), 500.0, null);
        }
    }

    public void selectInLayer(String layername, String cql, boolean zoomTo) throws Exception {
        for (LayerContext c : this.getMapLayers()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)layername, (CharSequence)c.getName()) && !StringUtils.equalsIgnoreCase((CharSequence)layername, (CharSequence)c.getID())) continue;
            LOG.debug(String.format("layer '%s' (ID: '%s') found", c.getName(), c.getID()));
            c.setVisible(true);
            if (c.getType() != 1 || !(c instanceof VectorLayerContext)) continue;
            VectorLayerContext vlc = (VectorLayerContext)c;
            vlc.setSelectionByFilter(CQL.toFilter((String)cql), zoomTo, 100.0, true);
        }
    }

    public File exportFile(Map<String, Object> reportData, File templateFile, Map<String, Object> extraParameters, File tempDir) throws GisInterfaceException {
        try {
            return MapContextPrint.exportFile(reportData, templateFile, extraParameters, tempDir);
        }
        catch (SystemException | IOException ex) {
            throw new GisInterfaceException(String.format("error exporting report file with local db: %s", ex.getMessage()), ex);
        }
    }

    public File exportFileLocalDB(Map<String, Object> reportData, File templateFile, Map<String, Object> extraParameters, File tempDir, ReportFilePersist ps) throws GisInterfaceException {
        try {
            return MapContextPrint.exportFileLocalDB(reportData, templateFile, extraParameters, tempDir, ps);
        }
        catch (SystemException | IOException ex) {
            throw new GisInterfaceException(String.format("error exporting report file with local db: %s", ex.getMessage()), ex);
        }
    }

    public void startGuidedSelection(GuidedSelection guidedSelection) {
        new GuidedSelectionDialog(guidedSelection);
    }

    private boolean isSelectionSizePerLayerValidOrWarnUser(Stream<Map.Entry<String, Integer>> selectionPerLayer) {
        boolean hasInvalidSelectionSize = selectionPerLayer.anyMatch(kv -> {
            LayerContext layer = this.getMapLayer((String)kv.getKey());
            if (!(layer instanceof VectorLayerContextImpl)) {
                return false;
            }
            Layer wrappedLayer = ((VectorLayerContextImpl)layer).getWrappedLayer();
            if (wrappedLayer.getCacheAll()) {
                return false;
            }
            return (Integer)kv.getValue() > 20000;
        });
        if (hasInvalidSelectionSize) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.getMessage("de.riwagis.gis.context.jump.MapContextImpl.too-big-selection-warning", 20000), I18N.get("ui.WorkbenchFrame.warning"), 2));
        }
        return !hasInvalidSelectionSize;
    }
}

