/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.jump;

import com.vividsolutions.jump.workbench.JUMPConfiguration;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.FirstTaskPlugIn;
import de.riwagis.gis.context.map.Gis3DContext;
import de.riwagis.gis.context.map.MapAppContext;
import de.riwagis.gis.context.map.MapContext;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapAppContextImpl
implements MapAppContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapAppContextImpl.class);
    private final WorkbenchContext context = WorkbenchContext.getInstance();

    public boolean reloadModuleContext() {
        FirstTaskPlugIn.setInitialized(false);
        for (JInternalFrame arrFrame : JUMPWorkbench.getFrame().getInternalFrames()) {
            boolean bolClosed;
            if (!(arrFrame instanceof TaskFrame) || (bolClosed = ((TaskFrame)arrFrame).closeTaskFrame(false))) continue;
            return false;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                JUMPConfiguration.loadGisContextMenus();
            }
            catch (Exception ex) {
                log.error("Could not load gis context menus", (Throwable)ex);
            }
        });
        for (PlugIn plugIn : JUMPWorkbench.getAllBuiltInPlugIns()) {
            plugIn.resetModuleContextCache();
        }
        FirstTaskPlugIn.loadInitialTaskFile();
        return true;
    }

    public MapContext[] getMaps() throws Exception {
        ArrayList<MapContext> lstMaps = new ArrayList<MapContext>();
        for (JInternalFrame arrFrame : this.getFrame().getInternalFrames()) {
            if (!(arrFrame instanceof TaskFrame)) continue;
            lstMaps.add(((TaskFrame)arrFrame).getTask().getLayerManager().getMapContext());
        }
        return (MapContext[])lstMaps.toArray(MapContext[]::new);
    }

    public MapContext getActiveMap() {
        if (this.context.getLayerViewPanel() == null) {
            return null;
        }
        if (WorkbenchContext.getTask() != null) {
            return WorkbenchContext.getTask().getLayerManager().getMapContext();
        }
        return null;
    }

    public MapContext getMap(String mapName) throws Exception {
        for (MapContext arrMapContext1 : this.getMaps()) {
            if (!arrMapContext1.getName().equals(mapName)) continue;
            return arrMapContext1;
        }
        return null;
    }

    public WorkbenchFrame getFrame() {
        return JUMPWorkbench.getFrame();
    }

    public Gis3DContext getGIS3DContext() {
        return Gis3DContextImpl.getInstance();
    }

    public void setBlackboardValue(String blackboardAction, Object value) {
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            PersistentBlackboardPlugIn.get().put("SHOW_MODULE_INFO", boolValue);
        }
    }

    public Optional<Object> getBlackboardValue(String blackboardAction) {
        return Optional.of(PersistentBlackboardPlugIn.get().get("SHOW_MODULE_INFO", true));
    }
}

