/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wmts;

import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.Parser;
import com.vividsolutions.ows.wmts.Dimension;
import com.vividsolutions.ows.wmts.Layer;
import com.vividsolutions.ows.wmts.Style;
import com.vividsolutions.ows.wmts.TileMatrix;
import com.vividsolutions.ows.wmts.TileMatrixLimits;
import com.vividsolutions.ows.wmts.TileMatrixSet;
import com.vividsolutions.ows.wmts.TileMatrixSetLink;
import com.vividsolutions.ows.wmts.WMTSCapabilities;
import com.vividsolutions.ows.wmts.WMTService;
import de.riwagis.util.xml.XMLSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSParser
extends Parser {
    private static final Logger LOG = LoggerFactory.getLogger(WMTSParser.class);
    public static final String TAG_CONTENTS = "Contents";

    @Override
    public WMTSCapabilities parseCapabilities(OWService service, InputStream inStream) throws IOException {
        try {
            Document doc = XMLSupport.build((InputStream)inStream);
            Element rootElement = doc.getRootElement();
            Namespace ns = rootElement.getNamespace();
            Namespace nsOWS = rootElement.getNamespace("ows");
            Element serviceElement = rootElement.getChild("ServiceIdentification", nsOWS);
            String title = "Unknown";
            long timestamp = 0L;
            if (serviceElement != null) {
                title = serviceElement.getChildText("Title", nsOWS);
                Element keywordsElement = serviceElement.getChild("Keywords", nsOWS);
                if (keywordsElement != null) {
                    for (Element keywordElement : keywordsElement.getChildren("Keyword", nsOWS)) {
                        String text = keywordElement.getText();
                        if (!StringUtils.startsWith((CharSequence)text, (CharSequence)"timestamp:")) continue;
                        timestamp = Long.parseLong(text.split(":")[1]);
                    }
                }
            }
            Element contentsElement = rootElement.getChild(TAG_CONTENTS, ns);
            HashMap<String, TileMatrixSet> tileMatrixSets = new HashMap<String, TileMatrixSet>();
            for (Element tileMatrixSetElement : contentsElement.getChildren("TileMatrixSet", ns)) {
                String tmsIdentifier = tileMatrixSetElement.getChildText("Identifier", nsOWS);
                TileMatrixSet tms = new TileMatrixSet();
                tms.setIdentifier(tmsIdentifier);
                String supportedCRS = tileMatrixSetElement.getChildText("SupportedCRS", nsOWS);
                tms.setSupportedCRS(supportedCRS);
                Element boundingBoxElement = tileMatrixSetElement.getChild("BoundingBox", nsOWS);
                if (boundingBoxElement != null) {
                    String lowerCornerText = boundingBoxElement.getChildText("LowerCorner", nsOWS);
                    String upperCornerText = boundingBoxElement.getChildText("UpperCorner", nsOWS);
                    String[] lowerCornerArray = lowerCornerText.split(" ");
                    String[] upperCornerArray = upperCornerText.split(" ");
                    double x1 = Double.parseDouble(lowerCornerArray[0]);
                    double x2 = Double.parseDouble(upperCornerArray[0]);
                    double y1 = Double.parseDouble(lowerCornerArray[1]);
                    double y2 = Double.parseDouble(upperCornerArray[1]);
                    ReferencedEnvelope bounds = new ReferencedEnvelope(x1, x2, y1, y2, null);
                    tms.setBounds((Envelope)bounds);
                }
                tileMatrixSets.put(tmsIdentifier, tms);
                for (Element tileMatrixElement : tileMatrixSetElement.getChildren("TileMatrix", ns)) {
                    TileMatrix tileMatrix = new TileMatrix(tms);
                    String tmIdentifier = tileMatrixElement.getChildText("Identifier", nsOWS);
                    tileMatrix.setIdentifier(tmIdentifier);
                    double scaleDenominator = Double.parseDouble(tileMatrixElement.getChildText("ScaleDenominator", ns));
                    tileMatrix.setScaleDenominator(scaleDenominator);
                    int tileHeight = Integer.parseInt(tileMatrixElement.getChildText("TileHeight", ns));
                    tileMatrix.setTileHeight(tileHeight);
                    int tileWidth = Integer.parseInt(tileMatrixElement.getChildText("TileWidth", ns));
                    tileMatrix.setTileWidth(tileWidth);
                    int matrixWidth = Integer.parseInt(tileMatrixElement.getChildText("MatrixWidth", ns));
                    tileMatrix.setMatrixWidth(matrixWidth);
                    int matrixHeight = Integer.parseInt(tileMatrixElement.getChildText("MatrixHeight", ns));
                    tileMatrix.setMatrixHeight(matrixHeight);
                    String topLeftCorner = tileMatrixElement.getChildText("TopLeftCorner", ns);
                    tileMatrix.setTopLeftCorner(topLeftCorner);
                    tms.addTileMatrix(tileMatrix);
                }
            }
            HashMap<String, Layer> layers = new HashMap<String, Layer>();
            for (Element layerElement : contentsElement.getChildren("Layer", ns)) {
                Element wgs84BoundingBoxElement;
                Layer layer = new Layer();
                String layerTitle = layerElement.getChildText("Title", nsOWS);
                layer.setTitle(layerTitle);
                String layerAbstract = layerElement.getChildText("abstract", nsOWS);
                String layerIdentifier = layerElement.getChildText("Identifier", nsOWS);
                layer.setIdentifier(layerIdentifier);
                Element layerKeywordsElement = layerElement.getChild("Keywords", nsOWS);
                if (layerKeywordsElement != null) {
                    for (Element keywordElement : layerKeywordsElement.getChildren("Keyword", nsOWS)) {
                        String text = keywordElement.getText();
                        layer.addKeyword(text);
                    }
                }
                if ((wgs84BoundingBoxElement = layerElement.getChild("WGS84BoundingBox", nsOWS)) != null) {
                    Iterator lowerCornerText = wgs84BoundingBoxElement.getChildText("LowerCorner", nsOWS);
                    String upperCornerText = wgs84BoundingBoxElement.getChildText("UpperCorner", nsOWS);
                    String[] lowerCornerArray = ((String)((Object)lowerCornerText)).split(" ");
                    String[] upperCornerArray = upperCornerText.split(" ");
                    double x1 = Double.parseDouble(lowerCornerArray[0]);
                    double x2 = Double.parseDouble(upperCornerArray[0]);
                    double y1 = Double.parseDouble(lowerCornerArray[1]);
                    double y2 = Double.parseDouble(upperCornerArray[1]);
                    ReferencedEnvelope wgs84BoundingBox = new ReferencedEnvelope(x1, x2, y1, y2, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    layer.setWGS84BoundingBox(wgs84BoundingBox);
                }
                for (Element formatElement : layerElement.getChildren("Format", ns)) {
                    layer.addFormat(formatElement.getText());
                }
                for (Element infoFormatElement : layerElement.getChildren("InfoFormat", ns)) {
                    layer.addInfoFormat(infoFormatElement.getText());
                }
                LinkedList<Style> styleList = new LinkedList<Style>();
                for (Element styleElement : layerElement.getChildren("Style", ns)) {
                    Style style = new Style();
                    if (styleElement.getAttribute("isDefault") != null) {
                        style.setDefault(Boolean.parseBoolean(styleElement.getAttributeValue("isDefault")));
                    }
                    style.setIdentifier(styleElement.getChildText("Identifier", nsOWS));
                    style.setTitle(styleElement.getChildText("Title", nsOWS));
                    Element legendURLElement = styleElement.getChild("LegendURL", ns);
                    if (legendURLElement != null) {
                        style.setLegendFormat(legendURLElement.getAttributeValue("format"));
                        style.setLegendURL(legendURLElement.getAttributeValue("href", rootElement.getNamespace("xlink")));
                    }
                    styleList.add(style);
                    layer.addStyle(style);
                }
                for (Element tileMatrixSetLinkElement : layerElement.getChildren("TileMatrixSetLink", ns)) {
                    TileMatrixSetLink tileMatrixSetLink = new TileMatrixSetLink();
                    String tileMatrixSetIdentifier = tileMatrixSetLinkElement.getChildText("TileMatrixSet", ns);
                    tileMatrixSetLink.setTileMatrixSet(tileMatrixSetIdentifier);
                    Element tileMatrixSetLimitsElement = tileMatrixSetLinkElement.getChild("TileMatrixSetLimits", ns);
                    if (tileMatrixSetLimitsElement != null) {
                        for (Element tileMatrixLimitElement : tileMatrixSetLimitsElement.getChildren("TileMatrixLimits", ns)) {
                            String tileMatrixIdentifier = tileMatrixLimitElement.getChildText("TileMatrix", ns);
                            int minTileRow = Integer.parseInt(tileMatrixLimitElement.getChildText("MinTileRow", ns));
                            int maxTileRow = Integer.parseInt(tileMatrixLimitElement.getChildText("MaxTileRow", ns));
                            int minTileCol = Integer.parseInt(tileMatrixLimitElement.getChildText("MinTileCol", ns));
                            int maxTileCol = Integer.parseInt(tileMatrixLimitElement.getChildText("MaxTileCol", ns));
                            TileMatrixLimits tileMatrixLimits = new TileMatrixLimits();
                            tileMatrixLimits.setTileMatrixIdentifier(tileMatrixIdentifier);
                            tileMatrixLimits.setMinTileRow(minTileRow);
                            tileMatrixLimits.setMaxTileRow(maxTileRow);
                            tileMatrixLimits.setMinTileCol(minTileCol);
                            tileMatrixLimits.setMaxTileCol(maxTileCol);
                            tileMatrixSetLink.addTileMatrixLimits(tileMatrixLimits);
                        }
                    }
                    layer.addTileMatrixSetLink(tileMatrixSetLink);
                }
                for (Element resourceURLElement : layerElement.getChildren("ResourceURL", ns)) {
                    String resourceType = resourceURLElement.getAttributeValue("resourceType");
                    String format = resourceURLElement.getAttributeValue("format");
                    String template = resourceURLElement.getAttributeValue("template");
                    if (resourceType.contains("tile")) {
                        layer.addGetTileResourceURL(format, template);
                        continue;
                    }
                    if (!resourceType.contains("FeatureInfo")) continue;
                    layer.addGetFeatureInfoResourceURL(format, template);
                }
                for (Element dimElement : layerElement.getChildren("Dimension", ns)) {
                    String id = dimElement.getChildText("Identifier", nsOWS);
                    String _default = dimElement.getChildText("Default", ns);
                    ArrayList<String> values = new ArrayList<String>();
                    for (Element dimValue : dimElement.getChildren("Value", ns)) {
                        values.add(dimValue.getText());
                    }
                    layer.addDimension(new Dimension(id, _default, values));
                }
                layers.put(layerIdentifier, layer);
            }
            return new WMTSCapabilities((WMTService)service, title, layers, tileMatrixSets, timestamp);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }
}

