/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wmts;

import com.vividsolutions.ows.wmts.TileMatrix;
import de.riwagis.crs.CRSDefFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import si.uom.SI;

public class TileMatrixSet {
    public static final String TAG = "TileMatrixSet";
    public static final String TAG_IDENTIFIER = "Identifier";
    public static final String TAG_SUPPORTED_CRS = "SupportedCRS";
    private static final Comparator<TileMatrix> priorityComparator = Comparator.comparingDouble(t -> t.getScaleDenominator()).reversed();
    private CoordinateReferenceSystem cachedCrs = null;
    private UnitConverter cachedUnitConverter = null;
    private String identifier;
    private String supportedCRS;
    private Envelope bounds;
    private final List<TileMatrix> tileMatrixes = new ArrayList<TileMatrix>();

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getSupportedCRS() {
        return this.supportedCRS;
    }

    public void setSupportedCRS(String supportedCRS) {
        this.supportedCRS = supportedCRS;
        this.cachedCrs = null;
        this.cachedUnitConverter = null;
    }

    public void setBounds(Envelope bounds) {
        this.bounds = bounds;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public boolean addTileMatrix(TileMatrix tileMatrix) {
        return this.tileMatrixes.add(tileMatrix);
    }

    public List<TileMatrix> getTileMatrices() {
        return this.tileMatrixes;
    }

    public List<TileMatrix> getTileMatricesByScaleDenominator() {
        return this.tileMatrixes.stream().sorted(priorityComparator).collect(Collectors.toList());
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() throws FactoryException {
        if (this.cachedCrs == null && StringUtils.isNotBlank((CharSequence)this.supportedCRS)) {
            this.cachedCrs = CRSDefFactory.createCRS((String)this.supportedCRS);
        }
        return this.cachedCrs;
    }

    public UnitConverter getUnitConverterInMeter() throws FactoryException, IncommensurableException {
        CoordinateReferenceSystem crs;
        if (this.cachedUnitConverter == null && (crs = this.getCoordinateReferenceSystem()) != null) {
            this.cachedUnitConverter = this.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getUnit().getConverterToAny(SI.METRE);
        }
        return this.cachedUnitConverter;
    }
}

