/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wmts;

import com.vividsolutions.ows.wmts.TileMatrixSet;
import javax.measure.IncommensurableException;
import org.opengis.referencing.FactoryException;

public class TileMatrix {
    public static final String TAG = "TileMatrix";
    public static final String TAG_IDENTIFIER = "Identifier";
    public static final String TAG_SCALE_DENOM = "ScaleDenominator";
    public static final String TAG_TOP_LEFT = "TopLeftCorner";
    public static final String TAG_TILE_WIDTH = "TileWidth";
    public static final String TAG_TILE_HEIGHT = "TileHeight";
    public static final String TAG_MATRIX_WIDTH = "MatrixWidth";
    public static final String TAG_MATRIX_HEIGHT = "MatrixHeight";
    private static final double SCALE_CONST = 2.8E-4;
    private final transient TileMatrixSet tileMatrixSet;
    private String identifier;
    private double scaleDenominator;
    private String topLeftCorner;
    private int tileWidth;
    private int tileHeight;
    private int matrixWidth;
    private int matrixHeight;

    public TileMatrix(TileMatrixSet tileMatrixSet) {
        this.tileMatrixSet = tileMatrixSet;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public double getScaleDenominator() {
        return this.scaleDenominator;
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public String getTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void setTopLeftCorner(String topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public int getMatrixWidth() {
        return this.matrixWidth;
    }

    public void setMatrixWidth(int matrixWidth) {
        this.matrixWidth = matrixWidth;
    }

    public int getMatrixHeight() {
        return this.matrixHeight;
    }

    public void setMatrixHeight(int matrixHeight) {
        this.matrixHeight = matrixHeight;
    }

    public double[] getTopLeft() {
        String[] topLeft = this.getTopLeftCorner().split(" ");
        return new double[]{Double.parseDouble(topLeft[0]), Double.parseDouble(topLeft[1])};
    }

    public double computeTileSpanX() {
        return this.computeTileSpan(this.getTileWidth());
    }

    public double computeTileSpanY() {
        return this.computeTileSpan(this.getTileHeight());
    }

    private double computeTileSpan(int tilePixel) {
        return 2.8E-4 / this.metersPerUnit() * this.scaleDenominator * (double)tilePixel;
    }

    private double metersPerUnit() {
        double metersPerUnit = 1.0;
        try {
            if (this.tileMatrixSet.getUnitConverterInMeter() != null) {
                metersPerUnit = this.tileMatrixSet.getUnitConverterInMeter().convert(1.0);
            }
            return metersPerUnit;
        }
        catch (IncommensurableException | FactoryException fe) {
            throw new RuntimeException(String.format("Error at unit conversion to meter at CRS with Code '%s'.", this.tileMatrixSet.getSupportedCRS()), fe);
        }
    }
}

