/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wmts;

import com.vividsolutions.ows.wmts.Dimension;
import com.vividsolutions.ows.wmts.Style;
import com.vividsolutions.ows.wmts.TileMatrixLimits;
import com.vividsolutions.ows.wmts.TileMatrixSetLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Layer {
    private static final Logger LOG = LoggerFactory.getLogger(Layer.class);
    public static final String TAG = "Layer";
    public static final String TAG_TITLE = "Title";
    public static final String TAG_IDENTIFIER = "Identifier";
    public static final String TAG_FORMAT = "Format";
    public static final String TAG_INFO_FORMAT = "InfoFormat";
    public static final String TAG_STYLE = "Style";
    public static final String TAG_KEYWORDS = "Keywords";
    public static final String TAG_KEYWORD = "Keyword";
    public static final String KEY_PRIORITY = "layerpriority";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEYWORD_KEY_VALUE_SEP = ":";
    public static final String PRIORITY_IDENT = "layerpriority:";
    public static final String TIMESTAMP_IDENT = "timestamp:";
    private String title;
    private String identifier;
    private ReferencedEnvelope wgs84BoundingBox;
    private final List<String> keywords = new ArrayList<String>(2);
    private final List<String> formats = new ArrayList<String>(5);
    private final List<String> infoFormats = new ArrayList<String>(5);
    private final List<Style> styles = new ArrayList<Style>(1);
    private final Map<String, String> getTileResourceURLs = new HashMap<String, String>(5);
    private final Map<String, String> getFeatureInfoResourceURLs = new HashMap<String, String>(5);
    private final Map<String, String> getLegendGraphicsResourceURLs = new HashMap<String, String>(5);
    private final Map<String, TileMatrixSetLink> tileMatrixSetLinks = new HashMap<String, TileMatrixSetLink>();
    private final Map<String, Dimension> dimensions = new HashMap<String, Dimension>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void addKeyword(String keyword) {
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            this.keywords.add(keyword);
        }
    }

    public void addFormat(String format) {
        if (StringUtils.isNotEmpty((CharSequence)format)) {
            this.formats.add(format);
        }
    }

    public void addGetTileResourceURL(String format, String template) {
        if (StringUtils.isNotEmpty((CharSequence)format) && StringUtils.isNotEmpty((CharSequence)template)) {
            this.getTileResourceURLs.put(format, template);
        }
    }

    public String getTileResourceURL(String format) {
        return this.getTileResourceURLs.get(format);
    }

    public void addGetFeatureInfoResourceURL(String format, String template) {
        if (StringUtils.isNotEmpty((CharSequence)format) && StringUtils.isNotEmpty((CharSequence)template)) {
            this.getFeatureInfoResourceURLs.put(format, template);
        }
    }

    public String getFeatureInfoResourceURL(String format) {
        return this.getFeatureInfoResourceURLs.get(format);
    }

    public List<String> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public List<String> getInfoFormats() {
        return Collections.unmodifiableList(this.infoFormats);
    }

    public void addInfoFormat(String infoFormat) {
        if (StringUtils.isNotEmpty((CharSequence)infoFormat)) {
            this.infoFormats.add(infoFormat);
        }
    }

    public void addTileMatrixSetLink(TileMatrixSetLink tileMatrixSetLink) {
        this.tileMatrixSetLinks.put(tileMatrixSetLink.getTileMatrixSet(), tileMatrixSetLink);
    }

    public Collection<String> getTileMatrixSetLinks() {
        return this.tileMatrixSetLinks.keySet();
    }

    public TileMatrixLimits getTileMatrixSetLimits(String link, String tileMatrixIdentifier) {
        TileMatrixSetLink tileMatrixSetLink = this.tileMatrixSetLinks.get(link);
        if (tileMatrixSetLink == null) {
            return null;
        }
        return tileMatrixSetLink.getTileMatrixSetLimits(tileMatrixIdentifier);
    }

    public Integer getPriority() {
        Integer prio = null;
        for (String keyword : this.keywords) {
            if (!keyword.startsWith(PRIORITY_IDENT)) continue;
            try {
                prio = Integer.valueOf(keyword.substring(PRIORITY_IDENT.length()));
            }
            catch (Exception e) {
                LOG.error("Could not parse integer value of offline raster layer priority.");
            }
        }
        return prio;
    }

    public long getTimestamp() {
        long time = 0L;
        for (String keyword : this.keywords) {
            if (!keyword.startsWith(TIMESTAMP_IDENT)) continue;
            try {
                time = Long.valueOf(keyword.substring(TIMESTAMP_IDENT.length()));
            }
            catch (Exception e) {
                LOG.error("Could not parse value of offline raster layer timestamp.");
            }
        }
        return time;
    }

    void setWGS84BoundingBox(ReferencedEnvelope wgs84BoundingBox) {
        this.wgs84BoundingBox = wgs84BoundingBox;
    }

    public ReferencedEnvelope getWGS84BoundingBox() {
        return this.wgs84BoundingBox;
    }

    public void addStyle(Style style) {
        this.styles.add(style);
    }

    public List<Style> getStyles() {
        return Collections.unmodifiableList(this.styles);
    }

    public void addDimension(Dimension dimension) {
        this.dimensions.put(dimension.getIdentifier(), dimension);
    }

    public Collection<Dimension> getDimensions() {
        return Collections.unmodifiableCollection(this.dimensions.values());
    }

    public Dimension getDimensionByIdentifier(String id) {
        return this.dimensions.get(id);
    }
}

