/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.ows.wmts;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.ows.AbstractOWSRequest;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.wmts.Layer;
import com.vividsolutions.ows.wmts.WMTService;
import de.riwagis.util.thread.CancelableRunnable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTileRequest
extends AbstractOWSRequest {
    private static final Logger LOG = LoggerFactory.getLogger(GetTileRequest.class);
    private String layer;
    private String style;
    private String format;
    private String tileMatrixSet;
    private String tileMatrix;
    private int tileRow;
    private int tileCol;

    public GetTileRequest(OWService service) {
        super(service, "GetTile");
    }

    @Override
    public String getURL() {
        try {
            Layer layerModel = this.getService().getCapabilities().getLayerByName(this.layer);
            String template = layerModel.getTileResourceURL(this.format);
            if (StringUtils.isEmpty((CharSequence)template)) {
                StringBuilder sbURL = new StringBuilder();
                sbURL.append(super.getURL());
                sbURL.append("&").append("LAYER=").append(this.encode(this.layer));
                sbURL.append("&").append("STYLE=").append(this.encode(StringUtils.defaultString((String)this.style, (String)"")));
                sbURL.append("&").append("FORMAT=").append(this.encode(StringUtils.defaultString((String)this.format, (String)"image/png")));
                sbURL.append("&").append("TILEMATRIXSET=").append(this.encode(this.tileMatrixSet));
                sbURL.append("&").append("TILEMATRIX=").append(this.encode(this.tileMatrix));
                sbURL.append("&").append("TILEROW=").append(this.tileRow);
                sbURL.append("&").append("TILECOL=").append(this.tileCol);
                return sbURL.toString();
            }
            CaseInsensitiveLookup lookup = new CaseInsensitiveLookup();
            lookup.put("style", this.encode(StringUtils.defaultString((String)this.style, (String)"")));
            lookup.put("TileMatrixSet", this.encode(this.tileMatrixSet));
            lookup.put("TileMatrix", this.encode(this.tileMatrix));
            lookup.put("TileRow", Integer.toString(this.tileRow));
            lookup.put("TileCol", Integer.toString(this.tileCol));
            layerModel.getDimensions().forEach(dim -> lookup.put(dim.getIdentifier(), dim.get_default()));
            if (JUMPWorkbench.GIS_CONTEXT != null) {
                lookup.put("serverprefix", this.getService().getServerUrl());
            }
            StringSubstitutor sub = new StringSubstitutor((StringLookup)lookup);
            sub.setVariablePrefix("{");
            sub.setVariableSuffix("}");
            return sub.replace(template);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("error creating get tile request", (Throwable)ex);
            return null;
        }
    }

    private String encode(String unencoded) throws UnsupportedEncodingException {
        return URLEncoder.encode(unencoded, StandardCharsets.UTF_8).replace("+", "%20");
    }

    @Override
    public WMTService getService() {
        return (WMTService)super.getService();
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public void setTileMatrixSet(String tileMatrixSet) {
        this.tileMatrixSet = tileMatrixSet;
    }

    public String getTileMatrix() {
        return this.tileMatrix;
    }

    public void setTileMatrix(String tileMatrix) {
        this.tileMatrix = tileMatrix;
    }

    public int getTileRow() {
        return this.tileRow;
    }

    public void setTileRow(int tileRow) {
        this.tileRow = tileRow;
    }

    public int getTileCol() {
        return this.tileCol;
    }

    public void setTileCol(int tileCol) {
        this.tileCol = tileCol;
    }

    /*
     * Exception decompiling
     */
    public byte[] getImageData(CancelableRunnable cancelable) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class CaseInsensitiveLookup
    implements StringLookup {
        private final Map<String, String> valuesMap = new HashMap<String, String>();

        public void put(String key, String value) {
            this.valuesMap.put(key.toLowerCase(), value);
        }

        public String lookup(String key) {
            return this.valuesMap.get(key.toLowerCase());
        }
    }
}

